/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.decorators.PopupMenuAdapter;
import com.github.weisj.darklaf.ui.text.DarkCaret;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUIBridge;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class DarkTextFieldUI
extends DarkTextFieldUIBridge
implements PropertyChangeListener {
    protected static final String KEY_PREFIX = "JTextField.";
    public static final String KEY_VARIANT = "JTextField.variant";
    public static final String KEY_KEEP_SELECTION_ON_FOCUS_LOST = "JTextField.keepSelectionOnFocusLost";
    public static final String KEY_FIND_POPUP = "JTextField.Search.FindPopup";
    public static final String VARIANT_SEARCH = "search";
    protected static Icon clear;
    protected static Icon clearHover;
    protected static Icon search;
    protected static Icon searchWithHistory;
    protected int arcSize;
    protected int searchArcSize;
    protected int borderSize;
    protected Color background;
    protected Color inactiveBackground;
    private long lastSearchEvent;
    private final PopupMenuListener searchPopupListener = new PopupMenuAdapter(){

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DarkTextFieldUI.this.lastSearchEvent = System.currentTimeMillis();
        }
    };
    private boolean clearHovered;
    private final MouseMotionListener mouseMotionListener = e -> this.updateCursor(e.getPoint());
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            SwingUtilities.invokeLater(() -> {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, DarkTextFieldUI.this.getComponent());
                DarkTextFieldUI.this.updateCursor(p);
            });
        }
    };
    private final MouseListener mouseListener = e -> {
        ClickAction actionUnder = this.getActionUnder(e.getPoint());
        if (actionUnder == ClickAction.CLEAR) {
            this.getComponent().setText("");
        } else if (actionUnder == ClickAction.SEARCH_POPUP) {
            this.showSearchPopup();
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkTextFieldUI();
    }

    protected static Icon getClearIcon(boolean clearHovered) {
        return clearHovered ? clearHover : clear;
    }

    public static Rectangle getTextRect(JComponent c) {
        Insets i = c.getInsets();
        Dimension dim = c.getSize();
        return new Rectangle(i.left, i.top, dim.width - i.left - i.right, dim.height - i.top - i.bottom);
    }

    public static boolean isOver(Point p, Icon icon, Point e) {
        return new Rectangle(p.x, p.y, icon.getIconWidth(), icon.getIconHeight()).contains(e);
    }

    protected void updateCursor(Point p) {
        boolean insideTextArea;
        ClickAction action = this.getActionUnder(p);
        boolean oldClear = this.clearHovered;
        boolean bl = this.clearHovered = action == ClickAction.CLEAR;
        if (oldClear != this.clearHovered) {
            this.editor.repaint();
        }
        Rectangle drawRect = this.getDrawingRect(this.getComponent());
        Rectangle textRect = DarkTextFieldUI.getTextRect(this.getComponent());
        int rightBoundary = this.getComponent().getText().isEmpty() ? drawRect.x + drawRect.width : this.getClearIconCoord().x;
        boolean bl2 = insideTextArea = drawRect.contains(p) && p.x >= textRect.x && p.x < rightBoundary;
        if (insideTextArea) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(2));
        } else {
            Cursor cursor = action == ClickAction.NONE ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12);
            this.getComponent().setCursor(cursor);
        }
    }

    private ClickAction getActionUnder(Point p) {
        JTextComponent c = this.getComponent();
        if (DarkTextFieldUI.isSearchField(c)) {
            if (DarkTextFieldUI.isOver(this.getClearIconCoord(), DarkTextFieldUI.getClearIcon(this.clearHovered), p)) {
                return ClickAction.CLEAR;
            }
            if (DarkTextFieldUI.isOver(this.getSearchIconCoord(), DarkTextFieldUI.getSearchIcon(c), p)) {
                return ClickAction.SEARCH_POPUP;
            }
        }
        return ClickAction.NONE;
    }

    private static JPopupMenu getSearchPopup(JComponent c) {
        Object value = c.getClientProperty(KEY_FIND_POPUP);
        return value instanceof JPopupMenu ? (JPopupMenu)value : null;
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int w = DarkTextFieldUI.getSearchIcon(this.getComponent()).getIconWidth();
        return DarkUIUtil.adjustForOrientation(new Point(r.x + this.borderSize, r.y + (r.height - w) / 2), w, this.editor);
    }

    protected static Icon getSearchIcon(Component c) {
        return DarkTextFieldUI.isSearchFieldWithHistoryPopup(c) ? searchWithHistory : search;
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return DarkTextFieldUI.isSearchField(c) && DarkTextFieldUI.getSearchPopup((JComponent)c) != null;
    }

    public static boolean isSearchField(Component c) {
        return c instanceof JTextField && VARIANT_SEARCH.equals(((JTextField)c).getClientProperty(KEY_VARIANT));
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        GraphicsContext config = new GraphicsContext(g);
        if (DarkTextFieldUI.isSearchField(c)) {
            Container parent = c.getParent();
            if (c.isOpaque() && parent != null) {
                g.setColor(parent.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            this.paintSearchField(g, c);
        } else {
            super.paintBackground(g);
        }
        config.restore();
    }

    @Override
    public Rectangle getDrawingRect(JTextComponent c) {
        int w = this.borderSize;
        return new Rectangle(w, w, c.getWidth() - 2 * w, c.getHeight() - 2 * w);
    }

    @Override
    protected int getArcSize(JComponent c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchArcSize : this.arcSize;
    }

    private void paintClearIcon(Graphics2D g) {
        Point p = this.getClearIconCoord();
        DarkTextFieldUI.getClearIcon(this.clearHovered).paintIcon(null, g, p.x, p.y);
    }

    private void paintSearchIcon(Graphics2D g) {
        Point p = this.getSearchIconCoord();
        DarkTextFieldUI.getSearchIcon(this.getComponent()).paintIcon(null, g, p.x, p.y);
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int w = DarkTextFieldUI.getClearIcon(this.clearHovered).getIconWidth();
        return DarkUIUtil.adjustForOrientation(new Point(r.x + r.width - w - this.borderSize, r.y + (r.height - w) / 2), w, this.editor);
    }

    protected void showSearchPopup() {
        JPopupMenu menu;
        if ((this.lastSearchEvent == 0L || System.currentTimeMillis() - this.lastSearchEvent > 250L) && (menu = DarkTextFieldUI.getSearchPopup(this.getComponent())) != null) {
            menu.show(this.getComponent(), this.getSearchIconCoord().x, this.getComponent().getHeight());
        }
    }

    @Override
    protected DarkCaret.CaretStyle getDefaultCaretStyle() {
        return DarkCaret.CaretStyle.VERTICAL_LINE_STYLE;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.editor.putClientProperty(KEY_KEEP_SELECTION_ON_FOCUS_LOST, UIManager.getBoolean("TextField.keepSelectionOnFocusLost"));
        this.arcSize = UIManager.getInt("TextField.arc");
        this.borderSize = UIManager.getInt("TextField.borderThickness");
        this.searchArcSize = UIManager.getInt("TextField.searchArc");
        this.background = UIManager.getColor("TextField.background");
        this.inactiveBackground = UIManager.getColor("TextField.disabledBackground");
        clearHover = UIManager.getIcon("TextField.search.clearHover.icon");
        clear = UIManager.getIcon("TextField.search.clear.icon");
        searchWithHistory = UIManager.getIcon("TextField.search.searchWithHistory.icon");
        search = UIManager.getIcon("TextField.search.search.icon");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String key = evt.getPropertyName();
        if (KEY_FIND_POPUP.equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal instanceof JPopupMenu) {
                ((JPopupMenu)oldVal).removePopupMenuListener(this.searchPopupListener);
            }
            if (newVal instanceof JPopupMenu) {
                ((JPopupMenu)newVal).addPopupMenuListener(this.searchPopupListener);
            }
        } else if (KEY_VARIANT.equals(key)) {
            this.editor.doLayout();
            Container parent = this.editor.getParent();
            if (parent instanceof JComponent) {
                ((Component)parent).doLayout();
            }
            this.editor.repaint();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent c = this.getComponent();
        c.addMouseListener(this.mouseListener);
        c.addMouseMotionListener(this.mouseMotionListener);
        c.addKeyListener(this.keyListener);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent c = this.getComponent();
        c.removeMouseListener(this.mouseListener);
        c.removeMouseMotionListener(this.mouseMotionListener);
        c.removeKeyListener(this.keyListener);
    }

    protected void paintSearchField(Graphics2D g, JTextComponent c) {
        g.setColor(c.getBackground());
        Rectangle r = this.getDrawingRect(this.getComponent());
        int arc = this.getArcSize(c);
        DarkUIUtil.fillRoundRect(g, r.x, r.y, r.width, r.height, arc);
        this.paintSearchIcon(g);
        if (c.getText().length() > 0) {
            this.paintClearIcon(g);
        }
    }

    private static enum ClickAction {
        CLEAR,
        SEARCH_POPUP,
        NONE;

    }
}

