/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.ui.table.TextTableCellEditorBorder;
import com.github.weisj.darklaf.ui.text.DarkPasswordFieldUI;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarkTextBorder
implements Border,
UIResource {
    private static final Border editorBorder = new TextTableCellEditorBorder();
    protected Color errorBorderColor;
    protected Color focusErrorBorderColor = UIManager.getColor("TextField.border.focusError");
    protected Color focusBorderColor = UIManager.getColor("TextField.border.focus");
    protected Color borderColor;
    protected Color inactiveBorderColor;
    protected int borderSize;
    protected int arc;
    protected int searchArc;
    protected int focusArc;
    protected int searchFocusArc;
    protected Insets padding;
    protected Icon showIcon;

    public DarkTextBorder() {
        this.errorBorderColor = UIManager.getColor("TextField.border.error");
        this.borderColor = UIManager.getColor("TextField.border.enabled");
        this.inactiveBorderColor = UIManager.getColor("TextField.border.disabled");
        this.borderSize = UIManager.getInt("TextField.borderThickness");
        this.arc = UIManager.getInt("TextField.arc");
        this.focusArc = UIManager.getInt("TextField.focusArc");
        this.searchArc = UIManager.getInt("TextField.searchArc");
        this.searchFocusArc = UIManager.getInt("TextField.searchFocusArc");
        this.padding = UIManager.getInsets("TextField.insets");
        this.showIcon = UIManager.getIcon("PasswordField.show.icon");
        if (this.padding == null) {
            this.padding = new Insets(0, 0, 0, 0);
        }
    }

    protected static boolean hasError(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty("JTextComponent.hasError"));
    }

    protected static boolean isCellEditor(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty("JTextComponent.cellEditor"));
    }

    protected int getArcSize(Component c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchArc : this.arc;
    }

    protected int getFocusArcSize(Component c) {
        return DarkTextFieldUI.isSearchField(c) ? this.searchFocusArc : this.focusArc;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (DarkTextBorder.isCellEditor(c)) {
            editorBorder.paintBorder(c, g2, x, y, width, height);
            return;
        }
        Graphics2D g = (Graphics2D)g2;
        g.translate(x, y);
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        int arcSize = this.getArcSize(c);
        int focusArcSize = this.getFocusArcSize(c);
        if (DarkTextBorder.hasError(c)) {
            DarkUIUtil.paintOutlineBorder(g, width, height, focusArcSize, this.borderSize, c.hasFocus(), DarkUIUtil.Outline.error);
        } else if (c.hasFocus()) {
            DarkUIUtil.paintFocusBorder(g, width, height, focusArcSize, this.borderSize);
        }
        g.setColor(this.getBorderColor(c));
        DarkUIUtil.paintLineBorder(g, this.borderSize, this.borderSize, width - 2 * this.borderSize, height - 2 * this.borderSize, arcSize);
        g.translate(-x, -y);
        config.restore();
    }

    protected Color getBorderColor(Component c) {
        boolean editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
        boolean focus = DarkUIUtil.hasFocus(c);
        boolean error = DarkTextBorder.hasError(c);
        return this.getBorderColor(focus, error, editable, c.isEnabled());
    }

    protected Color getBorderColor(boolean focus, boolean error, boolean editable, boolean enabled) {
        if (focus) {
            return error ? this.focusErrorBorderColor : this.focusBorderColor;
        }
        if (error) {
            return this.errorBorderColor;
        }
        return enabled && editable ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarkTextBorder.isCellEditor(c)) {
            return editorBorder.getBorderInsets(c);
        }
        Insets insets = new Insets(this.borderSize + this.padding.top, this.borderSize + this.padding.left, this.borderSize + this.padding.bottom, this.borderSize + this.padding.right);
        if (DarkTextFieldUI.isSearchField(c)) {
            int searchWidth = DarkTextFieldUI.getSearchIcon(c).getIconWidth();
            int clearWidth = DarkTextFieldUI.getClearIcon(false).getIconWidth();
            insets.left += this.padding.left + searchWidth;
            insets.right += this.padding.right + clearWidth;
        } else if (DarkPasswordFieldUI.hasShowIcon(c)) {
            int eyeWidth = this.showIcon.getIconWidth();
            if (c.getComponentOrientation().isLeftToRight()) {
                insets.right += this.padding.right + eyeWidth;
            } else {
                insets.left += this.padding.left + eyeWidth;
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

