/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.ui.text.DarkPasswordFieldUIBridge;
import com.github.weisj.darklaf.ui.text.DarkTextBorder;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class DarkPasswordFieldUI
extends DarkPasswordFieldUIBridge {
    protected static final String KEY_PREFIX = "JPasswordField.";
    public static final String KEY_SHOW_VIEW_BUTTON = "JPasswordField.showViewIcon";
    protected Icon show;
    protected Icon showPressed;
    private final FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarkPasswordFieldUI.this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarkPasswordFieldUI.this.getComponent().repaint();
        }
    };
    private final MouseMotionListener mouseMotionListener = e -> this.updateCursor(e.getPoint());
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            SwingUtilities.invokeLater(() -> {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, DarkPasswordFieldUI.this.getComponent());
                DarkPasswordFieldUI.this.updateCursor(p);
            });
        }
    };
    protected int borderSize;
    protected int arc;
    private char echo_dot = (char)42;
    private boolean showTriggered = false;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (DarkPasswordFieldUI.hasShowIcon(DarkPasswordFieldUI.this.editor) && DarkPasswordFieldUI.this.isOverEye(e.getPoint())) {
                ((JPasswordField)DarkPasswordFieldUI.this.getComponent()).setEchoChar('\u0000');
                DarkPasswordFieldUI.this.showTriggered = true;
                DarkPasswordFieldUI.this.getComponent().repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (DarkPasswordFieldUI.this.showTriggered) {
                ((JPasswordField)DarkPasswordFieldUI.this.getComponent()).setEchoChar(DarkPasswordFieldUI.this.echo_dot);
                DarkPasswordFieldUI.this.showTriggered = false;
                DarkPasswordFieldUI.this.getComponent().repaint();
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkPasswordFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.borderSize = UIManager.getInt("PasswordField.borderThickness");
        this.arc = UIManager.getInt("PasswordField.arc");
        this.show = UIManager.getIcon("PasswordField.show.icon");
        this.showPressed = UIManager.getIcon("PasswordField.showPressed.icon");
    }

    @Override
    protected void updateCursor(Point p) {
        boolean insideTextArea;
        boolean useShow = DarkPasswordFieldUI.hasShowIcon(this.editor);
        Rectangle textRect = DarkTextFieldUI.getTextRect(this.getComponent());
        int rightMargin = useShow ? this.getShowIconCoord().x : textRect.x + textRect.width + 1;
        boolean bl = insideTextArea = this.getDrawingRect(this.getComponent()).contains(p) && p.x >= textRect.x && p.x < rightMargin;
        if (insideTextArea) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(2));
        } else if (useShow && this.isOverEye(p)) {
            this.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent c = this.getComponent();
        c.addFocusListener(this.focusListener);
        c.addMouseListener(this.mouseListener);
        c.addMouseMotionListener(this.mouseMotionListener);
        c.addKeyListener(this.keyListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        JTextComponent c = this.getComponent();
        c.removeFocusListener(this.focusListener);
        c.removeMouseListener(this.mouseListener);
        c.removeMouseMotionListener(this.mouseMotionListener);
        c.removeKeyListener(this.keyListener);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Border border = c.getBorder();
        GraphicsContext config = new GraphicsContext(g);
        if (border instanceof DarkTextBorder) {
            if (c.isEnabled() && c.isEditable()) {
                g.setColor(c.getBackground());
            }
            int width = c.getWidth();
            int height = c.getHeight();
            int w = this.borderSize;
            DarkUIUtil.fillRoundRect(g, w, w, width - 2 * w, height - 2 * w, this.arc);
            if (DarkPasswordFieldUI.hasShowIcon(c) && this.showShowIcon()) {
                this.paintShowIcon(g);
            }
        } else {
            super.paintBackground(g);
        }
        config.restore();
    }

    private void paintShowIcon(Graphics2D g) {
        Point p = this.getShowIconCoord();
        if (this.showTriggered) {
            this.getShowTriggeredIcon().paintIcon(this.getComponent(), g, p.x, p.y);
        } else {
            this.getShowIcon().paintIcon(this.getComponent(), g, p.x, p.y);
        }
    }

    protected Icon getShowTriggeredIcon() {
        return this.showPressed;
    }

    public static boolean hasShowIcon(Component c) {
        return c instanceof JPasswordField && Boolean.TRUE.equals(((JComponent)c).getClientProperty(KEY_SHOW_VIEW_BUTTON));
    }

    private Point getShowIconCoord() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int w = this.getShowIcon().getIconWidth();
        return DarkUIUtil.adjustForOrientation(new Point(r.x + r.width - w - this.borderSize, r.y + (r.height - w) / 2), w, this.editor);
    }

    private boolean isOverEye(Point p) {
        return this.showShowIcon() && DarkTextFieldUI.isOver(this.getShowIconCoord(), this.getShowIcon(), p);
    }

    protected Icon getShowIcon() {
        return this.show;
    }

    private boolean showShowIcon() {
        JPasswordField c = (JPasswordField)this.getComponent();
        char[] pw = c.getPassword();
        boolean show = pw.length > 0;
        Arrays.fill(pw, '\u0000');
        return show;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JPasswordField) {
            this.echo_dot = ((JPasswordField)c).getEchoChar();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String key = evt.getPropertyName();
        if (KEY_SHOW_VIEW_BUTTON.equals(key)) {
            this.editor.doLayout();
            Container parent = this.editor.getParent();
            if (parent instanceof JComponent) {
                ((Component)parent).doLayout();
            }
            this.editor.repaint();
        }
    }
}

