/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class DarkTableHeaderUIBridge
extends BasicTableHeaderUI {
    protected static final Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    protected static final FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintHeader(e.getSource());
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintHeader(e.getSource());
        }

        protected void repaintHeader(Object source) {
            if (source instanceof JTableHeader) {
                JTableHeader th = (JTableHeader)source;
                DarkTableHeaderUIBridge ui = (DarkTableHeaderUIBridge)DarkUIUtil.getUIOfType(th.getUI(), DarkTableHeaderUIBridge.class);
                if (ui == null) {
                    return;
                }
                th.repaint(th.getHeaderRect(ui.getSelectedColumnIndex()));
            }
        }
    };
    protected int rolloverColumn = -1;
    protected int selectedColumnIndex = 0;

    public static ComponentUI createUI(JComponent h) {
        return new DarkTableHeaderUIBridge();
    }

    protected static boolean canResize(TableColumn column, JTableHeader header) {
        return column != null && header.getResizingAllowed() && column.getResizable();
    }

    protected void updateRolloverColumn(MouseEvent e) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(e.getPoint()) && (col = this.header.columnAtPoint(e.getPoint())) != this.rolloverColumn) {
            int oldRolloverColumn = this.rolloverColumn;
            this.rolloverColumn = col;
            this.rolloverColumnUpdated(oldRolloverColumn, this.rolloverColumn);
        }
    }

    protected int selectNextColumn(boolean doIt) {
        int newIndex = this.getSelectedColumnIndex();
        if (newIndex < this.header.getColumnModel().getColumnCount() - 1) {
            ++newIndex;
            if (doIt) {
                this.selectColumn(newIndex);
            }
        }
        return newIndex;
    }

    protected int getSelectedColumnIndex() {
        int numCols = this.header.getColumnModel().getColumnCount();
        if (this.selectedColumnIndex >= numCols && numCols > 0) {
            this.selectedColumnIndex = numCols - 1;
        }
        return this.selectedColumnIndex;
    }

    void selectColumn(int newColIndex) {
        this.selectColumn(newColIndex, true);
    }

    void selectColumn(int newColIndex, boolean doScroll) {
        Rectangle repaintRect = this.header.getHeaderRect(this.selectedColumnIndex);
        this.header.repaint(repaintRect);
        this.selectedColumnIndex = newColIndex;
        repaintRect = this.header.getHeaderRect(newColIndex);
        this.header.repaint(repaintRect);
        if (doScroll) {
            this.scrollToColumn(newColIndex);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected void scrollToColumn(int col) {
        JTable table;
        Container container;
        if (this.header.getParent() == null || (container = this.header.getParent().getParent()) == null || !(container instanceof JScrollPane) || (table = this.header.getTable()) == null) {
            return;
        }
        Rectangle vis = table.getVisibleRect();
        Rectangle cellBounds = table.getCellRect(0, col, true);
        vis.x = cellBounds.x;
        vis.width = cellBounds.width;
        table.scrollRectToVisible(vis);
    }

    protected int selectPreviousColumn(boolean doIt) {
        int newIndex = this.getSelectedColumnIndex();
        if (newIndex > 0) {
            --newIndex;
            if (doIt) {
                this.selectColumn(newIndex);
            }
        }
        return newIndex;
    }

    protected int changeColumnWidth(TableColumn resizingColumn, JTableHeader th, int oldWidth, int newWidth) {
        JTable table;
        Container container;
        resizingColumn.setWidth(newWidth);
        if (th.getParent() == null || (container = th.getParent().getParent()) == null || !(container instanceof JScrollPane) || (table = th.getTable()) == null) {
            return 0;
        }
        if (!container.getComponentOrientation().isLeftToRight() && !th.getComponentOrientation().isLeftToRight()) {
            JViewport viewport = ((JScrollPane)container).getViewport();
            int viewportWidth = viewport.getWidth();
            int diff = newWidth - oldWidth;
            int newHeaderWidth = table.getWidth() + diff;
            Dimension tableSize = table.getSize();
            tableSize.width += diff;
            table.setSize(tableSize);
            if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                Point p = viewport.getViewPosition();
                p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                viewport.setViewPosition(p);
                return diff;
            }
        }
        return 0;
    }

    protected void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        Component component = this.getHeaderRenderer(columnIndex);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    protected Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        boolean hasFocus = !this.header.isPaintingForPrint() && columnIndex == this.getSelectedColumnIndex() && this.header.hasFocus();
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, hasFocus, -1, columnIndex);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installProperty(this.header, "opaque", Boolean.TRUE);
    }

    @Override
    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
        this.header.addFocusListener(focusListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    @Override
    protected void uninstallDefaults() {
    }

    @Override
    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.header.removeFocusListener(focusListener);
        this.mouseInputListener = null;
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.header, 0, null);
        SwingUtilities.replaceUIActionMap(this.header, null);
    }

    @Override
    protected int getRolloverColumn() {
        return this.rolloverColumn;
    }

    @Override
    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        int baseline = -1;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            TableColumn aColumn = columnModel.getColumn(column);
            Component comp = this.getHeaderRenderer(column);
            Dimension pref = comp.getPreferredSize();
            int columnBaseline = comp.getBaseline(pref.width, height);
            if (columnBaseline < 0) continue;
            if (baseline == -1) {
                baseline = columnBaseline;
                continue;
            }
            if (baseline == columnBaseline) continue;
            baseline = -1;
            break;
        }
        return baseline;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        Rectangle cellRect = this.header.getHeaderRect(ltr ? cMin : cMax);
        if (ltr) {
            for (column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (column = cMax; column >= cMin; --column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
    }

    protected int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    protected Dimension createHeaderSize(long width) {
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    protected int getHeaderHeight() {
        int height = 0;
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            Object headerValue;
            boolean isDefault;
            TableColumn aColumn = columnModel.getColumn(column);
            boolean bl = isDefault = aColumn.getHeaderRenderer() == null;
            if (isDefault && accomodatedDefault) continue;
            Component comp = this.getHeaderRenderer(column);
            int rendererHeight = comp.getPreferredSize().height;
            height = Math.max(height, rendererHeight);
            if (!isDefault || rendererHeight <= 0 || (headerValue = aColumn.getHeaderValue()) == null || (headerValue = headerValue.toString()) == null || headerValue.equals("")) continue;
            accomodatedDefault = true;
        }
        return height;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createHeaderSize(width);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createHeaderSize(width);
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected int mouseXOffset;
        protected Cursor otherCursor = resizeCursor;

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnIndex;
            RowSorter<? extends TableModel> sorter;
            JTable table;
            if (!DarkTableHeaderUIBridge.this.header.isEnabled()) {
                return;
            }
            if (e.getClickCount() % 2 == 1 && SwingUtilities.isLeftMouseButton(e) && (table = DarkTableHeaderUIBridge.this.header.getTable()) != null && (sorter = table.getRowSorter()) != null && (columnIndex = DarkTableHeaderUIBridge.this.header.columnAtPoint(e.getPoint())) != -1) {
                columnIndex = table.convertColumnIndexToModel(columnIndex);
                sorter.toggleSortOrder(columnIndex);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!DarkTableHeaderUIBridge.this.header.isEnabled()) {
                return;
            }
            DarkTableHeaderUIBridge.this.header.setDraggedColumn(null);
            DarkTableHeaderUIBridge.this.header.setResizingColumn(null);
            DarkTableHeaderUIBridge.this.header.setDraggedDistance(0);
            Point p = e.getPoint();
            TableColumnModel columnModel = DarkTableHeaderUIBridge.this.header.getColumnModel();
            int index = DarkTableHeaderUIBridge.this.header.columnAtPoint(p);
            if (index != -1) {
                TableColumn resizingColumn = this.getResizingColumn(p, index);
                if (DarkTableHeaderUIBridge.canResize(resizingColumn, DarkTableHeaderUIBridge.this.header)) {
                    DarkTableHeaderUIBridge.this.header.setResizingColumn(resizingColumn);
                    this.mouseXOffset = DarkTableHeaderUIBridge.this.header.getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
                } else if (DarkTableHeaderUIBridge.this.header.getReorderingAllowed()) {
                    TableColumn hitColumn = columnModel.getColumn(index);
                    DarkTableHeaderUIBridge.this.header.setDraggedColumn(hitColumn);
                    this.mouseXOffset = p.x;
                }
            }
            if (DarkTableHeaderUIBridge.this.header.getReorderingAllowed()) {
                int oldRolloverColumn = DarkTableHeaderUIBridge.this.rolloverColumn;
                DarkTableHeaderUIBridge.this.rolloverColumn = -1;
                DarkTableHeaderUIBridge.this.rolloverColumnUpdated(oldRolloverColumn, DarkTableHeaderUIBridge.this.rolloverColumn);
            }
        }

        protected void setDraggedDistance(int draggedDistance, int column) {
            DarkTableHeaderUIBridge.this.header.setDraggedDistance(draggedDistance);
            if (column != -1) {
                DarkTableHeaderUIBridge.this.header.getColumnModel().moveColumn(column, column);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!DarkTableHeaderUIBridge.this.header.isEnabled()) {
                return;
            }
            this.setDraggedDistance(0, DarkTableHeaderUIBridge.this.viewIndexForColumn(DarkTableHeaderUIBridge.this.header.getDraggedColumn()));
            DarkTableHeaderUIBridge.this.header.setResizingColumn(null);
            DarkTableHeaderUIBridge.this.header.setDraggedColumn(null);
            DarkTableHeaderUIBridge.this.updateRolloverColumn(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!DarkTableHeaderUIBridge.this.header.isEnabled()) {
                return;
            }
            DarkTableHeaderUIBridge.this.updateRolloverColumn(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!DarkTableHeaderUIBridge.this.header.isEnabled()) {
                return;
            }
            int oldRolloverColumn = DarkTableHeaderUIBridge.this.rolloverColumn;
            DarkTableHeaderUIBridge.this.rolloverColumn = -1;
            DarkTableHeaderUIBridge.this.rolloverColumnUpdated(oldRolloverColumn, DarkTableHeaderUIBridge.this.rolloverColumn);
        }

        protected TableColumn getResizingColumn(Point p) {
            return this.getResizingColumn(p, DarkTableHeaderUIBridge.this.header.columnAtPoint(p));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!DarkTableHeaderUIBridge.this.header.isEnabled()) {
                return;
            }
            int mouseX = e.getX();
            TableColumn resizingColumn = DarkTableHeaderUIBridge.this.header.getResizingColumn();
            TableColumn draggedColumn = DarkTableHeaderUIBridge.this.header.getDraggedColumn();
            boolean headerLeftToRight = DarkTableHeaderUIBridge.this.header.getComponentOrientation().isLeftToRight();
            if (resizingColumn != null) {
                int oldWidth = resizingColumn.getWidth();
                int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
                this.mouseXOffset += DarkTableHeaderUIBridge.this.changeColumnWidth(resizingColumn, DarkTableHeaderUIBridge.this.header, oldWidth, newWidth);
            } else if (draggedColumn != null) {
                TableColumnModel cm = DarkTableHeaderUIBridge.this.header.getColumnModel();
                int draggedDistance = mouseX - this.mouseXOffset;
                int direction = draggedDistance < 0 ? -1 : 1;
                int columnIndex = DarkTableHeaderUIBridge.this.viewIndexForColumn(draggedColumn);
                int newColumnIndex = columnIndex + (headerLeftToRight ? direction : -direction);
                if (0 <= newColumnIndex && newColumnIndex < cm.getColumnCount()) {
                    int width = cm.getColumn(newColumnIndex).getWidth();
                    if (Math.abs(draggedDistance) > width / 2) {
                        this.mouseXOffset += direction * width;
                        DarkTableHeaderUIBridge.this.header.setDraggedDistance(draggedDistance - direction * width);
                        int selectedIndex = SwingUtilities2.convertColumnIndexToModel(DarkTableHeaderUIBridge.this.header.getColumnModel(), DarkTableHeaderUIBridge.this.getSelectedColumnIndex());
                        cm.moveColumn(columnIndex, newColumnIndex);
                        DarkTableHeaderUIBridge.this.selectColumn(SwingUtilities2.convertColumnIndexToView(DarkTableHeaderUIBridge.this.header.getColumnModel(), selectedIndex), false);
                        return;
                    }
                }
                this.setDraggedDistance(draggedDistance, columnIndex);
            }
            DarkTableHeaderUIBridge.this.updateRolloverColumn(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!DarkTableHeaderUIBridge.this.header.isEnabled()) {
                return;
            }
            if (DarkTableHeaderUIBridge.canResize(this.getResizingColumn(e.getPoint()), DarkTableHeaderUIBridge.this.header) != (DarkTableHeaderUIBridge.this.header.getCursor() == resizeCursor)) {
                this.swapCursor();
            }
            DarkTableHeaderUIBridge.this.updateRolloverColumn(e);
        }

        protected TableColumn getResizingColumn(Point p, int column) {
            int columnIndex;
            if (column == -1) {
                return null;
            }
            Rectangle r = DarkTableHeaderUIBridge.this.header.getHeaderRect(column);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            if (DarkTableHeaderUIBridge.this.header.getComponentOrientation().isLeftToRight()) {
                columnIndex = p.x < midPoint ? column - 1 : column;
            } else {
                int n = columnIndex = p.x < midPoint ? column : column - 1;
            }
            if (columnIndex == -1) {
                return null;
            }
            return DarkTableHeaderUIBridge.this.header.getColumnModel().getColumn(columnIndex);
        }

        protected void swapCursor() {
            Cursor tmp = DarkTableHeaderUIBridge.this.header.getCursor();
            DarkTableHeaderUIBridge.this.header.setCursor(this.otherCursor);
            this.otherCursor = tmp;
        }
    }

    protected static class Actions
    extends UIAction {
        public static final String TOGGLE_SORT_ORDER = "toggleSortOrder";
        public static final String SELECT_COLUMN_TO_LEFT = "selectColumnToLeft";
        public static final String SELECT_COLUMN_TO_RIGHT = "selectColumnToRight";
        public static final String MOVE_COLUMN_LEFT = "moveColumnLeft";
        public static final String MOVE_COLUMN_RIGHT = "moveColumnRight";
        public static final String RESIZE_LEFT = "resizeLeft";
        public static final String RESIZE_RIGHT = "resizeRight";
        public static final String FOCUS_TABLE = "focusTable";

        public Actions(String name) {
            super(name);
        }

        @Override
        public boolean accept(Object sender) {
            if (sender instanceof JTableHeader) {
                JTableHeader th = (JTableHeader)sender;
                TableColumnModel cm = th.getColumnModel();
                if (cm.getColumnCount() <= 0) {
                    return false;
                }
                String key = this.getName();
                DarkTableHeaderUIBridge ui = (DarkTableHeaderUIBridge)DarkUIUtil.getUIOfType(th.getUI(), DarkTableHeaderUIBridge.class);
                if (ui != null) {
                    if (Objects.equals(key, MOVE_COLUMN_LEFT)) {
                        return th.getReorderingAllowed() && this.maybeMoveColumn(true, th, ui, false);
                    }
                    if (Objects.equals(key, MOVE_COLUMN_RIGHT)) {
                        return th.getReorderingAllowed() && this.maybeMoveColumn(false, th, ui, false);
                    }
                    if (Objects.equals(key, RESIZE_LEFT) || Objects.equals(key, RESIZE_RIGHT)) {
                        return DarkTableHeaderUIBridge.canResize(cm.getColumn(ui.getSelectedColumnIndex()), th);
                    }
                    if (Objects.equals(key, FOCUS_TABLE)) {
                        return th.getTable() != null;
                    }
                }
            }
            return true;
        }

        protected boolean maybeMoveColumn(boolean leftArrow, JTableHeader th, DarkTableHeaderUIBridge ui, boolean doIt) {
            int newIndex;
            int oldIndex = ui.getSelectedColumnIndex();
            if (th.getComponentOrientation().isLeftToRight()) {
                newIndex = leftArrow ? ui.selectPreviousColumn(doIt) : ui.selectNextColumn(doIt);
            } else {
                int n = newIndex = leftArrow ? ui.selectNextColumn(doIt) : ui.selectPreviousColumn(doIt);
            }
            if (newIndex != oldIndex) {
                if (doIt) {
                    th.getColumnModel().moveColumn(oldIndex, newIndex);
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table;
            JTableHeader th = (JTableHeader)e.getSource();
            DarkTableHeaderUIBridge ui = (DarkTableHeaderUIBridge)DarkUIUtil.getUIOfType(th.getUI(), DarkTableHeaderUIBridge.class);
            if (ui == null) {
                return;
            }
            String name = this.getName();
            if (Objects.equals(TOGGLE_SORT_ORDER, name)) {
                RowSorter<? extends TableModel> sorter;
                JTable table2 = th.getTable();
                RowSorter<? extends TableModel> rowSorter = sorter = table2 == null ? null : table2.getRowSorter();
                if (sorter != null) {
                    int columnIndex = ui.getSelectedColumnIndex();
                    columnIndex = table2.convertColumnIndexToModel(columnIndex);
                    sorter.toggleSortOrder(columnIndex);
                }
            } else if (Objects.equals(SELECT_COLUMN_TO_LEFT, name)) {
                if (th.getComponentOrientation().isLeftToRight()) {
                    ui.selectPreviousColumn(true);
                } else {
                    ui.selectNextColumn(true);
                }
            } else if (Objects.equals(SELECT_COLUMN_TO_RIGHT, name)) {
                if (th.getComponentOrientation().isLeftToRight()) {
                    ui.selectNextColumn(true);
                } else {
                    ui.selectPreviousColumn(true);
                }
            } else if (Objects.equals(MOVE_COLUMN_LEFT, name)) {
                this.moveColumn(true, th, ui);
            } else if (Objects.equals(MOVE_COLUMN_RIGHT, name)) {
                this.moveColumn(false, th, ui);
            } else if (Objects.equals(RESIZE_LEFT, name)) {
                this.resize(true, th, ui);
            } else if (Objects.equals(RESIZE_RIGHT, name)) {
                this.resize(false, th, ui);
            } else if (Objects.equals(FOCUS_TABLE, name) && (table = th.getTable()) != null) {
                table.requestFocusInWindow();
            }
        }

        protected void moveColumn(boolean leftArrow, JTableHeader th, DarkTableHeaderUIBridge ui) {
            this.maybeMoveColumn(leftArrow, th, ui, true);
        }

        protected void resize(boolean leftArrow, JTableHeader th, DarkTableHeaderUIBridge ui) {
            int oldWidth;
            int columnIndex = ui.getSelectedColumnIndex();
            TableColumn resizingColumn = th.getColumnModel().getColumn(columnIndex);
            th.setResizingColumn(resizingColumn);
            int newWidth = oldWidth = resizingColumn.getWidth();
            newWidth = th.getComponentOrientation().isLeftToRight() ? (newWidth += leftArrow ? -1 : 1) : (newWidth += leftArrow ? 1 : -1);
            ui.changeColumnWidth(resizingColumn, th, oldWidth, newWidth);
        }
    }
}

