/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.components.border.MutableLineBorder;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

public class DarkTableHeaderBorder
extends MutableLineBorder
implements UIResource {
    public DarkTableHeaderBorder() {
        super(0, 0, 1, 0, null);
        this.setColor(UIManager.getColor("TableHeader.borderColor"));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.adjustTop(c);
        super.paintBorder(c, g, x, y, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        this.adjustTop(c);
        return super.getBorderInsets(c, insets);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        this.adjustTop(c);
        return super.getBorderInsets(c);
    }

    protected void adjustTop(Component c) {
        Container parent = DarkUIUtil.getUnwrappedParent(c.getParent());
        this.top = 0;
        if (parent instanceof JComponent) {
            if (this.hasBorderAbove((JComponent)parent, c)) {
                return;
            }
            Border border = ((JComponent)parent).getBorder();
            if (border instanceof EmptyBorder || border == null) {
                this.top = 1;
            }
        }
    }

    protected boolean hasBorderAbove(JComponent c, Component child) {
        JComponent comp;
        Component prev = child;
        for (comp = c; comp instanceof JScrollPane || comp != null && comp.getLayout() instanceof BorderLayout && ((BorderLayout)comp.getLayout()).getConstraints(prev) == "Center" && ((BorderLayout)comp.getLayout()).getLayoutComponent("North") == null; comp = (JComponent)comp.getParent()) {
            if (comp instanceof JTabbedPane) {
                return true;
            }
            prev = comp;
        }
        return comp instanceof JTabbedPane;
    }
}

