/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.ui.table.DarkTableCellFocusBorder;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DarkTableCellRenderer
extends DefaultTableCellRenderer {
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox> checkBoxRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorCheckBox>(new DarkCellRendererToggleButton.CellEditorCheckBox(true));
    private final DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton> radioRenderer = new DarkCellRendererToggleButton<DarkCellRendererToggleButton.CellEditorRadioButton>(new DarkCellRendererToggleButton.CellEditorRadioButton(true));

    protected static boolean isBooleanRenderingEnabled(JTable table) {
        return Boolean.TRUE.equals(table.getClientProperty("JTable.renderBooleanAsCheckBox"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background;
        boolean isLeadSelectionCell;
        if (value instanceof Boolean && DarkTableCellRenderer.isBooleanRenderingEnabled(table)) {
            return this.getBooleanRenderer(table).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(table.getComponentOrientation().isLeftToRight() ? 2 : 4);
        boolean bl = isLeadSelectionCell = DarkUIUtil.hasFocus(table) && hasFocus && !DarkTableCellFocusBorder.isRowFocusBorder(table);
        if (DarkTableCellFocusBorder.isRowFocusBorder(table) && table.getSelectionModel().getLeadSelectionIndex() == row && !table.isEditing() && DarkUIUtil.hasFocus(table)) {
            component.setBorder(UIManager.getBorder("Table.focusSelectedCellHighlightBorder"));
            component.putClientProperty("JTable.rowFocusBorder", true);
            JTableHeader header = table.getTableHeader();
            TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
            boolean forceLeft = false;
            boolean forceRight = false;
            if (draggedColumn != null) {
                int index = DarkTableUI.viewIndexForColumn(draggedColumn, table);
                forceLeft = column == index + 1 || column == index;
                forceRight = column == index - 1 || column == index;
            }
            component.putClientProperty("JTable.forcePaintRight", forceRight);
            component.putClientProperty("JTable.forcePaintLeft", forceLeft);
        } else {
            component.putClientProperty("JTable.rowFocusBorder", false);
        }
        boolean alternativeRow = Boolean.TRUE.equals(table.getClientProperty("JTable.alternateRowColor"));
        Color alternativeRowColor = UIManager.getColor("Table.alternateRowBackground");
        Color normalColor = table.getBackground();
        Color color = background = alternativeRow && row % 2 == 1 ? alternativeRowColor : normalColor;
        if (!isSelected || isLeadSelectionCell || table.isEditing()) {
            component.setBackground(background);
            component.setForeground(table.getForeground());
        } else {
            if (DarkUIUtil.hasFocus(table)) {
                component.setForeground(table.getSelectionForeground());
            } else {
                component.setForeground(UIManager.getColor("Table.selectionForegroundInactive"));
            }
            component.setBackground(table.getSelectionBackground());
        }
        return component;
    }

    protected TableCellRenderer getBooleanRenderer(JTable table) {
        if ("radioButton".equals(table.getClientProperty("JTable.booleanRenderType"))) {
            return this.radioRenderer;
        }
        return this.checkBoxRenderer;
    }
}

