/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.decorators.CellRenderer;
import com.github.weisj.darklaf.ui.table.DarkTableCellEditor;
import com.github.weisj.darklaf.ui.table.DarkTableCellFocusBorder;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class DarkTableCellEditorToggleButton
extends AbstractCellEditor
implements TableCellEditor,
SwingConstants {
    private final JToggleButton toggleButton;

    public DarkTableCellEditorToggleButton(DarkTableCellEditor delegate, JToggleButton toggleButton) {
        this.toggleButton = toggleButton;
        toggleButton.setOpaque(true);
        toggleButton.addChangeListener(e -> delegate.setValue(toggleButton.isSelected()));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Color background;
        if (value instanceof Boolean) {
            this.toggleButton.setSelected((Boolean)value);
        }
        this.toggleButton.setHorizontalAlignment(table.getComponentOrientation().isLeftToRight() ? 2 : 4);
        boolean isLeadSelectionCell = DarkUIUtil.hasFocus(table) && table.getSelectionModel().getLeadSelectionIndex() == row && table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == column && !DarkTableCellFocusBorder.isRowFocusBorder(table);
        boolean alternativeRow = Boolean.TRUE.equals(table.getClientProperty("JTable.alternateRowColor"));
        Color alternativeRowColor = UIManager.getColor("Table.alternateRowBackground");
        Color normalColor = table.getBackground();
        Color color = background = alternativeRow && row % 2 == 1 ? alternativeRowColor : normalColor;
        if (!isSelected || isLeadSelectionCell || table.isEditing()) {
            this.toggleButton.setBackground(background);
            this.toggleButton.setForeground(table.getForeground());
        } else {
            if (DarkUIUtil.hasFocus(table)) {
                this.toggleButton.setForeground(table.getSelectionForeground());
            } else {
                this.toggleButton.setForeground(UIManager.getColor("Table.selectionForegroundInactive"));
            }
            this.toggleButton.setBackground(table.getSelectionBackground());
        }
        return this.toggleButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.toggleButton.isSelected();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    public static class CellRadioButton
    extends JRadioButton
    implements CellRenderer {
        @Override
        public boolean hasFocus() {
            return true;
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }

    public static class CellCheckBox
    extends JCheckBox
    implements CellRenderer {
        @Override
        public boolean hasFocus() {
            return true;
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }
}

