/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.ui.tabframe.DarkTabFrameUI;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.JComponent;

public class TabFrameLayout
implements LayoutManager {
    private final JTabFrame tabFrame;
    private DarkTabFrameUI ui;
    private int[] shift;
    private boolean[] draggedOver;
    private int topHeight;
    private int leftHeight;
    private int rightHeight;
    private int bottomHeight;

    public TabFrameLayout(JTabFrame tabFrame, DarkTabFrameUI ui) {
        this.tabFrame = tabFrame;
        this.ui = ui;
        this.shift = new int[4];
        this.draggedOver = new boolean[4];
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension b = this.tabFrame.getContentPane().getComponent().getPreferredSize();
        return new Dimension(this.tabFrame.getLeftTabContainer().getWidth() + this.tabFrame.getRightTabContainer().getWidth() + b.width, this.tabFrame.getTopTabContainer().getHeight() + this.tabFrame.getBottomTabContainer().getHeight() + b.height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension b = this.tabFrame.getContentPane().getComponent().getMinimumSize();
        return new Dimension(this.tabFrame.getLeftTabContainer().getWidth() + this.tabFrame.getRightTabContainer().getWidth() + b.width, this.tabFrame.getTopTabContainer().getHeight() + this.tabFrame.getBottomTabContainer().getHeight() + b.height);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension dim = parent.getSize();
        int topSize = this.tabFrame.getTopTabCount();
        int bottomSize = this.tabFrame.getBottomTabCount();
        int leftSize = this.tabFrame.getLeftTabCount();
        int rightSize = this.tabFrame.getRightTabCount();
        if (this.isDraggedOver(Alignment.NORTH)) {
            ++topSize;
        }
        if (this.isDraggedOver(Alignment.SOUTH)) {
            ++bottomSize;
        }
        if (this.isDraggedOver(Alignment.EAST)) {
            ++rightSize;
        }
        if (this.isDraggedOver(Alignment.WEST)) {
            ++leftSize;
        }
        this.ui.getDropComponentBottom().setSize(0, 0);
        this.ui.getDropComponentLeft().setSize(0, 0);
        this.ui.getDropComponentRight().setSize(0, 0);
        this.ui.getDropComponentTop().setSize(0, 0);
        this.topHeight = this.calculateMaxTabSize(Alignment.NORTH);
        this.bottomHeight = this.calculateMaxTabSize(Alignment.SOUTH);
        this.leftHeight = this.calculateMaxTabSize(Alignment.WEST);
        this.rightHeight = this.calculateMaxTabSize(Alignment.EAST);
        this.layoutTopTab(dim, topSize, leftSize, rightSize);
        this.layoutBottomTab(dim, bottomSize, leftSize, rightSize);
        this.layoutLeftTab(dim, leftSize);
        this.layoutRightTab(dim, rightSize);
        JComponent leftPane = this.ui.getLeftContainer();
        JComponent rightPane = this.ui.getRightContainer();
        JComponent topPane = this.ui.getTopContainer();
        JComponent bottomPane = this.ui.getBottomContainer();
        this.tabFrame.getContentPane().getComponent().setBounds(((Component)leftPane).getWidth(), ((Component)topPane).getHeight(), dim.width - ((Component)leftPane).getWidth() - ((Component)rightPane).getWidth(), dim.height - ((Component)topPane).getHeight() - ((Component)bottomPane).getHeight());
    }

    protected void layoutTopTab(Dimension dim, int topSize, int leftSize, int rightSize) {
        JComponent topComp = this.tabFrame.getTopTabContainer();
        if (topSize > 0) {
            topComp.setBounds(0, 0, dim.width, this.tabFrame.getTabSize());
            this.layoutHorizontal(dim, Alignment.NORTH, Alignment.NORTH_EAST, 0, leftSize, rightSize, this.topHeight);
        } else if (this.draggedOver[this.getIndex(Alignment.NORTH)]) {
            int size = this.tabFrame.getTabSize();
            topComp.setBounds(0, 0, dim.width, size);
            if (this.ui.getDestIndex() >= -1) {
                this.layoutHorizontalDrop(Alignment.NORTH, leftSize, rightSize, size, 0);
            }
        } else {
            topComp.setBounds(0, 0, 0, 0);
        }
    }

    protected void layoutBottomTab(Dimension dim, int bottomSize, int leftSize, int rightSize) {
        JComponent bottomComp = this.tabFrame.getBottomTabContainer();
        if (bottomSize > 0) {
            bottomComp.setBounds(0, dim.height - this.bottomHeight, dim.width, this.bottomHeight);
            this.layoutHorizontal(dim, Alignment.SOUTH_WEST, Alignment.SOUTH, 1, leftSize, rightSize, this.bottomHeight);
        } else if (this.draggedOver[this.getIndex(Alignment.SOUTH)]) {
            int size = this.tabFrame.getTabSize();
            bottomComp.setBounds(0, dim.height - size, dim.width, size);
            if (this.ui.getDestIndex() >= -1) {
                this.layoutHorizontalDrop(Alignment.SOUTH_WEST, leftSize, rightSize, size, 1);
            }
        } else {
            bottomComp.setBounds(0, 0, 0, 0);
        }
    }

    protected void layoutHorizontalDrop(Alignment left, int leftSize, int rightSize, int size, int yOff) {
        Alignment a = this.ui.getDestAlign();
        Dimension dropSize = this.ui.getDropSize();
        JComponent dropComp = this.ui.getDropComponent(left);
        Component tabComp = this.ui.getTabContainer(left);
        if (a == left) {
            int x = leftSize > 0 ? this.leftHeight : 0;
            dropComp.setBounds(x, yOff, dropSize.width, size);
        } else {
            int x = rightSize > 0 ? tabComp.getWidth() - this.rightHeight : tabComp.getWidth();
            dropComp.setBounds(x - dropSize.width, yOff, dropSize.width, size);
        }
    }

    protected void layoutHorizontal(Dimension dim, Alignment left, Alignment right, int yOff, int leftSize, int rightSize, int tabHeight) {
        Point start = new Point(leftSize > 0 ? this.leftHeight : 0, yOff);
        int leftEnd = this.layoutTabArea(start, left, true, tabHeight - 1);
        start.x = rightSize > 0 ? dim.width - this.rightHeight : dim.width;
        int rightStart = this.layoutTabArea(start, right, false, tabHeight - 1);
        if (rightStart < leftEnd) {
            this.shift[this.getIndex((Alignment)left)] = leftEnd - rightStart;
            this.shift(leftEnd - rightStart, right);
        } else {
            this.shift[this.getIndex((Alignment)left)] = 0;
        }
    }

    protected void layoutLeftTab(Dimension dim, int leftSize) {
        JComponent leftPane = this.ui.getLeftContainer();
        JComponent topPane = this.tabFrame.getTopTabContainer();
        JComponent bottomPane = this.tabFrame.getBottomTabContainer();
        if (leftSize > 0 || this.draggedOver[this.getIndex(Alignment.WEST)]) {
            int size = leftSize > 0 ? this.leftHeight : this.tabFrame.getTabSize();
            int height = dim.height - ((Component)topPane).getHeight() - ((Component)bottomPane).getHeight();
            leftPane.setBounds(0, ((Component)topPane).getHeight(), size, height + height % 2);
            this.tabFrame.getLeftTabContainer().setPreferredSize(new Dimension(((Component)leftPane).getHeight(), ((Component)leftPane).getWidth()));
            this.tabFrame.getLeftTabContainer().setSize(this.tabFrame.getLeftTabContainer().getPreferredSize());
            if (leftSize > 0) {
                Point start = new Point(((Component)leftPane).getHeight(), 0);
                int topStart = this.layoutTabArea(start, Alignment.NORTH_WEST, false, size - 1);
                start.x = 0;
                int bottomEnd = this.layoutTabArea(start, Alignment.WEST, true, size - 1);
                if (bottomEnd > topStart) {
                    this.shift[this.getIndex((Alignment)Alignment.WEST)] = topStart - bottomEnd;
                    this.shift(topStart - bottomEnd, Alignment.WEST);
                } else {
                    this.shift[this.getIndex((Alignment)Alignment.WEST)] = 0;
                }
            } else if (this.ui.getDestIndex() >= -1) {
                this.layoutVerticalDrop(Alignment.WEST, size);
            }
        } else {
            this.tabFrame.getLeftTabContainer().setBounds(0, 0, 0, 0);
            leftPane.setBounds(0, 0, 0, 0);
        }
    }

    protected void layoutVerticalDrop(Alignment left, int size) {
        JComponent comp = this.ui.getDropComponent(left);
        Alignment a = this.ui.getDestAlign();
        Dimension dropSize = this.ui.getDropSize();
        JComponent tabComp = this.tabFrame.getTabContainer(left);
        if (a == left) {
            comp.setBounds(0, 0, dropSize.width, size);
        } else {
            comp.setBounds(((Component)tabComp).getWidth() - dropSize.width, 0, dropSize.width, size);
        }
    }

    protected void layoutRightTab(Dimension dim, int rightSize) {
        JComponent rightPane = this.ui.getRightContainer();
        JComponent topPane = this.tabFrame.getTopTabContainer();
        JComponent bottomPane = this.tabFrame.getBottomTabContainer();
        if (rightSize > 0 || this.draggedOver[this.getIndex(Alignment.EAST)]) {
            int size = rightSize > 0 ? this.rightHeight : this.tabFrame.getTabSize();
            int height = dim.height - ((Component)topPane).getHeight() - ((Component)bottomPane).getHeight();
            rightPane.setBounds(dim.width - this.rightHeight, ((Component)topPane).getHeight(), size, height + height % 2);
            this.tabFrame.getRightTabContainer().setPreferredSize(new Dimension(((Component)rightPane).getHeight(), ((Component)rightPane).getWidth()));
            this.tabFrame.getRightTabContainer().setSize(this.tabFrame.getRightTabContainer().getPreferredSize());
            if (rightSize > 0) {
                Point start = new Point(0, 0);
                int topEnd = this.layoutTabArea(start, Alignment.EAST, true, size - 1);
                start.x = this.tabFrame.getRightTabContainer().getWidth();
                int bottomStart = this.layoutTabArea(start, Alignment.SOUTH_EAST, false, size - 1);
                if (bottomStart < topEnd) {
                    this.shift[this.getIndex((Alignment)Alignment.EAST)] = topEnd - bottomStart;
                    this.shift(topEnd - bottomStart, Alignment.SOUTH_EAST);
                } else {
                    this.shift[this.getIndex((Alignment)Alignment.EAST)] = 0;
                }
            } else if (this.ui.getDestIndex() >= -1) {
                this.layoutVerticalDrop(Alignment.EAST, size);
            }
        } else {
            this.tabFrame.getRightTabContainer().setBounds(0, 0, 0, 0);
            rightPane.setBounds(0, 0, 0, 0);
        }
    }

    protected void shift(int shift, Alignment a) {
        for (TabFrameTab c : this.tabFrame.tabsForAlignment(a)) {
            Point pos = c.getComponent().getLocation();
            pos.x += shift;
            c.getComponent().setLocation(pos);
        }
        if (a == this.ui.getDestAlign()) {
            JComponent dropComp = this.ui.getDropComponent(a);
            Point pos = dropComp.getLocation();
            pos.x += shift;
            dropComp.setLocation(pos);
        }
    }

    public int getShift(Alignment a) {
        switch (a) {
            case NORTH: 
            case EAST: 
            case SOUTH_WEST: 
            case NORTH_WEST: {
                return 0;
            }
        }
        return this.shift[this.getIndex(a)];
    }

    protected int getIndex(Alignment a) {
        switch (a) {
            case NORTH: 
            case NORTH_EAST: {
                return 0;
            }
            case EAST: 
            case SOUTH_EAST: {
                return 1;
            }
            case SOUTH_WEST: 
            case SOUTH: {
                return 2;
            }
            case NORTH_WEST: 
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public void setDraggedOver(Alignment a, boolean b) {
        this.draggedOver[this.getIndex((Alignment)a)] = b;
    }

    protected int layoutTabArea(Point start, Alignment a, boolean forward, int size) {
        int x = start.x;
        int y = start.y;
        int sourceIndex = a == this.ui.getSourceAlign() ? this.ui.getSourceIndex() : -10;
        int destIndex = a == this.ui.getDestAlign() ? this.ui.getDestIndex() : -10;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        int index = 0;
        JComponent dropComp = this.ui.getDropComponent(a);
        if (destIndex == -1) {
            if (forward) {
                dropComp.setBounds(x, y, this.ui.getDropSize().width, size);
                x += this.ui.getDropSize().width;
            } else {
                dropComp.setBounds(x -= this.ui.getDropSize().width, y, this.ui.getDropSize().width, size);
            }
        }
        for (TabFrameTab c : this.tabFrame.tabsForAlignment(a)) {
            index = c.getIndex();
            bounds.width = index == sourceIndex ? 0 : this.getTabWidth(c.getComponent());
            bounds.height = size;
            if (forward) {
                bounds.x = x;
                bounds.y = y;
                x += bounds.width;
                if (index == destIndex) {
                    dropComp.setBounds(x, y, this.ui.getDropSize().width, size);
                    x += this.ui.getDropSize().width;
                }
            } else {
                bounds.x = x -= bounds.width;
                bounds.y = y;
                if (index == destIndex) {
                    dropComp.setBounds(x -= this.ui.getDropSize().width, y, this.ui.getDropSize().width, size);
                }
            }
            c.getComponent().setBounds(bounds);
        }
        if (destIndex == index + 1) {
            if (forward) {
                dropComp.setBounds(x, y, this.ui.getDropSize().width, size);
                x += this.ui.getDropSize().width;
            } else {
                dropComp.setBounds(x -= this.ui.getDropSize().width, y, this.ui.getDropSize().width, size);
            }
        }
        return x;
    }

    public int getTabWidth(Component c) {
        int maxWidth = this.tabFrame.getMaxTabWidth();
        int width = c.getPreferredSize().width;
        if (maxWidth < 0) {
            return width;
        }
        return Math.min(maxWidth, width);
    }

    protected int calculateMaxTabSize(Alignment a) {
        int max = this.tabFrame.getTabSize();
        for (TabFrameTab c : this.tabFrame.tabsForAlignment(a)) {
            max = Math.max(max, c.getComponent().getMaximumSize().height + 1);
        }
        for (TabFrameTab c : this.tabFrame.tabsForAlignment(this.tabFrame.getPeer(a))) {
            max = Math.max(max, c.getComponent().getMaximumSize().height + 1);
        }
        return max;
    }

    public void setDraggedOver(boolean b) {
        Arrays.fill(this.draggedOver, b);
    }

    public boolean isDraggedOver(Alignment a) {
        return this.draggedOver[this.getIndex(a)];
    }
}

