/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFrameTabContainer;
import com.github.weisj.darklaf.decorators.HoverListener;
import com.github.weisj.darklaf.ui.panel.DarkPanelUI;
import com.github.weisj.darklaf.ui.tabframe.TabDragListener;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class DarkTabFrameTabContainerUI
extends DarkPanelUI
implements PropertyChangeListener {
    private static final String ACCELERATOR_PREFIX = "accelerator_";
    protected TabFrameTabContainer tabContainer;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                DarkTabFrameTabContainerUI.this.tabContainer.getTabFrame().toggleTab(DarkTabFrameTabContainerUI.this.tabContainer.getOrientation(), DarkTabFrameTabContainerUI.this.tabContainer.getIndex(), !DarkTabFrameTabContainerUI.this.tabContainer.isSelected());
            }
        }
    };
    private TabDragListener dragListener;
    private HoverListener hoverListener;
    private Color selectedColor;
    private Color hoverColor;
    private boolean printing;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTabFrameTabContainerUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.tabContainer = (TabFrameTabContainer)c;
        super.installUI(c);
        this.installDefaults(this.tabContainer);
        this.installListeners();
        this.installAccelerator(this.tabContainer.getTabFrame());
    }

    protected void installListeners() {
        this.dragListener = new TabDragListener(this.tabContainer);
        this.hoverListener = new HoverListener(this.tabContainer);
        this.tabContainer.addMouseListener(this.hoverListener);
        this.tabContainer.addPropertyChangeListener(this);
        this.tabContainer.addMouseListener(this.mouseListener);
        this.tabContainer.addMouseListener(this.dragListener);
        this.tabContainer.addMouseMotionListener(this.dragListener);
        Component cont = this.tabContainer.getContent();
        if (cont != null) {
            cont.addMouseListener(this.hoverListener);
            cont.addMouseListener(this.mouseListener);
            cont.addMouseListener(this.dragListener);
            cont.addMouseMotionListener(this.dragListener);
        }
    }

    protected void installAccelerator(JTabFrame tabFrame) {
        if (tabFrame == null) {
            return;
        }
        int acc = this.tabContainer.getAccelerator();
        if (acc < 0) {
            return;
        }
        tabFrame.getInputMap(1).put(KeyStroke.getKeyStroke(UIManager.getString("TabFrame.acceleratorKeyCode") + " " + acc), ACCELERATOR_PREFIX + acc);
        tabFrame.getActionMap().put(ACCELERATOR_PREFIX + acc, this.createAcceleratorAction(tabFrame));
    }

    protected Action createAcceleratorAction(final JTabFrame tabFrame) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Alignment a = DarkTabFrameTabContainerUI.this.tabContainer.getOrientation();
                int index = DarkTabFrameTabContainerUI.this.tabContainer.getIndex();
                if (!DarkTabFrameTabContainerUI.this.tabContainer.isSelected()) {
                    tabFrame.toggleTab(a, index, true);
                } else {
                    Component popup = tabFrame.getPopupComponentAt(a, index);
                    if (!DarkUIUtil.hasFocus(popup)) {
                        popup.requestFocus();
                    } else {
                        tabFrame.toggleTab(a, index, false);
                    }
                }
            }
        };
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
        this.uninstallAccelerator(this.tabContainer.getTabFrame());
        this.tabContainer = null;
    }

    protected void uninstallListeners() {
        this.tabContainer.removeMouseListener(this.hoverListener);
        this.tabContainer.removeMouseListener(this.mouseListener);
        this.tabContainer.removeMouseListener(this.dragListener);
        this.tabContainer.removePropertyChangeListener(this);
        this.tabContainer.removeMouseMotionListener(this.dragListener);
        Component cont = this.tabContainer.getContent();
        if (cont != null) {
            cont.removeMouseListener(this.hoverListener);
            cont.removeMouseListener(this.mouseListener);
            cont.removeMouseListener(this.dragListener);
            cont.removeMouseMotionListener(this.dragListener);
        }
        this.dragListener = null;
        this.hoverListener = null;
    }

    protected void uninstallAccelerator(JTabFrame tabFrame) {
        if (tabFrame == null) {
            return;
        }
        int acc = this.tabContainer.getAccelerator();
        String accAction = ACCELERATOR_PREFIX + acc;
        tabFrame.getActionMap().remove(accAction);
    }

    @Override
    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        this.tabContainer.setOpaque(true);
        this.selectedColor = UIManager.getColor("TabFrameTab.selectedBackground");
        this.hoverColor = UIManager.getColor("TabFrameTab.hoverBackground");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("content".equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal instanceof Component) {
                ((Component)oldVal).removeMouseListener(this.mouseListener);
                ((Component)oldVal).removeMouseListener(this.hoverListener);
                ((Component)oldVal).removeMouseListener(this.dragListener);
                ((Component)oldVal).removeMouseMotionListener(this.dragListener);
            }
            if (newVal instanceof Component) {
                ((Component)newVal).addMouseListener(this.mouseListener);
                ((Component)newVal).addMouseListener(this.hoverListener);
                ((Component)newVal).addMouseListener(this.dragListener);
                ((Component)newVal).addMouseMotionListener(this.dragListener);
            }
        } else if ("selected".equals(key)) {
            if (this.tabContainer == null) {
                return;
            }
            this.tabContainer.repaint();
        } else if ("accelerator".equals(key)) {
            if (this.tabContainer == null) {
                return;
            }
            this.uninstallAccelerator(this.tabContainer.getTabFrame());
            this.installAccelerator(this.tabContainer.getTabFrame());
        } else if ("tabFrame".equals(key)) {
            if (evt.getOldValue() instanceof JTabFrame) {
                this.uninstallAccelerator((JTabFrame)evt.getOldValue());
            }
            if (evt.getNewValue() instanceof JTabFrame) {
                this.installAccelerator((JTabFrame)evt.getNewValue());
            }
        } else if ("paintingForPrint".equals(key)) {
            this.printing = Boolean.TRUE.equals(evt.getNewValue());
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        g.setColor(this.getBackground(this.tabContainer));
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        super.paint(g, c);
    }

    public Color getBackground(TabFrameTabContainer tab) {
        if (this.printing) {
            return tab.getBackground();
        }
        return tab.isSelected() ? this.selectedColor : (this.hoverListener.isHover() && !tab.getTabFrame().isInTransfer() ? this.hoverColor : tab.getBackground());
    }
}

