/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.components.uiresource.JButtonUIResource;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class NewTabButton
extends JPanel
implements UIResource {
    protected final JButton button;
    protected DarkTabbedPaneUI ui;

    protected NewTabButton(DarkTabbedPaneUI ui) {
        this.ui = ui;
        this.button = this.createButton();
        this.button.addActionListener(e -> {
            Action action = ui.getNewTabAction();
            if (action != null) {
                action.actionPerformed(e);
            }
        });
        this.add(this.button);
        this.setOpaque(false);
        this.setLayout(null);
    }

    protected JButton createButton() {
        JButtonUIResource button = new JButtonUIResource();
        button.setIcon(this.ui.getNewTabIcon());
        button.setFocusable(false);
        button.putClientProperty("JButton.variant", "shadow");
        button.putClientProperty("JButton.square", Boolean.TRUE);
        button.putClientProperty("JButton.alternativeArc", Boolean.TRUE);
        button.putClientProperty("JButton.thin", Boolean.TRUE);
        button.setRolloverEnabled(true);
        button.setOpaque(false);
        Insets margin = UIManager.getInsets("TabbedPane.newTabButton.insets");
        button.setMargin(new Insets(margin.top, margin.left, margin.bottom, margin.right));
        return button;
    }

    @Override
    public void doLayout() {
        Dimension b = this.button.getPreferredSize();
        int x = (this.getWidth() - b.width) / 2;
        int y = (this.getHeight() - b.height) / 2;
        this.button.setBounds(x, y, b.width, b.height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.ui.paintTabAreaBorder(g, this.ui.tabPane.getTabPlacement(), 0, 0, this.getWidth() + 1, this.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.button.getPreferredSize();
    }
}

