/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.components.uiresource.UIResourceWrapper;
import com.github.weisj.darklaf.ui.tabbedpane.DarkHandler;
import com.github.weisj.darklaf.ui.tabbedpane.DarkScrollHandler;
import com.github.weisj.darklaf.ui.tabbedpane.DarkScrollableTabSupport;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneLayout;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneScrollLayout;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUIBridge;
import com.github.weisj.darklaf.ui.tabbedpane.MoreTabsButton;
import com.github.weisj.darklaf.ui.tabbedpane.NewTabButton;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneHandler;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneTransferHandler;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.TooManyListenersException;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class DarkTabbedPaneUI
extends DarkTabbedPaneUIBridge {
    protected static final String KEY_PREFIX = "JTabbedPane.";
    public static final String KEY_DND = "JTabbedPane.dndEnabled";
    public static final String KEY_NORTH_COMP = "JTabbedPane.northComponent";
    public static final String KEY_WEST_COMP = "JTabbedPane.westComponent";
    public static final String KEY_EAST_COMP = "JTabbedPane.eastComponent";
    public static final String KEY_SOUTH_COMP = "JTabbedPane.southComponent";
    public static final String KEY_LEADING_COMP = "JTabbedPane.leadingComponent";
    public static final String KEY_TRAILING_COMP = "JTabbedPane.trailingComponent";
    public static final String KEY_SHOW_NEW_TAB_BUTTON = "JTabbedPane.showNewTabButton";
    public static final String KEY_DRAW_FOCUS_BAR = "JTabbedPane.drawFocusBar";
    public static final String KEY_TAB_PLACEMENT = "tabPlacement";
    public static final String KEY_CONTENT_BORDER_INSETS = "JTabbedPane.contentBorderInsets";
    public static final String KEY_TAB_AREA_INSETS = "JTabbedPane.tabAreaInsets";
    public static final String KEY_MAX_POPUP_HEIGHT = "JTabbedPane.maxPopupHeight";
    public static final String KEY_NEW_TAB_ACTION = "JTabbedPane.newTabAction";
    public static final String KEY_ROTATE_TAB_RUNS = "JTabbedPane.rotateTabRuns";
    protected static final TabbedPaneTransferHandler TRANSFER_HANDLER = new TabbedPaneTransferHandler.UIResource();
    protected final FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            DarkTabbedPaneUI.this.repaintTab(DarkTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarkTabbedPaneUI.this.repaintTab(DarkTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    };
    protected final AWTEventListener awtEventListener = e -> {
        if (e.getID() == 1004) {
            this.tabPane.repaint();
        }
    };
    protected final Rectangle tabAreaBounds = new Rectangle(0, 0, 0, 0);
    protected final Rectangle dropRect = new Rectangle(0, 0, 0, 0);
    protected DarkScrollableTabSupport scrollableTabSupport;
    protected DarkTabbedPaneScrollLayout scrollLayout;
    protected int currentShiftX = 0;
    protected int currentShiftXTmp = 0;
    protected int scrollShiftX = 0;
    protected int currentShiftY = 0;
    protected int currentShiftYTmp = 0;
    protected int scrollShiftY = 0;
    protected int minVisibleOld = -2;
    protected int maxVisibleOld = -2;
    protected int minVisible = -1;
    protected int maxVisible = -1;
    protected boolean dndEnabled;
    protected int dropTargetIndex = -1;
    protected int dropSourceIndex = -1;
    protected boolean sourceEqualsTarget;
    protected boolean drawDropRect;
    protected int focusSize;
    protected boolean dragging;
    protected Rectangle dragRect = new Rectangle();
    protected Color dragBorderColor;
    protected Color dropBackground;
    protected Color tabBorderColor;
    protected Color accent;
    protected Color focusAccent;
    protected Color selectedHoverBackground;
    protected Color selectedBackground;
    protected Color hoverBackground;
    protected Color tabAreaBackground;
    protected Icon moreTabsIcon;
    protected Icon newTabIcon;
    protected DarkScrollHandler scrollHandler;
    protected Component leadingComp;
    protected Component trailingComp;
    protected Component northComp;
    protected Component eastComp;
    protected Component southComp;
    protected Component westComp;

    public static ComponentUI createUI(JComponent c) {
        return new DarkTabbedPaneUI();
    }

    protected Color getDragBorderColor() {
        return this.dragBorderColor;
    }

    protected Action getNewTabAction() {
        Object action = this.tabPane.getClientProperty(KEY_NEW_TAB_ACTION);
        return action instanceof Action ? (Action)action : null;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDragSupport();
    }

    protected void installDragSupport() {
        this.tabPane.setTransferHandler(TRANSFER_HANDLER);
        try {
            this.tabPane.getDropTarget().addDropTargetListener(TRANSFER_HANDLER);
            this.tabPane.getDropTarget().setActive(this.dndEnabled);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.scrollableTabSupport != null) {
            this.tabPane.remove(this.scrollableTabSupport.moreTabsButton);
            this.tabPane.remove(this.scrollableTabSupport.newTabButton);
        }
        this.scrollableTabSupport = null;
        if (this.tabPane.getTransferHandler() instanceof TabbedPaneTransferHandler.UIResource) {
            this.tabPane.setTransferHandler(null);
            if (this.tabPane.getDropTarget() != null) {
                this.tabPane.getDropTarget().removeDropTargetListener(TRANSFER_HANDLER);
                this.tabPane.getDropTarget().setActive(false);
            }
        }
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        } else {
            this.paintTabAreaBorder(g, tabPlacement);
        }
        if (!this.tabsOverlapBorder) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
        if (!this.scrollableTabLayoutEnabled() && this.drawDropRect) {
            this.paintDrop(g);
        }
        if (this.tabPane.getTabCount() == 0) {
            this.paintTabAreaBorder(g, tabPlacement);
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        this.paintTabAreaBackground(g, tabPlacement);
        this.paintTabAreaBorder(g, tabPlacement);
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.getTabBackgroundColor(tabIndex, isSelected, this.getRolloverTab() == tabIndex));
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.getTabBorderColor());
        switch (tabPlacement) {
            case 1: {
                g.fillRect(x, y + h - 1, w, 1);
                break;
            }
            case 3: {
                g.fillRect(x, y, w, 1);
                break;
            }
            case 2: {
                g.fillRect(x + w - 1, y, 1, h);
                break;
            }
            case 4: {
                g.fillRect(x, y, 1, h);
            }
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle r, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (isSelected) {
            if (!this.drawFocusBar()) {
                return;
            }
            g.setColor(this.getAccentColor());
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(r.x + r.width - this.focusSize, r.y, this.focusSize, r.height);
                    break;
                }
                case 4: {
                    g.fillRect(r.x, r.y, this.focusSize, r.height);
                    break;
                }
                case 3: {
                    g.fillRect(r.x, r.y + 1, r.width, this.focusSize);
                    break;
                }
                default: {
                    g.fillRect(r.x, r.y + r.height - this.focusSize, r.width, this.focusSize);
                }
            }
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollLayout = new DarkTabbedPaneScrollLayout(this);
            return this.scrollLayout;
        }
        return new DarkTabbedPaneLayout(this);
    }

    @Override
    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new DarkScrollableTabSupport(this, this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.scrollableTabSupport = (DarkScrollableTabSupport)this.tabScroller;
        }
        this.installTabContainer();
    }

    protected void paintTabAreaBackground(Graphics g, int tabPlacement) {
        g.setColor(this.getTabAreaBackground());
        Rectangle b = this.getTabAreaBounds();
        if (this.scrollableTabLayoutEnabled()) {
            b.setLocation(0, 0);
        }
        switch (tabPlacement) {
            case 3: {
                ++b.y;
            }
            case 1: {
                --b.height;
                break;
            }
            case 4: {
                ++b.x;
            }
            case 2: {
                --b.width;
            }
        }
        g.fillRect(b.x, b.y, b.width, b.height);
    }

    protected Component wrapClientComponent(Component component) {
        if (component instanceof UIResource) {
            return component;
        }
        return new UIResourceWrapper(component);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.removeMouseListener(this.getHandler());
            this.tabPane.removeMouseMotionListener(this.getHandler());
            this.tabScroller.viewport.addMouseMotionListener(this.getScrollHandler());
            this.tabScroller.viewport.addMouseListener(this.getScrollHandler());
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 4L);
    }

    @Override
    protected TabbedPaneHandler getHandler() {
        if (this.handler == null) {
            this.handler = new DarkHandler(this);
        }
        return this.handler;
    }

    @Override
    protected int tabForCoordinate(JTabbedPane pane, int x, int y, boolean validateIfNecessary) {
        int tab = super.tabForCoordinate(pane, x, y, validateIfNecessary);
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
            if (tab == -1 && this.dropTargetIndex >= 0 && this.dropRect.contains(p)) {
                return this.dropTargetIndex;
            }
        }
        return tab;
    }

    @Override
    public void setRolloverTab(int index) {
        if (this.dragging) {
            return;
        }
        int oldRollover = this.rolloverTabIndex;
        super.setRolloverTab(index);
        if (oldRollover != this.getRolloverTab()) {
            this.repaintTab(oldRollover);
            this.repaintTab(this.getRolloverTab());
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    private void paintTabAreaBorder(Graphics g, int tabPlacement) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        int y = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        int x = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
        switch (tabPlacement) {
            case 1: {
                this.paintTabAreaBorder(g, tabPlacement, 0, 0, width, y);
                break;
            }
            case 3: {
                this.paintTabAreaBorder(g, tabPlacement, 0, height - y, width, y + 1);
                break;
            }
            case 2: {
                this.paintTabAreaBorder(g, tabPlacement, 0, 0, x, height);
                break;
            }
            case 4: {
                this.paintTabAreaBorder(g, tabPlacement, width - x, 0, x, height);
            }
        }
    }

    @Override
    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return Boolean.TRUE.equals(this.tabPane.getClientProperty(KEY_ROTATE_TAB_RUNS));
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) - 1;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        return Math.max(super.calculateMaxTabHeight(tabPlacement), this.getFallBackSize());
    }

    @Override
    protected int calculateMaxTabWidth(int tabPlacement) {
        return Math.max(super.calculateMaxTabWidth(tabPlacement), this.getFallBackSize());
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        return Math.max(super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight), this.getFallBackSize());
    }

    @Override
    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        return Math.max(super.calculateTabAreaWidth(tabPlacement, vertRunCount, maxTabWidth), this.getFallBackSize());
    }

    public void setDnDIndicatorRect(int x, int y, int width, int height, int targetIndex, boolean sourceEqualsTarget) {
        this.dropRect.setBounds(x, y, width, height);
        if (this.scrollableTabLayoutEnabled()) {
            Point p = this.scrollableTabSupport.viewport.getLocation();
            this.dropRect.x -= p.x;
            this.dropRect.y -= p.y;
        }
        this.drawDropRect = true;
        this.sourceEqualsTarget = sourceEqualsTarget;
        this.dropTargetIndex = targetIndex;
        this.tabPane.doLayout();
        this.tabPane.repaint();
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = (Insets)super.getContentBorderInsets(tabPlacement).clone();
        if (this.northComp != null) {
            insets.top += this.northComp.getPreferredSize().height;
        }
        if (this.southComp != null) {
            insets.bottom += this.southComp.getPreferredSize().height;
        }
        if (this.eastComp != null) {
            insets.right += this.eastComp.getPreferredSize().width;
        }
        if (this.westComp != null) {
            insets.left += this.westComp.getPreferredSize().width;
        }
        return insets;
    }

    protected int getFallBackSize() {
        int max = 0;
        if (this.scrollableTabLayoutEnabled() && this.scrollableTabSupport.newTabButton.isVisible()) {
            max = Math.max(this.scrollableTabSupport.newTabButton.getPreferredSize().height, 27);
        }
        return max;
    }

    protected DarkScrollHandler getScrollHandler() {
        if (this.scrollHandler == null) {
            this.scrollHandler = new DarkScrollHandler(this);
        }
        return this.scrollHandler;
    }

    protected boolean drawFocusBar() {
        return !Boolean.FALSE.equals(this.tabPane.getClientProperty(KEY_DRAW_FOCUS_BAR));
    }

    protected Color getAccentColor() {
        boolean focus = DarkUIUtil.hasFocus(this.tabPane);
        return this.getAccentColor(focus);
    }

    protected Color getAccentColor(boolean focus) {
        return focus ? this.focusAccent : this.accent;
    }

    protected Color getTabBorderColor() {
        return this.tabBorderColor;
    }

    public Color getTabBackgroundColor(int tabIndex, boolean isSelected, boolean hover) {
        if (isSelected) {
            return hover ? this.selectedHoverBackground : this.selectedBackground;
        }
        return hover ? this.hoverBackground : this.tabPane.getBackgroundAt(tabIndex);
    }

    protected void paintTabAreaBorder(Graphics g, int tabPlacement, int x, int y, int w, int h) {
        g.setColor(this.getTabBorderColor());
        switch (tabPlacement) {
            case 1: {
                g.fillRect(x, y + h - 1, w, 1);
                break;
            }
            case 3: {
                g.fillRect(x, y, w, 1);
                break;
            }
            case 2: {
                g.fillRect(w - 1, y, 1, h);
                break;
            }
            case 4: {
                g.fillRect(x, y, 1, h);
            }
        }
    }

    protected Color getTabAreaBackground() {
        return this.tabAreaBackground;
    }

    protected void paintDrop(Graphics g) {
        g.setColor(this.getDropColor());
        GraphicsContext context = new GraphicsContext(g);
        if (!this.scrollableTabLayoutEnabled()) {
            ((Graphics2D)g).setComposite(DarkUIUtil.DROP_ALPHA);
        }
        switch (this.tabPane.getTabPlacement()) {
            case 1: {
                g.fillRect(this.dropRect.x, this.dropRect.y, this.dropRect.width, this.dropRect.height - 1);
                break;
            }
            case 3: {
                g.fillRect(this.dropRect.x, this.dropRect.y + 1, this.dropRect.width, this.dropRect.height - 1);
                break;
            }
            case 2: {
                g.fillRect(this.dropRect.x, this.dropRect.y, this.dropRect.width - 1, this.dropRect.height);
                break;
            }
            case 4: {
                g.fillRect(this.dropRect.x + 1, this.dropRect.y, this.dropRect.width - 1, this.dropRect.height);
            }
        }
        context.restore();
    }

    protected void layoutLeadingComponent(Component comp, int tabWidth, int tabHeight, Insets insets, int tx, int ty, int tabPlacement) {
        Dimension b = this.leadingComp.getPreferredSize();
        int h = Math.min(tabHeight, b.height);
        int w = Math.min(tabWidth, b.width);
        int centerY = (tabHeight - h) / 2;
        int centerX = (tabWidth - w) / 2;
        switch (tabPlacement) {
            case 2: {
                comp.setBounds(insets.left + centerX, insets.top, w, b.height);
                break;
            }
            case 4: {
                comp.setBounds(tx - this.tabAreaInsets.left + centerX, insets.top, w, b.height);
                break;
            }
            case 1: {
                comp.setBounds(insets.left, insets.top + centerY, b.width, h);
                break;
            }
            case 3: {
                comp.setBounds(insets.left, ty - this.tabAreaInsets.bottom + centerY, b.width, h);
            }
        }
    }

    protected void layoutTrailingComponent(Component comp, int tabWidth, int tabHeight, Insets insets, int tx, int ty, int tw, int th, int tabPlacement) {
        Dimension b = this.trailingComp.getPreferredSize();
        int h = Math.min(tabHeight, b.height);
        int w = Math.min(tabWidth, b.width);
        Dimension size = this.tabPane.getSize();
        int centerY = (tabHeight - h) / 2;
        int centerX = (tabWidth - w) / 2;
        switch (tabPlacement) {
            case 2: {
                comp.setBounds(insets.left + centerX, size.height - b.height - insets.bottom, w, b.height);
                break;
            }
            case 4: {
                comp.setBounds(tx - this.tabAreaInsets.left + centerX, size.height - b.height - insets.bottom, w, b.height);
                break;
            }
            case 1: {
                comp.setBounds(size.width - b.width - insets.right, insets.top + centerY, b.width, h);
                break;
            }
            case 3: {
                comp.setBounds(size.width - b.width - insets.right, ty - this.tabAreaInsets.bottom + centerY, b.width, h);
            }
        }
    }

    protected Color getDropColor() {
        if (this.scrollableTabLayoutEnabled()) {
            return this.dropBackground;
        }
        return this.getTabBackgroundColor(0, false, true);
    }

    public void clearDropIndicator() {
        this.drawDropRect = false;
        this.dropTargetIndex = -1;
        this.tabPane.doLayout();
        this.tabPane.repaint();
    }

    public void clearSourceIndicator() {
        this.dropSourceIndex = -1;
        this.tabPane.doLayout();
        this.tabPane.repaint();
    }

    public void setSourceIndicator(int sourceIndex) {
        this.dropSourceIndex = sourceIndex;
        this.tabPane.doLayout();
        this.tabPane.repaint();
    }

    protected MouseEvent convertEvent(MouseEvent e) {
        Point p = e.getPoint();
        Point pos = this.scrollableTabSupport.viewport.getLocation();
        p.x += pos.x;
        p.y += pos.y;
        return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    public Rectangle getTabAreaBounds() {
        if (this.scrollableTabLayoutEnabled()) {
            return this.scrollableTabSupport.viewport.getBounds();
        }
        return new Rectangle(this.tabAreaBounds);
    }

    protected Icon getMoreTabsIcon() {
        return this.moreTabsIcon;
    }

    protected void layoutTabComponents() {
        if (this.tabContainer == null) {
            return;
        }
        Rectangle rect = new Rectangle();
        Point delta = new Point(-this.tabContainer.getX(), -this.tabContainer.getY());
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(0, 0, delta);
        }
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component c = this.tabPane.getTabComponentAt(i);
            if (c == null) continue;
            this.getTabBounds(i, rect);
            if (i == this.dropSourceIndex) {
                if (this.dragging) {
                    rect.setBounds(this.dragRect);
                    Point p = rect.getLocation();
                    Point vl = this.tabScroller.viewport.getLocation();
                    p.x += vl.x;
                    p.y += vl.y;
                    rect.setLocation(p);
                } else {
                    rect.setBounds(0, 0, 0, 0);
                }
            }
            Dimension preferredSize = c.getPreferredSize();
            Insets insets = this.getTabInsets(this.tabPane.getTabPlacement(), i);
            int outerX = rect.x + insets.left + delta.x;
            int outerY = rect.y + insets.top + delta.y;
            int outerWidth = rect.width - insets.left - insets.right;
            int outerHeight = rect.height - insets.top - insets.bottom;
            int x = outerX + (outerWidth - preferredSize.width) / 2;
            int y = outerY + (outerHeight - preferredSize.height) / 2;
            int tabPlacement = this.tabPane.getTabPlacement();
            boolean isSeleceted = i == this.tabPane.getSelectedIndex();
            c.setBounds(x + this.getTabLabelShiftX(tabPlacement, i, isSeleceted), y + this.getTabLabelShiftY(tabPlacement, i, isSeleceted), preferredSize.width, preferredSize.height);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        config.restore();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.dragBorderColor = UIManager.getColor("TabbedPane.dragBorderColor");
        this.dropBackground = UIManager.getColor("TabbedPane.dropFill");
        this.tabBorderColor = UIManager.getColor("TabbedPane.tabBorderColor");
        this.accent = UIManager.getColor("TabbedPane.accent");
        this.focusAccent = UIManager.getColor("TabbedPane.accentFocus");
        this.selectedHoverBackground = UIManager.getColor("TabbedPane.selectedHoverBackground");
        this.selectedBackground = UIManager.getColor("TabbedPane.selectedBackground");
        this.hoverBackground = UIManager.getColor("TabbedPane.hoverBackground");
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.focusSize = UIManager.getInt("TabbedPane.focusBarHeight");
        this.moreTabsIcon = UIManager.getIcon("TabbedPane.moreTabs.icon");
        this.newTabIcon = UIManager.getIcon("TabbedPane.newTab.icon");
        Object ins = this.tabPane.getClientProperty(KEY_TAB_AREA_INSETS);
        if (ins instanceof Insets) {
            this.tabAreaInsets = (Insets)ins;
        }
        if ((ins = this.tabPane.getClientProperty(KEY_CONTENT_BORDER_INSETS)) instanceof Insets) {
            this.contentBorderInsets = (Insets)ins;
        }
        this.installComponent(KEY_LEADING_COMP, c -> {
            this.leadingComp = c;
        });
        this.installComponent(KEY_TRAILING_COMP, c -> {
            this.trailingComp = c;
        });
        this.installComponent(KEY_NORTH_COMP, c -> {
            this.northComp = c;
        });
        this.installComponent(KEY_SOUTH_COMP, c -> {
            this.southComp = c;
        });
        this.installComponent(KEY_WEST_COMP, c -> {
            this.westComp = c;
        });
        this.installComponent(KEY_EAST_COMP, c -> {
            this.eastComp = c;
        });
        this.dndEnabled = Boolean.TRUE.equals(this.tabPane.getClientProperty(KEY_DND));
    }

    protected void installComponent(String key, Consumer<Component> setter) {
        Object comp = this.tabPane.getClientProperty(key);
        if (comp instanceof Component) {
            Component wrapped = this.wrapClientComponent((Component)comp);
            setter.accept(wrapped);
            this.tabPane.add(wrapped);
        }
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        Rectangle rect = super.getTabBounds(pane, i);
        if (this.scrollableTabLayoutEnabled() && rect != null && this.dropTargetIndex >= 0 && i == this.dropTargetIndex) {
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                if (pane.getComponentOrientation().isLeftToRight()) {
                    rect.x -= this.dropRect.width;
                    rect.width += this.dropRect.width;
                } else {
                    rect.width += this.dropRect.width;
                }
            } else if (tabPlacement == 2 || tabPlacement == 4) {
                rect.y -= this.dropRect.height;
                rect.height += this.dropRect.height;
            }
        }
        return rect;
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        Dimension b;
        Insets insets = super.getTabAreaInsets(tabPlacement);
        if (this.leadingComp != null) {
            b = this.leadingComp.getPreferredSize();
            if (this.isHorizontalTabPlacement()) {
                insets.left += b.width;
            } else {
                insets.top += b.height;
            }
        }
        if (this.trailingComp != null) {
            b = this.trailingComp.getPreferredSize();
            if (this.isHorizontalTabPlacement()) {
                insets.right += b.width;
            } else {
                insets.bottom += b.height;
            }
        }
        return insets;
    }

    public Icon getNewTabIcon() {
        return this.newTabIcon;
    }

    public JComponent createNewTabButton() {
        return new NewTabButton(this);
    }

    public JButton createMoreTabsButton() {
        return new MoreTabsButton(this);
    }
}

