/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.ScrollableTabPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

class DarkScrollableTabPanel
extends ScrollableTabPanel {
    protected final Rectangle iconRect = new Rectangle();
    protected final Rectangle textRect = new Rectangle();
    private DarkTabbedPaneUI ui;

    public DarkScrollableTabPanel(DarkTabbedPaneUI ui) {
        super(ui);
        this.ui = ui;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.ui.drawDropRect) {
            this.ui.paintDrop(g);
        }
    }

    @Override
    public void doLayout() {
        if (this.getComponentCount() > 0) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component child = this.getComponent(i);
                if (child == this.ui.scrollableTabSupport.newTabButton) {
                    int off;
                    boolean leftToRight = this.ui.tabPane.getComponentOrientation().isLeftToRight();
                    int tabCount = this.ui.tabPane.getTabCount();
                    Dimension b = child.getPreferredSize();
                    if (tabCount <= 0) continue;
                    if (this.ui.isHorizontalTabPlacement()) {
                        int x;
                        int n = off = this.ui.dropTargetIndex == tabCount ? this.ui.dropRect.width : 0;
                        if (leftToRight) {
                            x = this.ui.rects[tabCount - 1].x + this.ui.rects[tabCount - 1].width + off;
                            child.setBounds(x, 0, b.width, this.ui.maxTabHeight);
                            continue;
                        }
                        x = this.ui.rects[tabCount - 1].x - off;
                        child.setBounds(x - b.width, 0, b.width, this.ui.maxTabHeight);
                        continue;
                    }
                    off = this.ui.dropTargetIndex == tabCount ? this.ui.dropRect.height : 0;
                    int y = this.ui.rects[tabCount - 1].y + this.ui.rects[tabCount - 1].height + off;
                    child.setBounds(0, y, this.ui.maxTabWidth, b.height);
                    continue;
                }
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.ui.dragging && this.ui.tabPane.getTabCount() > 0) {
            this.ui.paintTab(g, this.ui.tabPane.getTabPlacement(), this.ui.dragRect, this.ui.tabPane.getSelectedIndex(), this.iconRect, this.textRect);
            Component comp = this.ui.tabPane.getTabComponentAt(this.ui.dropSourceIndex);
            if (comp != null) {
                g.translate(comp.getX(), comp.getY());
                comp.print(g);
            }
        }
    }
}

