/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.slider;

import com.github.weisj.darklaf.decorators.MouseClickListener;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class DarkSliderUI
extends BasicSliderUI
implements PropertyChangeListener {
    protected static final String KEY_PREFIX = "JSlider.";
    public static final String KEY_THUMB_ARROW_SHAPE = "JSlider.paintThumbArrowShape";
    public static final String KEY_SHOW_VOLUME_ICON = "JSlider.volume.showIcon";
    public static final String KEY_VARIANT = "JSlider.variant";
    public static final String KEY_INSTANT_SCROLL = "JSlider.instantScrollEnabled";
    public static final String KEY_SHOW_FOCUS_GLOW = "JSlider.paintFocusGlow";
    public static final String VARIANT_VOLUME = "volume";
    private static final int ICON_BAR_EXT = 5;
    private static final int ICON_PAD = 10;
    private final Rectangle iconRect = new Rectangle(0, 0, 0, 0);
    private final MouseListener mouseListener = new MouseClickListener(){
        private boolean muted = false;
        private int oldValue;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DarkSliderUI.this.slider.isEnabled() && DarkSliderUI.showVolumeIcon(DarkSliderUI.this.slider) && DarkSliderUI.this.iconRect.contains(e.getPoint())) {
                if (this.muted && DarkSliderUI.this.slider.getValue() == DarkSliderUI.this.slider.getMinimum()) {
                    DarkSliderUI.this.slider.setValue(this.oldValue);
                    this.muted = false;
                } else {
                    this.oldValue = DarkSliderUI.this.slider.getValue();
                    DarkSliderUI.this.slider.setValue(DarkSliderUI.this.slider.getMinimum());
                    this.muted = true;
                }
            }
        }
    };
    protected int plainThumbRadius;
    protected int arcSize;
    protected int trackSize;
    protected Dimension thumbSize;
    protected Color inactiveTickForeground;
    protected Color trackBackground;
    protected Color selectedTrackBackground;
    protected Color selectedTrackInactiveBackground;
    protected Color selectedVolumeTrackBackground;
    protected Color selectedVolumeTrackInactiveBackground;
    protected Color thumbBackground;
    protected Color thumbInactiveBackground;
    protected Color volumeThumbBackground;
    protected Color volumeThumbInactiveBackground;
    protected Color thumbBorderColor;
    protected Color thumbInactiveBorderColor;
    protected Icon volume0;
    protected Icon volume1;
    protected Icon volume2;
    protected Icon volume3;
    protected Icon volume4;
    protected Icon volume0Inactive;
    protected Icon volume1Inactive;
    protected Icon volume2Inactive;
    protected Icon volume3Inactive;
    protected Icon volume4Inactive;

    public DarkSliderUI(JSlider b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarkSliderUI((JSlider)c);
    }

    private static boolean showVolumeIcon(JComponent c) {
        return DarkSliderUI.isVolumeSlider(c) && Boolean.TRUE.equals(c.getClientProperty(KEY_SHOW_VOLUME_ICON));
    }

    private static boolean isVolumeSlider(JComponent c) {
        return VARIANT_VOLUME.equals(c.getClientProperty(KEY_VARIANT));
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new SnapTrackListener();
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        slider.addMouseListener(this.mouseListener);
        slider.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.mouseListener);
        slider.removePropertyChangeListener(this);
    }

    @Override
    protected void calculateGeometry() {
        super.calculateGeometry();
        if (DarkSliderUI.showVolumeIcon(this.slider)) {
            this.calculateIconRect();
        } else {
            this.iconRect.setBounds(-1, -1, 0, 0);
        }
    }

    @Override
    protected void calculateContentRect() {
        super.calculateContentRect();
        if (DarkSliderUI.showVolumeIcon(this.slider)) {
            if (this.isHorizontal()) {
                this.contentRect.width -= this.getVolumeIcon().getIconWidth() + 10;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    this.contentRect.x += this.getVolumeIcon().getIconWidth() + 10;
                }
            } else {
                this.contentRect.height -= this.getVolumeIcon().getIconHeight() + 10;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    this.contentRect.y += this.getVolumeIcon().getIconHeight() + 10;
                }
            }
        }
    }

    @Override
    protected Dimension getThumbSize() {
        if (this.isPlainThumb()) {
            return new Dimension(this.plainThumbRadius + 6, this.plainThumbRadius + 6);
        }
        return this.isHorizontal() ? new Dimension(this.thumbSize.width, this.thumbSize.height) : new Dimension(this.thumbSize.height, this.thumbSize.width);
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
        if (DarkSliderUI.showVolumeIcon(c)) {
            this.getVolumeIcon().paintIcon(c, g2, this.iconRect.x, this.iconRect.y);
        }
    }

    @Override
    public void paintFocus(Graphics g2) {
    }

    @Override
    public void paintTrack(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        Color bgColor = this.getTrackBackground();
        Color selectionColor = this.getSelectedTrackColor();
        if (this.isHorizontal()) {
            Area track = this.getHorizontalTrackShape();
            g.setColor(bgColor);
            g.fill(track);
            Area selection = this.getHorizontalSliderShape(track);
            g.setColor(selectionColor);
            g.fill(selection);
        } else {
            Area track = this.getVerticalTrackShape();
            g.setColor(bgColor);
            g.fill(track);
            Area selection = this.getVerticalSliderShape(track);
            g.setColor(selectionColor);
            g.fill(selection);
        }
        config.restore();
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.checkDisabled(g);
        super.paintMinorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.checkDisabled(g);
        super.paintMajorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.checkDisabled(g);
        super.paintMinorTickForVertSlider(g, tickBounds, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.checkDisabled(g);
        super.paintMajorTickForVertSlider(g, tickBounds, y);
    }

    @Override
    public void paintLabels(Graphics g) {
        this.checkDisabled(g);
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        super.paintLabels(g);
        config.restore();
    }

    @Override
    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        this.checkDisabled(g);
        super.paintHorizontalLabel(g, value, label);
    }

    @Override
    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        this.checkDisabled(g);
        super.paintVerticalLabel(g, value, label);
    }

    @Override
    public void paintThumb(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext context = GraphicsUtil.setupStrokePainting(g);
        g.translate(this.thumbRect.x, this.thumbRect.y);
        if (this.isPlainThumb()) {
            this.paintPlainSliderThumb(g);
        } else {
            this.paintSliderThumb(g);
        }
        g.translate(-this.thumbRect.x, -this.thumbRect.y);
        context.restore();
    }

    @Override
    protected void scrollDueToClickInTrack(int dir) {
        Area area;
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this.slider);
        Area area2 = area = this.isHorizontal() ? this.getHorizontalTrackShape() : this.getVerticalTrackShape();
        if (!area.getBounds().contains(p)) {
            return;
        }
        if (this.instantScrollEnabled(this.slider)) {
            int value = this.isHorizontal() ? this.valueForXPosition(p.x) : this.valueForYPosition(p.y);
            this.slider.setValue(value);
        } else {
            super.scrollDueToClickInTrack(dir);
        }
    }

    private void checkDisabled(Graphics g) {
        if (!this.slider.isEnabled()) {
            g.setColor(this.getDisabledTickColor());
        }
    }

    protected Color getDisabledTickColor() {
        return this.inactiveTickForeground;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.slider.putClientProperty(KEY_SHOW_FOCUS_GLOW, UIManager.getBoolean("Slider.paintFocusGlow"));
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        LookAndFeel.installProperty(slider, "opaque", false);
        this.arcSize = UIManager.getInt("Slider.arc");
        this.trackSize = UIManager.getInt("Slider.trackThickness");
        this.plainThumbRadius = UIManager.getInt("Slider.plainThumbRadius");
        this.thumbSize = UIManager.getDimension("Slider.thumbSize");
        this.inactiveTickForeground = UIManager.getColor("Slider.disabledTickColor");
        this.trackBackground = UIManager.getColor("Slider.trackBackground");
        this.selectedTrackBackground = UIManager.getColor("Slider.selectedTrackColor");
        this.selectedTrackInactiveBackground = UIManager.getColor("Slider.disabledTrackColor");
        this.selectedVolumeTrackBackground = UIManager.getColor("Slider.volume.selectedTrackColor");
        this.selectedVolumeTrackInactiveBackground = UIManager.getColor("Slider.volume.disabledTrackColor");
        this.thumbBackground = UIManager.getColor("Slider.activeThumbFill");
        this.thumbInactiveBackground = UIManager.getColor("Slider.inactiveThumbFill");
        this.volumeThumbBackground = UIManager.getColor("Slider.volume.activeThumbFill");
        this.volumeThumbInactiveBackground = UIManager.getColor("Slider.volume.inactiveThumbFill");
        this.thumbBorderColor = UIManager.getColor("Slider.thumbBorderColor");
        this.thumbInactiveBorderColor = UIManager.getColor("Slider.thumbBorderColorDisabled");
        this.volume0 = UIManager.getIcon("Slider.volume.enabled_level_0.icon");
        this.volume1 = UIManager.getIcon("Slider.volume.enabled_level_1.icon");
        this.volume2 = UIManager.getIcon("Slider.volume.enabled_level_2.icon");
        this.volume3 = UIManager.getIcon("Slider.volume.enabled_level_3.icon");
        this.volume4 = UIManager.getIcon("Slider.volume.enabled_level_4.icon");
        this.volume0Inactive = UIManager.getIcon("Slider.volume.disabled_level_0.icon");
        this.volume1Inactive = UIManager.getIcon("Slider.volume.disabled_level_1.icon");
        this.volume2Inactive = UIManager.getIcon("Slider.volume.disabled_level_2.icon");
        this.volume3Inactive = UIManager.getIcon("Slider.volume.disabled_level_3.icon");
        this.volume4Inactive = UIManager.getIcon("Slider.volume.disabled_level_4.icon");
    }

    protected void calculateIconRect() {
        this.iconRect.width = this.getVolumeIcon().getIconWidth();
        this.iconRect.height = this.getVolumeIcon().getIconHeight();
        if (this.isHorizontal()) {
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                this.iconRect.x = this.trackRect.x + this.trackRect.width + 10;
                this.iconRect.y = this.trackRect.y + (this.trackRect.height - this.iconRect.height) / 2;
            } else {
                this.iconRect.x = this.trackRect.x - this.iconRect.width - 10;
                this.iconRect.y = this.trackRect.y + (this.trackRect.height - this.iconRect.height) / 2;
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            this.iconRect.x = this.trackRect.x + (this.trackRect.width - this.iconRect.width) / 2;
            this.iconRect.y = this.trackRect.y + this.trackRect.height + 10;
        } else {
            this.iconRect.x = this.trackRect.x + (this.trackRect.width - this.iconRect.width) / 2;
            this.iconRect.y = this.trackRect.y - this.iconRect.height - 10;
        }
    }

    private Area getHorizontalSliderShape(Area track) {
        double x = (double)this.thumbRect.x + (double)this.thumbRect.width / 2.0;
        Area leftArea = new Area(new Rectangle2D.Double(0.0, 0.0, x, this.slider.getHeight()));
        Area rightArea = new Area(new Rectangle2D.Double(x, 0.0, (double)this.slider.getWidth() - x, this.slider.getHeight()));
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            if (this.slider.getInverted()) {
                track.intersect(rightArea);
            } else {
                track.intersect(leftArea);
            }
        } else if (!this.slider.getInverted()) {
            track.intersect(rightArea);
        } else {
            track.intersect(leftArea);
        }
        return track;
    }

    protected Icon getVolumeIcon() {
        int range = this.slider.getMaximum() - this.slider.getMinimum();
        int value = this.slider.getValue() - this.slider.getMinimum();
        double percentage = (double)value / (double)range;
        boolean enabled = this.slider.isEnabled();
        if (Math.abs(percentage) < 1.0E-6) {
            return enabled ? this.volume0 : this.volume0Inactive;
        }
        if (percentage < 0.25) {
            return enabled ? this.volume1 : this.volume1Inactive;
        }
        if (percentage < 0.5) {
            return enabled ? this.volume2 : this.volume2Inactive;
        }
        if (percentage < 0.75) {
            return enabled ? this.volume3 : this.volume3Inactive;
        }
        return enabled ? this.volume4 : this.volume4Inactive;
    }

    private boolean isHorizontal() {
        return this.slider.getOrientation() == 0;
    }

    private Area getHorizontalTrackShape() {
        int w;
        int arc = this.arcSize;
        int yOff = this.trackRect.height / 2 - this.trackSize / 2;
        int n = w = DarkSliderUI.showVolumeIcon(this.slider) ? this.trackRect.width + this.getIconBarExt() : this.trackRect.width;
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            return new Area(new RoundRectangle2D.Double(this.trackRect.x, this.trackRect.y + yOff, w, this.trackSize, arc, arc));
        }
        return new Area(new RoundRectangle2D.Double(this.trackRect.x - this.getIconBarExt(), this.trackRect.y + yOff, w, this.trackSize, arc, arc));
    }

    private Area getVerticalSliderShape(Area track) {
        int y = this.thumbRect.y + this.thumbRect.height / 2;
        if (this.slider.getInverted()) {
            track.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, this.slider.getWidth(), y)));
        } else {
            track.intersect(new Area(new Rectangle2D.Double(0.0, y, this.slider.getWidth(), this.slider.getHeight() - y)));
        }
        return track;
    }

    private Area getVerticalTrackShape() {
        int h;
        int arc = this.arcSize;
        int xOff = this.trackRect.width / 2 - this.trackSize / 2;
        int n = h = DarkSliderUI.showVolumeIcon(this.slider) ? this.trackRect.height + this.getIconBarExt() : this.trackRect.height;
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            return new Area(new RoundRectangle2D.Double(this.trackRect.x + xOff, this.trackRect.y, this.trackSize, h, arc, arc));
        }
        return new Area(new RoundRectangle2D.Double(this.trackRect.x + xOff, this.trackRect.y - this.getIconBarExt(), this.trackSize, h, arc, arc));
    }

    private int getIconBarExt() {
        return this.isPlainThumb() && DarkSliderUI.showVolumeIcon(this.slider) ? 5 : 0;
    }

    private void paintPlainSliderThumb(Graphics2D g) {
        int r = this.plainThumbRadius;
        int x = this.isHorizontal() ? 4 : (this.thumbRect.width - r) / 2;
        int y = this.isHorizontal() ? (this.thumbRect.height - r) / 2 : 4;
        g.translate(x, y);
        Ellipse2D.Double thumb = new Ellipse2D.Double(0.0, 0.0, r, r);
        Ellipse2D.Double innerThumb = new Ellipse2D.Double(1.0, 1.0, r - 2, r - 2);
        if (this.paintFocus()) {
            DarkUIUtil.paintFocusOval(g, 1, 1, r - 2, r - 2);
        }
        if (DarkSliderUI.isVolumeSlider(this.slider)) {
            g.setColor(this.getThumbColor());
            g.fill(thumb);
        } else {
            g.setColor(this.getThumbBorderColor());
            g.fill(thumb);
            g.setColor(this.getThumbColor());
            g.fill(innerThumb);
        }
        g.translate(-x, -y);
    }

    protected boolean isPlainThumb() {
        Boolean paintThumbArrowShape = (Boolean)this.slider.getClientProperty(KEY_THUMB_ARROW_SHAPE);
        return !this.slider.getPaintTicks() && paintThumbArrowShape == null || paintThumbArrowShape == Boolean.FALSE;
    }

    private void paintSliderThumb(Graphics2D g) {
        Path2D thumb = this.getThumbShape();
        if (this.paintFocus()) {
            GraphicsContext config = new GraphicsContext(g);
            g.setComposite(DarkUIUtil.GLOW_ALPHA);
            g.setStroke(new BasicStroke(4.0f, 1, 1, 8.0f));
            DarkUIUtil.Outline.focus.setGraphicsColor(g, true);
            g.draw(thumb);
            config.restore();
        }
        g.setColor(this.getThumbColor());
        g.fill(thumb);
        g.setColor(this.getThumbBorderColor());
        g.draw(thumb);
    }

    private boolean paintFocus() {
        return this.slider.hasFocus() && Boolean.TRUE.equals(this.slider.getClientProperty(KEY_SHOW_FOCUS_GLOW));
    }

    private Path2D getThumbShape() {
        if (this.isHorizontal()) {
            return this.getHorizontalThumbShape();
        }
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            return this.getVerticalThumbShapeLR();
        }
        return this.getVerticalThumbShapeRL();
    }

    private Path2D getHorizontalThumbShape() {
        int w = this.thumbRect.width;
        int h = this.thumbRect.height;
        int cw = w / 2;
        Path2D.Float shape = new Path2D.Float(0);
        ((Path2D)shape).moveTo(1.0, 1.0);
        ((Path2D)shape).lineTo(w - 2, 1.0);
        ((Path2D)shape).lineTo(w - 2, h - cw - 1);
        ((Path2D)shape).lineTo(cw, h - 2);
        ((Path2D)shape).lineTo(1.0, h - cw - 1);
        shape.closePath();
        return shape;
    }

    private Path2D getVerticalThumbShapeLR() {
        int w = this.thumbRect.width;
        int h = this.thumbRect.height;
        int cw = h / 2;
        Path2D.Float shape = new Path2D.Float(0);
        ((Path2D)shape).moveTo(2.0, 1.0);
        ((Path2D)shape).lineTo(w - cw - 1, 1.0);
        ((Path2D)shape).lineTo(w - 1, h - cw);
        ((Path2D)shape).lineTo(w - cw - 1, h - 2);
        ((Path2D)shape).lineTo(2.0, h - 2);
        shape.closePath();
        return shape;
    }

    private Path2D getVerticalThumbShapeRL() {
        int w = this.thumbRect.width;
        int h = this.thumbRect.height;
        int cw = h / 2;
        Path2D.Float shape = new Path2D.Float(0);
        ((Path2D)shape).moveTo(w - 2, 1.0);
        ((Path2D)shape).lineTo(cw + 1, 1.0);
        ((Path2D)shape).lineTo(1.0, h - cw);
        ((Path2D)shape).lineTo(cw + 1, h - 2);
        ((Path2D)shape).lineTo(w - 2, h - 2);
        shape.closePath();
        return shape;
    }

    protected Color getThumbColor() {
        if (DarkSliderUI.isVolumeSlider(this.slider)) {
            return this.slider.isEnabled() ? this.volumeThumbBackground : this.volumeThumbInactiveBackground;
        }
        return this.slider.isEnabled() ? this.thumbBackground : this.thumbInactiveBackground;
    }

    protected Color getThumbBorderColor() {
        return this.slider.isEnabled() ? this.thumbBorderColor : this.thumbInactiveBorderColor;
    }

    protected Color getTrackBackground() {
        return this.trackBackground;
    }

    protected Color getSelectedTrackColor() {
        if (DarkSliderUI.isVolumeSlider(this.slider)) {
            return this.slider.isEnabled() ? this.selectedVolumeTrackBackground : this.selectedVolumeTrackInactiveBackground;
        }
        return this.slider.isEnabled() ? this.selectedTrackBackground : this.selectedTrackInactiveBackground;
    }

    private boolean instantScrollEnabled(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(KEY_INSTANT_SCROLL));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (KEY_VARIANT.equals(key)) {
            this.slider.repaint();
        } else if (KEY_SHOW_VOLUME_ICON.equals(key)) {
            this.calculateGeometry();
            this.slider.repaint();
        }
    }

    public class SnapTrackListener
    extends BasicSliderUI.TrackListener {
        private int offset;

        public SnapTrackListener() {
            super(DarkSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            int pos = DarkSliderUI.this.isHorizontal() ? evt.getX() : evt.getY();
            int loc = this.getLocationForValue(this.getSnappedValue(evt));
            int n = this.offset = loc < 0 ? 0 : pos - loc;
            if (DarkSliderUI.this.iconRect.contains(evt.getPoint())) {
                return;
            }
            super.mousePressed(evt);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DarkSliderUI.this.slider.getSnapToTicks()) {
                int pos = this.getLocationForValue(this.getSnappedValue(e));
                if (DarkSliderUI.this.isHorizontal()) {
                    e.translatePoint(pos - e.getX() + this.offset, 0);
                } else {
                    e.translatePoint(0, pos - e.getY() + this.offset);
                }
            }
            super.mouseDragged(e);
            DarkSliderUI.this.slider.repaint();
        }

        private int getLocationForValue(int value) {
            return DarkSliderUI.this.isHorizontal() ? DarkSliderUI.this.xPositionForValue(value) : DarkSliderUI.this.yPositionForValue(value);
        }

        private int getSnappedValue(MouseEvent e) {
            int value;
            int snappedValue = value = DarkSliderUI.this.isHorizontal() ? DarkSliderUI.this.valueForXPosition(e.getX()) : DarkSliderUI.this.valueForYPosition(e.getY());
            int tickSpacing = 0;
            int majorTickSpacing = DarkSliderUI.this.slider.getMajorTickSpacing();
            int minorTickSpacing = DarkSliderUI.this.slider.getMinorTickSpacing();
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0 && (value - DarkSliderUI.this.slider.getMinimum()) % tickSpacing != 0) {
                float temp = (float)(value - DarkSliderUI.this.slider.getMinimum()) / (float)tickSpacing;
                snappedValue = DarkSliderUI.this.slider.getMinimum() + Math.round(temp) * tickSpacing;
            }
            return snappedValue;
        }
    }
}

