/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.rootpane;

import com.github.weisj.darklaf.decorations.CustomTitlePane;
import com.github.weisj.darklaf.platform.Decorations;
import com.github.weisj.darklaf.ui.rootpane.DarkSubstanceRootLayout;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class DarkRootPaneUI
extends BasicRootPaneUI
implements HierarchyListener {
    protected static final String KEY_PREFIX = "JRootPane.";
    public static final String KEY_IS_MEDIUM_WEIGHT_POPUP_ROOT = "mediumWeightPopupRoot";
    public static final String KEY_IS_POPUP = "JRootPane.isPopup";
    public static final String KEY_IS_TOOLTIP = "JRootPane.isToolTip";
    private Window window;
    private CustomTitlePane titlePane;
    private LayoutManager layoutManager;
    private LayoutManager oldLayout;
    private JRootPane rootPane;
    private DisposeListener disposeListener = new DisposeListener();
    private boolean decorationStyleLock = false;
    private int windowDecorationsStyle = -1;

    public static ComponentUI createUI(JComponent comp) {
        return new DarkRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.rootPane = (JRootPane)c;
        this.updateClientDecoration();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.rootPane);
        this.layoutManager = null;
        this.rootPane = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if ("windowDecorationStyle".equals(propertyName)) {
            if (!this.decorationStyleLock) {
                this.windowDecorationsStyle = this.rootPane.getWindowDecorationStyle();
                this.updateClientDecoration();
                if (this.windowDecorationsStyle == 2) {
                    this.decorationStyleLock = true;
                    this.rootPane.setWindowDecorationStyle(6);
                    this.decorationStyleLock = false;
                }
            }
        } else if ("ancestor".equals(propertyName)) {
            this.updateWindow(this.rootPane.getParent());
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        DarkRootPaneUI.uninstallBorder(root);
        root.removeHierarchyListener(this);
        if (this.titlePane != null) {
            this.titlePane.uninstall();
            this.setTitlePane(root, null);
        }
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
            this.window.removeWindowListener(this.disposeListener);
        }
        this.window = null;
    }

    private static void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.oldLayout != null) {
            root.setLayout(this.oldLayout);
            this.oldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        int style = this.windowDecorationsStyle < 0 ? root.getWindowDecorationStyle() : this.windowDecorationsStyle;
        this.updateWindow(root.getParent());
        CustomTitlePane titlePane = Decorations.createTitlePane(root, style, this.window);
        this.setWindowDecorated();
        this.installLayout(root);
        this.setTitlePane(root, titlePane);
        root.addHierarchyListener(this);
    }

    private void setWindowDecorated() {
        if (this.window instanceof Frame && !this.window.isDisplayable()) {
            ((Frame)this.window).setUndecorated(false);
        } else if (this.window instanceof Dialog && !this.window.isDisplayable()) {
            ((Dialog)this.window).setUndecorated(false);
        }
    }

    private void setTitlePane(JRootPane root, CustomTitlePane titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        CustomTitlePane oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private void updateWindow(Component parent) {
        if (this.window != null) {
            this.window.removeWindowListener(this.disposeListener);
        }
        this.window = DarkUIUtil.getWindow(parent);
        if (this.window != null) {
            this.window.addWindowListener(this.disposeListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.oldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    protected CustomTitlePane getTitlePane() {
        return this.titlePane;
    }

    protected LayoutManager createLayoutManager() {
        return new DarkSubstanceRootLayout();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (this.rootPane == null) {
            return;
        }
        Container parent = this.rootPane.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getClass().getName().startsWith("org.jdesktop.jdic.tray") || parent.getClass().getName().equals("javax.swing.Popup$HeavyWeightWindow")) {
            SwingUtilities.invokeLater(() -> {
                if (this.rootPane != null) {
                    this.rootPane.removeHierarchyListener(this);
                }
            });
        }
        if (e.getChangeFlags() == 1L && DarkUIUtil.getWindow(this.rootPane) != this.window) {
            this.updateClientDecoration();
        }
    }

    protected boolean isPopup(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty(KEY_IS_POPUP));
    }

    protected void updateClientDecoration() {
        if (!Boolean.TRUE.equals(this.rootPane.getClientProperty(KEY_IS_MEDIUM_WEIGHT_POPUP_ROOT))) {
            this.uninstallClientDecorations(this.rootPane);
            if (Decorations.isCustomDecorationSupported() && !this.isPopup(this.rootPane)) {
                this.installClientDecorations(this.rootPane);
            }
        }
    }

    protected class DisposeListener
    extends WindowAdapter {
        protected DisposeListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DarkRootPaneUI.this.uninstallClientDecorations(DarkRootPaneUI.this.rootPane);
        }
    }
}

