/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.radiobutton;

import com.github.weisj.darklaf.decorators.MouseClickListener;
import com.github.weisj.darklaf.ui.menu.DarkMenuItemUIBase;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.MenuItemLayoutHelper;

public class DarkRadioButtonMenuItemUI
extends DarkMenuItemUIBase {
    protected static final String KEY_PREFIX = "RadioButtonMenuItem";
    public static final String KEY_NO_NOT_CLOSE_ON_CLICK = "RadioButtonMenuItem.doNotCloseOnMouseClick";
    private final MouseClickListener clickListener = e -> SwingUtilities.invokeLater(() -> {
        if (this.menuItem != null) {
            this.menuItem.setArmed(true);
        }
    });
    private Icon radioIcon;
    private Icon radioDisabledIcon;
    private Icon radioFocusedIcon;
    private Icon radioSelectedIcon;
    private Icon radioSelectedDisabledIcon;
    private Icon radioSelectedFocusedIcon;

    public static ComponentUI createUI(JComponent c) {
        return new DarkRadioButtonMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.acceleratorFont = UIManager.getFont("MenuItem.font");
        this.acceleratorForeground = UIManager.getColor("MenuItem.foreground");
        this.acceleratorSelectionForeground = UIManager.getColor("MenuItem.selectionForeground");
        c.putClientProperty(KEY_NO_NOT_CLOSE_ON_CLICK, UIManager.getBoolean(KEY_NO_NOT_CLOSE_ON_CLICK));
    }

    @Override
    protected void paintCheckIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        Rectangle rect = lr.getCheckRect();
        this.getRadioIcon(lh.getMenuItem()).paintIcon(lh.getMenuItem(), g2, rect.x, rect.y);
    }

    protected Icon getRadioIcon(AbstractButton b) {
        boolean selected = b.isSelected();
        boolean enabled = b.isEnabled();
        boolean hasFocus = b.hasFocus();
        return selected ? (enabled ? (hasFocus ? this.radioSelectedFocusedIcon : this.radioSelectedIcon) : this.radioSelectedDisabledIcon) : (enabled ? (hasFocus ? this.radioFocusedIcon : this.radioIcon) : this.radioDisabledIcon);
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.radioIcon = UIManager.getIcon("RadioButton.unchecked.icon");
        this.radioDisabledIcon = UIManager.getIcon("RadioButton.uncheckedDisabled.icon");
        this.radioFocusedIcon = UIManager.getIcon("RadioButton.uncheckedFocused.icon");
        this.radioSelectedIcon = UIManager.getIcon("RadioButton.selected.icon");
        this.radioSelectedDisabledIcon = UIManager.getIcon("RadioButton.selectedDisabled.icon");
        this.radioSelectedFocusedIcon = UIManager.getIcon("RadioButton.selectedFocused.icon");
    }

    @Override
    protected String getPropertyPrefix() {
        return KEY_PREFIX;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addMouseListener(this.clickListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removeMouseListener(this.clickListener);
    }
}

