/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.popupmenu;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;

public class DarkPopupMenuUI
extends BasicPopupMenuUI {
    public static final String KEY_DO_NOT_CANCEL_POPUP = "doNotCancelPopup";
    public static final String KEY_DO_NOT_CANCEL_ON_SCROLL = "doNotCancelOnScroll";
    public static final String KEY_MAKE_VISIBLE = "PopupFactory.makeVisible";
    public static final StringBufferWrapper HIDE_POPUP_VALUE = new StringBufferWrapper(new StringBuffer("doNotCancelPopup"));
    public static final String KEY_DEFAULT_LIGHTWEIGHT_POPUPS = "PopupMenu.defaultLightWeightPopups";
    protected static MouseGrabber mouseGrabber;

    public static ComponentUI createUI(JComponent x) {
        return new DarkPopupMenuUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window != null && Boolean.TRUE.equals(this.popupMenu.getClientProperty(KEY_MAKE_VISIBLE))) {
            this.popupMenu.putClientProperty(KEY_MAKE_VISIBLE, false);
            window.setOpacity(1.0f);
        }
        super.paint(g, c);
    }

    public static List<JPopupMenu> getPopups() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        ArrayList<JPopupMenu> list = new ArrayList<JPopupMenu>(p.length);
        for (MenuElement element : p) {
            if (!(element instanceof JPopupMenu)) continue;
            list.add((JPopupMenu)element);
        }
        return list;
    }

    public static MouseGrabber getMouseGrabber() {
        return mouseGrabber;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.removeOldMouseGrabber();
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
    }

    private void removeOldMouseGrabber() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        ChangeListener mouseGrabber = null;
        for (ChangeListener listener : menuSelectionManager.getChangeListeners()) {
            if (!listener.getClass().getEnclosingClass().getName().endsWith("BasicPopupMenuUI")) continue;
            mouseGrabber = listener;
            break;
        }
        menuSelectionManager.removeChangeListener(mouseGrabber);
    }

    public static class MouseGrabber
    implements ChangeListener,
    AWTEventListener,
    ComponentListener,
    WindowListener {
        Window grabbedWindow;
        MenuElement[] lastPathSelected;

        public MouseGrabber() {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            msm.addChangeListener(this);
            this.lastPathSelected = msm.getSelectedPath();
            if (this.lastPathSelected.length != 0) {
                this.grabWindow(this.lastPathSelected);
            }
        }

        protected void grabWindow(MenuElement[] newPath) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(() -> {
                tk.addAWTEventListener(this, -2147352464L);
                return null;
            });
            Component invoker = newPath[0].getComponent();
            if (invoker instanceof JPopupMenu) {
                invoker = ((JPopupMenu)invoker).getInvoker();
            }
            Window window = invoker == null ? null : (this.grabbedWindow = invoker instanceof Window ? (Window)invoker : SwingUtilities.getWindowAncestor(invoker));
            if (this.grabbedWindow != null) {
                if (tk instanceof SunToolkit) {
                    ((SunToolkit)tk).grab(this.grabbedWindow);
                } else {
                    this.grabbedWindow.addComponentListener(this);
                    this.grabbedWindow.addWindowListener(this);
                }
            }
        }

        public void uninstall() {
            MenuSelectionManager.defaultManager().removeChangeListener(this);
            this.ungrabWindow();
            mouseGrabber = null;
        }

        protected void ungrabWindow() {
            Toolkit tk = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(() -> {
                tk.removeAWTEventListener(this);
                return null;
            });
            this.realUngrabWindow();
        }

        protected void realUngrabWindow() {
            Toolkit tk = Toolkit.getDefaultToolkit();
            if (this.grabbedWindow != null) {
                if (tk instanceof SunToolkit) {
                    ((SunToolkit)tk).ungrab(this.grabbedWindow);
                } else {
                    this.grabbedWindow.removeComponentListener(this);
                    this.grabbedWindow.removeWindowListener(this);
                }
                this.grabbedWindow = null;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] p = msm.getSelectedPath();
            if (this.lastPathSelected.length == 0 && p.length != 0) {
                this.grabWindow(p);
            }
            if (this.lastPathSelected.length != 0 && p.length == 0) {
                this.ungrabWindow();
            }
            this.lastPathSelected = p;
        }

        @Override
        public void eventDispatched(AWTEvent ev) {
            if (ev instanceof UngrabEvent) {
                this.cancelPopupMenu();
                return;
            }
            if (!(ev instanceof MouseEvent)) {
                return;
            }
            MouseEvent me = (MouseEvent)ev;
            Component src = me.getComponent();
            switch (me.getID()) {
                case 501: {
                    if (this.isInPopup(src) || src instanceof JMenu && ((JMenu)src).isSelected()) {
                        return;
                    }
                    if (src instanceof JComponent && HIDE_POPUP_VALUE.equals(((JComponent)src).getClientProperty(DarkPopupMenuUI.KEY_DO_NOT_CANCEL_POPUP))) break;
                    this.cancelPopupMenu();
                    boolean consumeEvent = UIManager.getBoolean("PopupMenu.consumeEventOnClose");
                    if (!consumeEvent || src instanceof MenuElement) break;
                    me.consume();
                    break;
                }
                case 502: {
                    if (!(src instanceof MenuElement) && this.isInPopup(src) || !(src instanceof JMenu) && src instanceof JMenuItem) break;
                    MenuSelectionManager.defaultManager().processMouseEvent(me);
                    break;
                }
                case 506: {
                    if (!(src instanceof MenuElement) && this.isInPopup(src)) break;
                    MenuSelectionManager.defaultManager().processMouseEvent(me);
                    break;
                }
                case 507: {
                    if (this.isInPopup(src) || src instanceof JComboBox && ((JComboBox)src).isPopupVisible() || src instanceof JWindow && src.isVisible() || src instanceof JMenuItem && src.isVisible() || src instanceof JFrame || src instanceof JDialog) {
                        return;
                    }
                    this.cancelPopupMenu();
                }
            }
        }

        protected void cancelPopupMenu() {
            try {
                List<JPopupMenu> popups = DarkPopupMenuUI.getPopups();
                for (JPopupMenu popup : popups) {
                    popup.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            catch (Error | RuntimeException ex) {
                this.realUngrabWindow();
                throw ex;
            }
        }

        protected boolean isInPopup(Component src) {
            for (Component c = src; c != null && !(c instanceof Applet) && !(c instanceof Window); c = c.getParent()) {
                if (c instanceof JPopupMenu) {
                    return true;
                }
                if (!(c instanceof JComponent) || !Boolean.TRUE.equals(((JComponent)c).getClientProperty(DarkPopupMenuUI.KEY_DO_NOT_CANCEL_ON_SCROLL))) continue;
                return true;
            }
            return false;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.cancelPopupMenu();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.cancelPopupMenu();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.cancelPopupMenu();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.cancelPopupMenu();
        }
    }

    protected static class StringBufferWrapper {
        private final StringBuffer buffer;

        protected StringBufferWrapper(StringBuffer buffer) {
            this.buffer = buffer;
        }

        public String toString() {
            return this.buffer.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || this.buffer == null) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }
}

