/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.filechooser;

import com.github.weisj.darklaf.components.tooltip.TooltipAwareButton;
import com.github.weisj.darklaf.components.tooltip.TooltipAwareToggleButton;
import com.github.weisj.darklaf.ui.filechooser.DarkFileChooserUIBridge;
import com.github.weisj.darklaf.ui.filechooser.DarkFilePane;
import com.github.weisj.darklaf.ui.filechooser.DarkFilePaneUIBridge;
import com.github.weisj.darklaf.ui.filechooser.DarkFilterComboBoxRenderer;
import com.github.weisj.darklaf.ui.filechooser.FileTextField;
import com.github.weisj.darklaf.util.AlignmentExt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;

public class DarkFileChooserUI
extends DarkFileChooserUIBridge {
    public static final String KEY_VIEW_TYPE = "viewType";
    protected DarkFileChooserUIBridge.AlignedLabel filesOfTypeLabel;

    public DarkFileChooserUI(JFileChooser b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarkFileChooserUI((JFileChooser)c);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        fc.setBorder(new EmptyBorder(10, 10, 7, 10));
        fc.setLayout(new BorderLayout(0, 7));
        this.filePane = this.createFilePane(fc);
        fc.add((Component)this.createTopPanel(fc), "North");
        fc.add((Component)this.filePane, "Center");
        fc.add((Component)this.createBottomPanel(fc), "South");
        fc.add((Component)this.createControlPanel(fc), "After");
        this.setupButtonPanel(fc);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        DarkFileChooserUI.groupLabels(new DarkFileChooserUIBridge.AlignedLabel[]{this.fileNameLabel, this.filesOfTypeLabel});
    }

    protected void setupButtonPanel(JFileChooser fileChooser) {
        JPanel buttonPanel = this.getButtonPanel();
        buttonPanel.setLayout(new DarkButtonAreaLayout());
        this.approveButton = new TooltipAwareButton(this.getApproveButtonText(fileChooser));
        this.approveButton.putClientProperty("JButton.noShadowOverwrite", true);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fileChooser));
        this.cancelButton = new TooltipAwareButton(this.cancelButtonText);
        this.cancelButton.putClientProperty("JButton.noShadowOverwrite", true);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        buttonPanel.add(this.approveButton);
        buttonPanel.add(this.cancelButton);
    }

    protected JComponent createControlPanel(JFileChooser fileChooser) {
        JPanel accessoryPanel = this.getAccessoryPanel();
        JComponent accessory = fileChooser.getAccessory();
        if (accessory != null) {
            accessoryPanel.add(accessory);
        }
        return accessoryPanel;
    }

    protected DarkFilePaneUIBridge createFilePane(JFileChooser fileChooser) {
        DarkFilePane filePane = new DarkFilePane(new DarkFileChooserUIBridge.MetalFileChooserUIAccessor(this));
        fileChooser.addPropertyChangeListener(filePane);
        filePane.addPropertyChangeListener(e -> {
            if (KEY_VIEW_TYPE.equals(e.getPropertyName())) {
                int viewType = filePane.getViewType();
                switch (viewType) {
                    case 0: {
                        this.listViewButton.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.detailsViewButton.setSelected(true);
                    }
                }
            }
        });
        filePane.setPreferredSize(LIST_PREF_SIZE);
        return filePane;
    }

    protected JComponent createBottomPanel(JFileChooser fileChooser) {
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.add(this.createFileNamePanel(fileChooser));
        bottomPanel.add(this.makeVerticalSpacer());
        bottomPanel.add(this.createFileTypePanel(fileChooser));
        return bottomPanel;
    }

    protected JComponent createFileNamePanel(JFileChooser fileChooser) {
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        this.fileNameLabel = new DarkFileChooserUIBridge.AlignedLabel(this);
        this.populateFileNameLabel();
        fileNamePanel.add(this.fileNameLabel);
        this.fileNameTextField = new FileTextField();
        fileNamePanel.add(this.fileNameTextField);
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!DarkFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    DarkFileChooserUI.this.filePane.clearSelection();
                }
            }
        });
        if (fileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fileChooser.getSelectedFile()));
        }
        return fileNamePanel;
    }

    protected Component createFileTypePanel(JFileChooser fileChooser) {
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        this.filesOfTypeLabel = new DarkFileChooserUIBridge.AlignedLabel(this, this.filesOfTypeLabelText);
        this.filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(this.filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = this.createFilterComboBox(this.filterComboBoxModel);
        this.filesOfTypeLabel.setLabelFor(this.filterComboBox);
        filesOfTypePanel.add(this.filterComboBox);
        return filesOfTypePanel;
    }

    protected JComboBox<Object> createFilterComboBox(ComboBoxModel<Object> model) {
        final JComboBox<Object> comboBox = new JComboBox<Object>(model);
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                comboBox.setEnabled(comboBox.getItemCount() > 1);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                comboBox.setEnabled(comboBox.getItemCount() > 1);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                comboBox.setEnabled(comboBox.getItemCount() > 1);
            }
        });
        comboBox.putClientProperty("AccessibleDescription", this.filesOfTypeLabelText);
        comboBox.setRenderer(this.createFilterComboBoxRenderer());
        return comboBox;
    }

    protected JComponent createTopPanel(JFileChooser fileChooser) {
        JPanel topPanel = new JPanel(new BorderLayout(10, 0));
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.directoryComboBox = this.createDirectoryComboBox(fileChooser);
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        topPanel.add((Component)this.lookInLabel, "Before");
        topPanel.add((Component)this.directoryComboBox, "Center");
        topPanel.add(this.createTopButtonArea(), "After");
        return topPanel;
    }

    private JComboBox<Object> createDirectoryComboBox(JFileChooser fileChooser) {
        JComboBox<Object> comboBox = new JComboBox<Object>(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 150;
                return d;
            }
        };
        comboBox.putClientProperty("AccessibleDescription", this.lookInLabelText);
        comboBox.addActionListener(this.directoryComboBoxAction);
        comboBox.setRenderer(this.createDirectoryComboBoxRenderer(fileChooser));
        comboBox.setAlignmentX(0.0f);
        comboBox.setAlignmentY(0.0f);
        comboBox.setMaximumRowCount(8);
        return comboBox;
    }

    protected Component createTopButtonArea() {
        Box box = Box.createHorizontalBox();
        box.add(this.createUpFolderButton());
        box.add(this.makeHorizontalSpacer());
        box.add(this.createHomeButton());
        box.add(this.makeHorizontalSpacer());
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            box.add(this.createNewDirectoryButton());
            box.add(this.makeHorizontalSpacer());
        }
        box.add(this.createViewButtonArea());
        box.add(Box.createGlue());
        return box;
    }

    protected Component makeHorizontalSpacer() {
        return Box.createRigidArea(hstrut5);
    }

    protected Component makeVerticalSpacer() {
        return Box.createRigidArea(vstrut5);
    }

    protected JComponent createViewButtonArea() {
        Box box = Box.createHorizontalBox();
        this.listViewButton = this.createListViewButton();
        this.detailsViewButton = this.createDetailsViewButton();
        this.listViewButton.putClientProperty("JButton.rightNeighbour", this.detailsViewButton);
        this.detailsViewButton.putClientProperty("JButton.leftNeighbour", this.listViewButton);
        box.add(this.listViewButton);
        box.add(this.detailsViewButton);
        this.listViewButton.addItemListener(e -> this.detailsViewButton.setSelected(!this.listViewButton.isSelected()));
        this.detailsViewButton.addItemListener(e -> this.listViewButton.setSelected(!this.detailsViewButton.isSelected()));
        return box;
    }

    protected JButton createNewDirectoryButton() {
        TooltipAwareButton b = new TooltipAwareButton(this.filePane.getNewFolderAction());
        this.setupButton(b, this.newFolderAccessibleName, this.newFolderToolTipText);
        b.setText(null);
        b.setIcon(this.newFolderIcon);
        return b;
    }

    protected JButton createHomeButton() {
        TooltipAwareButton b = new TooltipAwareButton(this.homeFolderIcon);
        this.setupButton(b, this.homeFolderAccessibleName, this.homeFolderToolTipText);
        b.addActionListener(this.getGoHomeAction());
        return b;
    }

    protected JButton createUpFolderButton() {
        TooltipAwareButton upFolderButton = new TooltipAwareButton(this.getChangeToParentDirectoryAction());
        this.setupButton(upFolderButton, this.upFolderAccessibleName, this.upFolderToolTipText);
        upFolderButton.setText(null);
        upFolderButton.setIcon(this.upFolderIcon);
        return upFolderButton;
    }

    protected JToggleButton createDetailsViewButton() {
        TooltipAwareToggleButton button = new TooltipAwareToggleButton(this.detailsViewIcon);
        this.setupButton(button, this.detailsViewButtonAccessibleName, this.detailsViewButtonToolTipText);
        Icon selectedDetailsViewIcon = UIManager.getIcon("FileChooser.detailsViewSelectedIcon");
        button.setSelectedIcon(selectedDetailsViewIcon);
        button.putClientProperty("JButton.cornerFlag", (Object)AlignmentExt.RIGHT);
        button.addActionListener(this.filePane.getViewTypeAction(1));
        return button;
    }

    protected JToggleButton createListViewButton() {
        TooltipAwareToggleButton button = new TooltipAwareToggleButton(this.listViewIcon);
        this.setupButton(button, this.listViewButtonAccessibleName, this.listViewButtonToolTipText);
        Icon selectedListViewIcon = UIManager.getIcon("FileChooser.listViewSelectedIcon");
        button.setSelectedIcon(selectedListViewIcon);
        button.putClientProperty("JButton.cornerFlag", (Object)AlignmentExt.LEFT);
        button.addActionListener(this.filePane.getViewTypeAction(0));
        button.setSelected(true);
        return button;
    }

    protected void setupButton(AbstractButton button, String accessibleName, String tipText) {
        button.putClientProperty("JButton.noShadowOverwrite", true);
        button.putClientProperty("JButton.square", true);
        button.putClientProperty("JButton.alternativeArc", true);
        button.putClientProperty("JButton.square", Boolean.TRUE);
        button.setAlignmentX(0.0f);
        button.setAlignmentY(0.5f);
        button.setToolTipText(tipText);
        button.putClientProperty("AccessibleName", accessibleName);
    }

    @Override
    protected ListCellRenderer<Object> createFilterComboBoxRenderer() {
        return new DarkFilterComboBoxRenderer();
    }

    protected static class DarkButtonAreaLayout
    extends DarkFileChooserUIBridge.ButtonAreaLayout {
        protected DarkButtonAreaLayout() {
            this.topMargin = 5;
        }
    }
}

