/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.combobox;

import com.github.weisj.darklaf.components.ArrowButton;
import com.github.weisj.darklaf.decorators.LayoutManagerDelegate;
import com.github.weisj.darklaf.ui.combobox.DarkComboPopup;
import com.github.weisj.darklaf.ui.list.DarkListCellRenderer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class DarkComboBoxUI
extends BasicComboBoxUI
implements Border,
PropertyChangeListener {
    protected static final String KEY_PREFIX = "JComboBox.";
    public static final String KEY_IS_TREE_EDITOR = "JComboBox.isTreeCellEditor";
    public static final String KEY_IS_TABLE_EDITOR = "JComboBox.isTableCellEditor";
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            DarkComboBoxUI.this.comboBox.getEditor().getEditorComponent().requestFocus();
        }
    };
    protected int arcSize;
    protected int borderSize;
    protected Color background;
    protected Color editBackground;
    protected Color inactiveBackground;
    protected Color inactiveForeground;
    protected Color focusBorderColor;
    protected Color borderColor;
    protected Color inactiveBorderColor;
    protected Color arrowBackground;
    protected Color arrowBackgroundEnd;
    private Insets boxPadding;
    private Insets cellPadding;

    public static ComponentUI createUI(JComponent c) {
        return new DarkComboBoxUI();
    }

    protected static boolean isTableCellEditor(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(KEY_IS_TABLE_EDITOR));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.comboBox.addMouseListener(this.mouseListener);
        this.comboBox.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.mouseListener);
        this.comboBox.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.comboBox, "opaque", false);
        this.arcSize = UIManager.getInt("ComboBox.arc");
        this.boxPadding = UIManager.getInsets("ComboBox.insets");
        this.borderSize = UIManager.getInt("ComboBox.borderThickness");
        this.background = UIManager.getColor("ComboBox.activeBackground");
        this.editBackground = UIManager.getColor("ComboBox.editBackground");
        this.inactiveBackground = UIManager.getColor("ComboBox.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.focusBorderColor = UIManager.getColor("ComboBox.focusBorderColor");
        this.borderColor = UIManager.getColor("ComboBox.activeBorderColor");
        this.inactiveBorderColor = UIManager.getColor("ComboBox.inactiveBorderColor");
        this.arrowBackground = UIManager.getColor("ComboBox.arrowBackground");
        this.cellPadding = UIManager.getInsets("ComboBox.cellEditorInsets");
        if (this.boxPadding == null) {
            this.boxPadding = new Insets(0, 0, 0, 0);
        }
        if (this.cellPadding == null) {
            this.cellPadding = new Insets(0, 0, 0, 0);
        }
        this.comboBox.setBorder(this);
    }

    @Override
    protected ComboPopup createPopup() {
        return new DarkComboPopup(this.comboBox);
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new DarkListCellRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        Component comp = comboBoxEditor.getEditorComponent();
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.process(e);
            }

            private void process(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 38 || code == 40) && e.getModifiersEx() == 0) {
                    DarkComboBoxUI.this.comboBox.dispatchEvent(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.process(e);
            }
        });
        comp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DarkComboBoxUI.this.comboBox.revalidate();
                DarkComboBoxUI.this.comboBox.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DarkComboBoxUI.this.comboBox.revalidate();
                DarkComboBoxUI.this.comboBox.repaint();
            }
        });
        return comboBoxEditor;
    }

    @Override
    protected JButton createArrowButton() {
        int buttonPad = UIManager.getInt("ComboBox.buttonPad");
        JButton button = ArrowButton.createUpDownArrow(this.comboBox, new ComboIcon(this.comboBox, UIManager.getIcon("ComboBox.arrowEditable.icon"), UIManager.getIcon("ComboBox.arrow.icon")), UIManager.getIcon("ComboBox.arrowInactive.icon"), 5, true, false, new Insets(0, buttonPad, 0, buttonPad));
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g, c, c.getWidth(), c.getHeight());
        Rectangle r = this.rectangleForCurrentValue();
        this.paintCurrentValue(g, r, this.hasFocus);
    }

    private void paintBackground(Graphics g, JComponent c, int width, int height) {
        Container parent = c.getParent();
        if (parent != null && parent.isOpaque()) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.comboBox.isEditable() && this.comboBox.getEditor() != null) {
            Component editorComp = this.comboBox.getEditor().getEditorComponent();
            if (this.comboBox.isEnabled()) {
                g.setColor(editorComp.getBackground());
            } else {
                g.setColor(this.inactiveBackground);
            }
        } else {
            g.setColor(this.getBackground(this.comboBox));
        }
        if (!DarkComboBoxUI.isTableCellEditor(c) && !DarkComboBoxUI.isTreeCellEditor(c)) {
            DarkUIUtil.fillRoundRect((Graphics2D)g, this.borderSize, this.borderSize, width - 2 * this.borderSize, height - 2 * this.borderSize, this.arcSize);
        } else {
            g.fillRect(0, 0, width, height);
        }
    }

    protected Color getBackground(JComboBox<?> c) {
        if (!c.isEnabled()) {
            return this.inactiveBackground;
        }
        if (c.isEditable()) {
            return this.editBackground;
        }
        return this.background;
    }

    protected static boolean isTreeCellEditor(Component c) {
        return c instanceof JComponent && Boolean.TRUE.equals(((JComponent)c).getClientProperty(KEY_IS_TREE_EDITOR));
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManagerDelegate(super.createLayoutManager()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                if (DarkComboBoxUI.isTreeCellEditor(DarkComboBoxUI.this.comboBox) || DarkComboBoxUI.isTableCellEditor(DarkComboBoxUI.this.comboBox)) {
                    int adj = DarkComboBoxUI.this.borderSize / 2;
                    if (!DarkComboBoxUI.this.comboBox.getComponentOrientation().isLeftToRight()) {
                        adj *= -1;
                    }
                    Rectangle bounds = DarkComboBoxUI.this.arrowButton.getBounds();
                    bounds.x += adj;
                    DarkComboBoxUI.this.arrowButton.setBounds(bounds);
                }
            }
        };
    }

    private Color getForeground() {
        return this.comboBox.isEnabled() ? this.comboBox.getForeground() : this.inactiveForeground;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        int buttonHeight = size.height;
        int buttonWidth = this.squareButton ? buttonHeight : this.arrowButton.getPreferredSize().width + this.arrowButton.getInsets().left + this.arrowButton.getInsets().right;
        size.height += insets.top + insets.bottom;
        size.width += insets.left + insets.right + buttonWidth;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rect = super.rectangleForCurrentValue();
        if (this.comboBox.isEditable()) {
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                rect.x += this.boxPadding.left;
                rect.width -= this.boxPadding.left;
            } else {
                rect.width -= this.borderSize + 1;
                ++rect.x;
            }
        }
        return rect;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean changeOpaque;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getForeground());
            c.setBackground(this.listBox.getBackground());
        } else {
            c.setForeground(this.getForeground());
            c.setBackground(this.getBackground(this.comboBox));
        }
        boolean bl = changeOpaque = DarkComboBoxUI.isTableCellEditor(this.comboBox) && c.isOpaque();
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = c instanceof JPanel;
        Rectangle r = new Rectangle(bounds);
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        boolean isTableCellEditor = DarkComboBoxUI.isTableCellEditor(this.comboBox);
        boolean isTreeCellEditor = DarkComboBoxUI.isTreeCellEditor(this.comboBox);
        int bSize = !isTableCellEditor && !isTreeCellEditor ? this.borderSize : 0;
        int arc = this.arcSize;
        this.checkFocus();
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext config = new GraphicsContext(g);
        g.translate(x, y);
        if (this.comboBox.isEditable()) {
            Area iconRect;
            Area rect;
            int off;
            Rectangle arrowBounds = this.arrowButton.getBounds();
            boolean leftToRight = this.comboBox.getComponentOrientation().isLeftToRight();
            int n = off = leftToRight ? arrowBounds.x : arrowBounds.x + arrowBounds.width;
            if (!isTableCellEditor && !isTreeCellEditor) {
                rect = new Area(new RoundRectangle2D.Double(bSize - 1, bSize - 1, width - 2 * bSize + 1, height - 2 * bSize + 1, arc, arc));
                iconRect = new Area(new Rectangle(off, 0, width, height));
            } else {
                rect = new Area(new Rectangle(0, 0, width, height));
                iconRect = new Area(new Rectangle(off, 0, width, height));
            }
            if (leftToRight) {
                rect.intersect(iconRect);
            } else {
                rect.subtract(iconRect);
            }
            g.setPaint(this.getArrowBackground(this.comboBox));
            g.fill(rect);
            g.setColor(this.getBorderColor());
            g.fillRect(off, bSize - 1, 1, height - 2 * bSize + 1);
        }
        if (!isTableCellEditor && !isTreeCellEditor) {
            if (this.hasFocus) {
                DarkUIUtil.paintFocusBorder(g, width, height, this.arcSize, this.borderSize);
                g.setColor(this.focusBorderColor);
            } else {
                g.setColor(this.getBorderColor());
            }
            DarkUIUtil.paintLineBorder(g, bSize, bSize, width - 2 * bSize, height - 2 * bSize, arc);
        } else {
            g.setColor(this.getBorderColor());
            Container parent = c.getParent();
            if (DarkComboBoxUI.isTableCellEditor(c) && parent instanceof JTable) {
                JTable table = (JTable)parent;
                if (!table.getShowHorizontalLines()) {
                    g.fillRect(0, 0, width, 1);
                    g.fillRect(0, height - 1, width, 1);
                }
                if (!table.getShowVerticalLines()) {
                    g.fillRect(0, 0, 1, height);
                    g.fillRect(width - 1, 0, 1, height);
                }
            } else {
                DarkUIUtil.drawRect(g, 0, 0, width, height, 1);
            }
        }
        g.translate(-x, -y);
        config.restore();
    }

    private void checkFocus() {
        this.hasFocus = DarkUIUtil.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        Component component = this.editor = ed == null ? null : ed.getEditorComponent();
        if (this.editor != null) {
            this.hasFocus = DarkUIUtil.hasFocus(this.editor);
        }
    }

    protected Paint getArrowBackground(JComboBox<?> c) {
        if (!c.isEnabled()) {
            return this.inactiveBackground;
        }
        if (c.isEditable()) {
            return this.arrowBackground;
        }
        return this.background;
    }

    private Color getBorderColor() {
        return this.comboBox.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarkComboBoxUI.isTableCellEditor(c) || DarkComboBoxUI.isTreeCellEditor(c)) {
            return new InsetsUIResource(this.cellPadding.top, this.cellPadding.left, this.cellPadding.bottom, this.cellPadding.right);
        }
        if (c.getComponentOrientation().isLeftToRight()) {
            return new InsetsUIResource(this.boxPadding.top, this.boxPadding.left, this.boxPadding.bottom, this.borderSize);
        }
        return new InsetsUIResource(this.boxPadding.top, this.borderSize, this.boxPadding.bottom, this.boxPadding.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return !DarkComboBoxUI.isTableCellEditor(this.comboBox);
    }

    public void resetPopup() {
        ((DarkComboPopup)this.popup).reset();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("componentOrientation".equals(key)) {
            this.comboBox.doLayout();
            this.comboBox.repaint();
            this.comboBox.getEditor().getEditorComponent().setComponentOrientation(this.comboBox.getComponentOrientation());
        } else if ("editable".equals(key)) {
            this.comboBox.repaint();
        } else if (KEY_IS_TABLE_EDITOR.equals(key) || KEY_IS_TREE_EDITOR.equals(key)) {
            this.comboBox.revalidate();
            this.comboBox.repaint();
        }
    }

    private static class ComboIcon
    implements Icon {
        private final JComboBox<?> box;
        private final Icon editableIcon;
        private final Icon icon;

        private ComboIcon(JComboBox<?> box, Icon editableIcon, Icon icon) {
            this.box = box;
            this.editableIcon = editableIcon;
            this.icon = icon;
        }

        private Icon getIcon() {
            return this.box.isEditable() ? this.editableIcon : this.icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getIcon().getIconHeight();
        }
    }
}

