/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.ui.colorchooser.ColorWheel;
import com.github.weisj.darklaf.ui.colorchooser.SlideComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorWheelPanel
extends JPanel {
    private final ColorWheel colorWheel;
    private final SlideComponent brightnessSlider;
    private SlideComponent opacitySlider = null;
    private boolean enableOpacity;

    public ColorWheelPanel(ColorListener colorListener, boolean enableOpacity, boolean opacityInPercent) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.enableOpacity = enableOpacity;
        this.colorWheel = new ColorWheel();
        this.add((Component)this.colorWheel, "Center");
        this.brightnessSlider = new SlideComponent("Brightness", true, false);
        this.brightnessSlider.setToolTipText("Brightness");
        this.brightnessSlider.addListener(value -> {
            this.colorWheel.setBrightness(1.0f - (float)value.intValue() / 255.0f);
            this.colorWheel.repaint();
        });
        this.add((Component)this.brightnessSlider, "East");
        this.colorWheel.addListener(colorListener);
        this.colorWheel.addListener(this.brightnessSlider);
        if (enableOpacity) {
            this.opacitySlider = new SlideComponent("Opacity", false, true);
            this.opacitySlider.setToolTipText("Opacity");
            this.opacitySlider.setUnits(opacityInPercent ? SlideComponent.Unit.PERCENT : SlideComponent.Unit.LEVEL);
            this.opacitySlider.addListener(integer -> {
                this.colorWheel.setOpacity((int)integer);
                this.colorWheel.repaint();
            });
            this.add((Component)this.opacitySlider, "South");
            this.colorWheel.addListener(this.opacitySlider);
        }
    }

    public void setColor(Color color, Object source) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        this.brightnessSlider.setValue(255 - (int)(hsb[2] * 255.0f));
        this.brightnessSlider.repaint();
        this.colorWheel.dropImage();
        if (this.opacitySlider != null && source instanceof AbstractColorChooserPanel) {
            this.opacitySlider.setValue(color.getAlpha());
            this.opacitySlider.repaint();
        }
        this.colorWheel.setColor(color, source, hsb[0], hsb[1], hsb[2]);
    }

    public boolean isColorTransparencySelectionEnabled() {
        return this.enableOpacity;
    }

    public void setColorTransparencySelectionEnabled(boolean b) {
        if (b != this.enableOpacity) {
            this.enableOpacity = b;
            this.opacitySlider.setEnabled(b);
            this.opacitySlider.setVisible(b);
        }
    }
}

