/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.ui.colorchooser.ColorWheelImageProducer;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ColorWheel
extends JComponent {
    private static final int BORDER_SIZE = 5;
    private final List<ColorListener> myListeners = new ArrayList<ColorListener>();
    protected Color dropFill;
    protected Color dropBorder;
    protected Color background;
    private float myBrightness = 1.0f;
    private float myHue = 1.0f;
    private float mySaturation = 0.0f;
    private Image myImage;
    private Rectangle myWheel;
    private boolean myShouldInvalidate = true;
    private Color myColor;
    private int myOpacity;
    private boolean pressedInside;

    public ColorWheel() {
        this.setOpaque(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ColorWheel.this.myShouldInvalidate = true;
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!ColorWheel.this.pressedInside) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                int mx = ((ColorWheel)ColorWheel.this).myWheel.x + ((ColorWheel)ColorWheel.this).myWheel.width / 2;
                int my = ((ColorWheel)ColorWheel.this).myWheel.y + ((ColorWheel)ColorWheel.this).myWheel.height / 2;
                double s = Math.sqrt((x - mx) * (x - mx) + (y - my) * (y - my)) / ((double)((ColorWheel)ColorWheel.this).myWheel.height / 2.0);
                double h = -Math.atan2(y - my, x - mx) / (Math.PI * 2);
                if (h < 0.0) {
                    h += 1.0;
                }
                if (s > 1.0) {
                    s = 1.0;
                }
                ColorWheel.this.setHSBValue((float)h, (float)s, ColorWheel.this.myBrightness, ColorWheel.this.myOpacity);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int mx = ((ColorWheel)ColorWheel.this).myWheel.x + ((ColorWheel)ColorWheel.this).myWheel.width / 2;
                int my = ((ColorWheel)ColorWheel.this).myWheel.y + ((ColorWheel)ColorWheel.this).myWheel.height / 2;
                double s = Math.sqrt((x - mx) * (x - mx) + (y - my) * (y - my)) / ((double)((ColorWheel)ColorWheel.this).myWheel.height / 2.0);
                double h = -Math.atan2(y - my, x - mx) / (Math.PI * 2);
                if (h < 0.0) {
                    h += 1.0;
                }
                if (s <= 1.0) {
                    ColorWheel.this.pressedInside = true;
                    ColorWheel.this.setHSBValue((float)h, (float)s, ColorWheel.this.myBrightness, ColorWheel.this.myOpacity);
                } else {
                    ColorWheel.this.pressedInside = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ColorWheel.this.pressedInside = false;
            }
        });
        this.background = UIManager.getColor("ColorChooser.colorWheelBackground");
        this.dropFill = UIManager.getColor("ColorChooser.colorWheelDropBackgroundColor");
        this.dropBorder = UIManager.getColor("ColorChooser.colorWheelDropBorderColor");
    }

    private void setHSBValue(float h, float s, float b, int opacity) {
        Color rgb = new Color(Color.HSBtoRGB(h, s, b));
        this.setColor(ColorUtil.toAlpha(rgb, opacity), this, h, s, b);
    }

    public void setColor(Color color, Object source, float h, float s, float b) {
        this.myColor = color;
        this.myHue = h;
        this.mySaturation = s;
        this.myBrightness = b;
        this.myOpacity = color.getAlpha();
        this.fireColorChanged(source);
        this.repaint();
    }

    private void fireColorChanged(Object source) {
        for (ColorListener listener : this.myListeners) {
            listener.colorChanged(this.myColor, source);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.background = UIManager.getColor("ColorChooser.colorWheelBackground");
        this.dropFill = UIManager.getColor("ColorChooser.colorWheelDropBackgroundColor");
        this.dropBorder = UIManager.getColor("ColorChooser.colorWheelDropBorderColor");
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = this.getSize();
        int _size = Math.min(size.width, size.height);
        _size = Math.min(_size, 600);
        if (this.myImage != null && this.myShouldInvalidate && this.myImage.getWidth(null) != _size) {
            this.myImage = null;
        }
        this.myShouldInvalidate = false;
        if (this.myImage == null) {
            this.myImage = this.createImage(new ColorWheelImageProducer(_size - 10, _size - 10, this.myBrightness));
            this.myWheel = new Rectangle(5, 5, _size - 10, _size - 10);
        }
        g2d.setColor(this.background);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        GraphicsContext config = new GraphicsContext(g);
        g2d.setComposite(AlphaComposite.getInstance(3, (float)this.myOpacity / 255.0f));
        g2d.drawImage(this.myImage, this.myWheel.x, this.myWheel.y, null);
        config.restore();
        int mx = this.myWheel.x + this.myWheel.width / 2;
        int my = this.myWheel.y + this.myWheel.height / 2;
        int arcw = (int)((float)this.myWheel.width * this.mySaturation / 2.0f);
        int arch = (int)((float)this.myWheel.height * this.mySaturation / 2.0f);
        double th = (double)(this.myHue * 2.0f) * Math.PI;
        int x = (int)((double)mx + (double)arcw * Math.cos(th));
        int y = (int)((double)my - (double)arch * Math.sin(th));
        g2d.setColor(this.dropFill);
        g2d.fillRect(x - 2, y - 2, 4, 4);
        g2d.setColor(this.dropBorder);
        DarkUIUtil.drawRect(g, x - 2, y - 2, 4, 4, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 300);
    }

    public void addListener(ColorListener listener) {
        this.myListeners.add(listener);
    }

    public void setBrightness(float brightness) {
        if (brightness != this.myBrightness) {
            this.myImage = null;
            this.setHSBValue(this.myHue, this.mySaturation, brightness, this.myOpacity);
        }
    }

    public void setOpacity(int opacity) {
        if (opacity != this.myOpacity) {
            this.setHSBValue(this.myHue, this.mySaturation, this.myBrightness, opacity);
        }
    }

    public void dropImage() {
        this.myImage = null;
    }
}

