/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.checkbox;

import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.checkbox.DarkCheckBoxBorder;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarkCheckBoxUI
extends MetalCheckBoxUI
implements PropertyChangeListener {
    private static final int ICON_OFF = 4;
    private static final int SIZE = 13;
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static Dimension size = new Dimension();
    private final RoundRectangle2D hitArea = new RoundRectangle2D.Float();
    protected JCheckBox checkBox;
    protected int arcSize;
    protected int borderSize;
    protected Color background;
    protected Color inactiveBackground;
    protected Color selectedBackground;
    protected Color borderColor;
    protected Color focusBorderColor;
    protected Color inactiveBorderColor;
    protected Color selectedBorderColor;
    protected Color checkColor;
    protected Color inactiveCheckColor;
    protected Color focusCheckColor;
    protected Color focusSelectedBorderColor;
    private Icon checkBoxIcon;
    private Icon checkBoxDisabledIcon;
    private Icon checkBoxFocusedIcon;
    private Icon checkBoxSelectedIcon;
    private Icon checkBoxSelectedDisabledIcon;
    private Icon checkBoxSelectedFocusedIcon;

    public static ComponentUI createUI(JComponent c) {
        return new DarkCheckBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.checkBox = (JCheckBox)c;
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.checkBox = null;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "opaque", false);
        this.checkBoxIcon = UIManager.getIcon("CheckBox.unchecked.icon");
        this.checkBoxDisabledIcon = UIManager.getIcon("CheckBox.uncheckedDisabled.icon");
        this.checkBoxFocusedIcon = UIManager.getIcon("CheckBox.uncheckedFocused.icon");
        this.checkBoxSelectedIcon = UIManager.getIcon("CheckBox.selected.icon");
        this.checkBoxSelectedDisabledIcon = UIManager.getIcon("CheckBox.selectedDisabled.icon");
        this.checkBoxSelectedFocusedIcon = UIManager.getIcon("CheckBox.selectedFocused.icon");
        this.arcSize = UIManager.getInt("CheckBox.arc");
        this.borderSize = UIManager.getInt("CheckBox.borderThickness");
        this.background = UIManager.getColor("CheckBox.activeFillColor");
        this.inactiveBackground = UIManager.getColor("CheckBox.inactiveFillColor");
        this.borderColor = UIManager.getColor("CheckBox.activeBorderColor");
        this.focusBorderColor = UIManager.getColor("CheckBox.focusBorderColor");
        this.inactiveBorderColor = UIManager.getColor("CheckBox.inactiveBorderColor");
        this.checkColor = UIManager.getColor("CheckBox.selectionSelectedColor");
        this.inactiveCheckColor = UIManager.getColor("CheckBox.selectionDisabledColor");
        this.selectedBorderColor = UIManager.getColor("CheckBox.selectedBorderColor");
        this.selectedBackground = UIManager.getColor("CheckBox.selectedFillColor");
        this.focusCheckColor = UIManager.getColor("CheckBox.selectionFocusSelectedColor");
        this.focusSelectedBorderColor = UIManager.getColor("CheckBox.focusSelectedBorderColor");
    }

    @Override
    protected void installListeners(AbstractButton button) {
        super.installListeners(button);
        button.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
        button.removePropertyChangeListener(this);
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        JCheckBox b = (JCheckBox)c;
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, c.getFont());
        String text = this.layoutCheckBox(b, fm);
        this.paintBackground(c, g);
        Icon icon = DarkCheckBoxUI.getIconBullet(c, g, b);
        if (icon != null) {
            icon.paintIcon(c, g, DarkCheckBoxUI.iconRect.x, DarkCheckBoxUI.iconRect.y);
        } else {
            Icon checkIcon = this.getCheckIcon(b);
            if (checkIcon != null) {
                checkIcon.paintIcon(c, g, DarkCheckBoxUI.iconRect.x, DarkCheckBoxUI.iconRect.y + 1);
            } else {
                this.paintDarkCheck(c, g, b);
            }
        }
        if (text != null) {
            DarkCheckBoxUI.paintText(g, b, textRect, text, fm, this.getDisabledTextColor());
        }
    }

    protected String layoutCheckBox(JCheckBox b, FontMetrics fm) {
        Insets i = b.getInsets();
        size = b.getSize(size);
        DarkCheckBoxUI.viewRect.x = i.left;
        DarkCheckBoxUI.viewRect.y = i.top;
        DarkCheckBoxUI.viewRect.width = DarkCheckBoxUI.size.width - (i.right + DarkCheckBoxUI.viewRect.x);
        DarkCheckBoxUI.viewRect.height = DarkCheckBoxUI.size.height - (i.bottom + DarkCheckBoxUI.viewRect.y);
        DarkCheckBoxUI.iconRect.height = 0;
        DarkCheckBoxUI.iconRect.width = 0;
        DarkCheckBoxUI.iconRect.y = 0;
        DarkCheckBoxUI.iconRect.x = 0;
        DarkCheckBoxUI.textRect.height = 0;
        DarkCheckBoxUI.textRect.width = 0;
        DarkCheckBoxUI.textRect.y = 0;
        DarkCheckBoxUI.textRect.x = 0;
        String text = SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (DarkCheckBoxBorder.isTableCellEditor(b) || DarkCheckBoxBorder.isTreeCellEditor(b)) {
            this.hitArea.setRoundRect(Math.max(DarkCheckBoxUI.iconRect.x, 0) + 4, Math.max(DarkCheckBoxUI.iconRect.y, 0) + 4, 13.0, 13.0, this.arcSize, this.arcSize);
        } else {
            int x = Math.min(DarkCheckBoxUI.iconRect.x, DarkCheckBoxUI.textRect.x);
            int y = Math.min(DarkCheckBoxUI.iconRect.y, DarkCheckBoxUI.textRect.y);
            int xEnd = Math.max(DarkCheckBoxUI.iconRect.x + DarkCheckBoxUI.iconRect.width, DarkCheckBoxUI.textRect.x + DarkCheckBoxUI.textRect.width);
            int yEnd = Math.max(DarkCheckBoxUI.iconRect.y + DarkCheckBoxUI.iconRect.height, DarkCheckBoxUI.textRect.y + DarkCheckBoxUI.textRect.y);
            this.hitArea.setRoundRect(x, y, xEnd - x, yEnd - y, 0.0, 0.0);
        }
        return text;
    }

    private void paintBackground(JComponent c, Graphics2D g) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static Icon getIconBullet(JComponent c, Graphics2D g, AbstractButton b) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (!model.isEnabled()) {
            icon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            icon = b.getPressedIcon();
            if (icon == null) {
                icon = b.getSelectedIcon();
            }
        } else if (model.isSelected()) {
            if (b.isRolloverEnabled() && model.isRollover()) {
                icon = b.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = b.getSelectedIcon();
                }
            } else {
                icon = b.getSelectedIcon();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            icon = b.getRolloverIcon();
        }
        if (icon == null) {
            icon = b.getIcon();
        }
        return icon;
    }

    protected Icon getCheckIcon(AbstractButton b) {
        boolean selected = b.isSelected();
        boolean enabled = b.isEnabled();
        boolean hasFocus = b.hasFocus();
        return selected ? (enabled ? (hasFocus ? this.checkBoxSelectedFocusedIcon : this.checkBoxSelectedIcon) : this.checkBoxSelectedDisabledIcon) : (enabled ? (hasFocus ? this.checkBoxFocusedIcon : this.checkBoxIcon) : this.checkBoxDisabledIcon);
    }

    protected void paintDarkCheck(JComponent c, Graphics2D g, JCheckBox b) {
        GraphicsContext config = new GraphicsContext(g);
        boolean enabled = b.isEnabled();
        g.translate(DarkCheckBoxUI.iconRect.x + 4, DarkCheckBoxUI.iconRect.y + 4);
        this.paintCheckBorder(g, enabled, b.hasFocus() && b.isFocusPainted(), b.isSelected(), this.arcSize, this.borderSize);
        if (b.isSelected()) {
            this.paintCheckArrow(g, enabled, b.hasFocus() && b.isFocusPainted());
        }
        g.translate(-DarkCheckBoxUI.iconRect.x - 4, -DarkCheckBoxUI.iconRect.y - 4);
        config.restore();
    }

    public static void paintText(Graphics2D g, AbstractButton b, Rectangle textRect, String text, FontMetrics fm, Color disabledTextColor) {
        GraphicsContext context = GraphicsUtil.setupAntialiasing(g);
        g.setFont(b.getFont());
        View view = (View)b.getClientProperty("html");
        if (view != null) {
            view.paint(g, textRect);
        } else {
            g.setColor(b.isEnabled() ? b.getForeground() : disabledTextColor);
            SwingUtilities2.drawStringUnderlineCharAt(b, g, text, b.getDisplayedMnemonicIndex(), textRect.x, textRect.y + fm.getAscent());
        }
        context.restore();
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }

    protected void paintCheckBorder(Graphics2D g, boolean enabled, boolean focus, boolean selected, int arcSize, int borderSize) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color bgColor = this.getFillColor(selected, enabled);
        Color border = this.getBorderColor(selected, focus, enabled);
        g.setColor(bgColor);
        DarkUIUtil.fillRoundRect(g, 0.0f, 0.0f, 13.0f, 13.0f, arcSize);
        if (focus) {
            g2.translate(-borderSize, -borderSize);
            DarkUIUtil.paintFocusBorder(g2, 13 + 2 * borderSize, 13 + 2 * borderSize, arcSize, borderSize);
            g2.translate(borderSize, borderSize);
        }
        g.setColor(border);
        DarkUIUtil.paintLineBorder(g, 0.0f, 0.0f, 13.0f, 13.0f, arcSize);
        g2.dispose();
    }

    protected void paintCheckArrow(Graphics2D g, boolean enabled, boolean focus) {
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        g.setStroke(new BasicStroke(2.0f, 1, 1));
        Color color = this.getCheckColor(focus, enabled);
        g.setPaint(color);
        Path2D.Float check = new Path2D.Float(0);
        ((Path2D)check).moveTo(2.5, 8.0);
        ((Path2D)check).lineTo(5.5, 10.0);
        ((Path2D)check).lineTo(10.3, 3.0);
        g.draw(check);
        config.restore();
    }

    protected Color getFillColor(boolean selected, boolean enabled) {
        return enabled ? (selected ? this.selectedBackground : this.background) : this.inactiveBorderColor;
    }

    protected Color getBorderColor(boolean selected, boolean focus, boolean enabled) {
        return enabled ? (focus ? (selected ? this.focusSelectedBorderColor : this.focusBorderColor) : (selected ? this.selectedBorderColor : this.borderColor)) : this.inactiveBorderColor;
    }

    protected Color getCheckColor(boolean focus, boolean enabled) {
        return enabled ? (focus ? this.focusCheckColor : this.checkColor) : this.inactiveCheckColor;
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.hitArea.isEmpty() && c instanceof JCheckBox) {
            this.layoutCheckBox((JCheckBox)c, c.getFontMetrics(c.getFont()));
        }
        return this.hitArea.contains(x, y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("componentOrientation".equals(key)) {
            this.checkBox.repaint();
            this.hitArea.setRoundRect(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else if ("JToggleButton.isTreeCellEditor".equals(key) || "JToggleButton.isTableCellEditor".equals(key)) {
            this.checkBox.repaint();
            this.hitArea.setRoundRect(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else if ("JToggleButton.clearHitArea".equals(key)) {
            this.hitArea.setRoundRect(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

