/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.ui.button.DarkButtonUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

public class DarkToggleButtonUI
extends DarkButtonUI {
    protected static final String KEY_PREFIX = "JToggleButton.";
    public static final String KEY_VARIANT = "JToggleButton.variant";
    public static final String KEY_IS_TREE_EDITOR = "JToggleButton.isTreeCellEditor";
    public static final String KEY_IS_TREE_RENDER = "JToggleButton.isTreeCellRenderer";
    public static final String KEY_IS_TABLE_EDITOR = "JToggleButton.isTableCellEditor";
    public static final String KEY_IS_TABLE_RENDERER = "JToggleButton.isTableCellRenderer";
    public static final String KEY_CLEAR_HIT_AREA = "JToggleButton.clearHitArea";
    public static final String VARIANT_SLIDER = "slider";
    private static final Rectangle rect = new Rectangle();
    private final PropertyChangeListener propertyChangeListener = evt -> {
        String key = evt.getPropertyName();
        if (KEY_VARIANT.equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal != null && oldVal.equals(newVal)) {
                return;
            }
            if (VARIANT_SLIDER.equals(newVal)) {
                this.button.setBorderPainted(false);
            } else {
                this.button.setBorderPainted(true);
            }
        } else if ("componentOrientation".equals(key)) {
            this.button.repaint();
        }
    };
    protected Dimension sliderSize;
    protected Color background;
    protected Color backgroundInactive;
    protected Color focusBorderColor;
    protected Color borderColor;
    protected Color inactiveBorderColor;
    protected Color sliderColor;
    protected Color inactiveSliderColor;
    protected Color sliderBorderColor;
    protected Color inactiveSliderBorderColor;
    protected Color selectedForeground;

    public static ComponentUI createUI(JComponent c) {
        return new DarkToggleButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.sliderSize = UIManager.getDimension("ToggleButton.sliderSize");
        this.background = UIManager.getColor("ToggleButton.activeFillColor");
        this.backgroundInactive = UIManager.getColor("ToggleButton.inactiveFillColor");
        this.focusBorderColor = UIManager.getColor("ToggleButton.focusedSliderBorderColor");
        this.borderColor = UIManager.getColor("ToggleButton.sliderBorderColor");
        this.inactiveBorderColor = UIManager.getColor("ToggleButton.disabledSliderBorderColor");
        this.sliderColor = UIManager.getColor("ToggleButton.sliderKnobFillColor");
        this.inactiveSliderColor = UIManager.getColor("ToggleButton.disabledSliderKnobFillColor");
        this.sliderBorderColor = UIManager.getColor("ToggleButton.sliderKnobBorderColor");
        this.inactiveSliderBorderColor = UIManager.getColor("ToggleButton.disabledSliderKnobBorderColor");
        this.selectedForeground = UIManager.getColor("ToggleButton.selectedForeground");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (DarkToggleButtonUI.isSlider(c)) {
            GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
            AbstractButton b = (AbstractButton)c;
            String text = this.layout(b, c, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
            this.paintSlider((Graphics2D)g, b);
            this.paintIcon(g, b, c);
            this.paintText(g, b, c, text);
            config.restore();
        } else {
            super.paint(g, c);
        }
    }

    @Override
    protected Color getForeground(AbstractButton button) {
        if (button.isSelected() && !DarkToggleButtonUI.isSlider(button) && button.getForeground() instanceof UIResource) {
            return this.selectedForeground;
        }
        return super.getForeground(button);
    }

    @Override
    protected Color getBackgroundColor(JComponent c) {
        boolean isSelected;
        AbstractButton b = (AbstractButton)c;
        boolean rollOver = (b.isRolloverEnabled() || DarkToggleButtonUI.doConvertToShadow(b)) && ((JButton)c).getModel().isRollover();
        boolean clicked = b.getModel().isArmed();
        boolean bl = isSelected = c instanceof JToggleButton && ((JToggleButton)c).isSelected();
        if (c.isEnabled()) {
            if (isSelected) {
                return this.background;
            }
            if (clicked) {
                return this.clickBackground;
            }
            if (rollOver) {
                return this.hoverBackground;
            }
            if (c instanceof JToggleButton) {
                return this.backgroundInactive;
            }
            return super.getBackgroundColor(c);
        }
        return this.inactiveBackground;
    }

    @Override
    protected String layout(AbstractButton b, JComponent c, FontMetrics fm, int width, int height) {
        if (DarkToggleButtonUI.isSlider(c)) {
            Insets i = b.getInsets();
            Rectangle bounds = this.getSliderBounds(c);
            DarkToggleButtonUI.viewRect.x = bounds.width + 2 * this.borderSize;
            DarkToggleButtonUI.viewRect.width = width - (i.right + DarkToggleButtonUI.viewRect.x);
            DarkToggleButtonUI.viewRect.y = i.top;
            DarkToggleButtonUI.viewRect.height = height - (i.bottom + DarkToggleButtonUI.viewRect.y);
            if (!b.getComponentOrientation().isLeftToRight()) {
                DarkToggleButtonUI.viewRect.x = bounds.x - DarkToggleButtonUI.viewRect.width - this.borderSize;
            }
            DarkToggleButtonUI.textRect.height = 0;
            DarkToggleButtonUI.textRect.width = 0;
            DarkToggleButtonUI.textRect.y = 0;
            DarkToggleButtonUI.textRect.x = 0;
            DarkToggleButtonUI.iconRect.height = 0;
            DarkToggleButtonUI.iconRect.width = 0;
            DarkToggleButtonUI.iconRect.y = 0;
            DarkToggleButtonUI.iconRect.x = 0;
            return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        }
        return super.layout(b, c, fm, width, height);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (!DarkToggleButtonUI.isSlider(c)) {
            return super.contains(c, x, y);
        }
        if (x < 0 || x > c.getWidth() || y < 0 || y > c.getHeight()) {
            return false;
        }
        Rectangle bounds = this.getSliderBounds(c);
        return new RoundRectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height, bounds.height, bounds.height).contains(x, y);
    }

    private static boolean isSlider(JComponent c) {
        return c instanceof JToggleButton && VARIANT_SLIDER.equals(c.getClientProperty(KEY_VARIANT));
    }

    private void paintSlider(Graphics2D g, AbstractButton c) {
        Rectangle bounds = this.getSliderBounds(c);
        g.translate(bounds.x, bounds.y);
        if (c.hasFocus()) {
            g.translate(-this.borderSize, -this.borderSize);
            DarkUIUtil.paintFocusBorder(g, bounds.width + 2 * this.borderSize, bounds.height + 2 * this.borderSize, bounds.height, this.borderSize);
            g.translate(this.borderSize, this.borderSize);
        }
        g.setColor(this.getBackgroundColor(c));
        DarkUIUtil.fillRoundRect(g, 0.0f, 0.0f, bounds.width, bounds.height, bounds.height);
        g.setColor(this.getToggleBorderColor(c));
        DarkUIUtil.paintLineBorder(g, 0.0f, 0.0f, bounds.width, bounds.height, bounds.height);
        int size = bounds.height - 2;
        GraphicsContext config = GraphicsUtil.setupStrokePainting(g);
        if (c.isSelected()) {
            g.setColor(this.getSliderColor(c));
            DarkUIUtil.fillRoundRect(g, bounds.width - size - 1, 1.0f, size, size, size);
            g.setColor(this.getSliderBorderColor(c));
            DarkUIUtil.paintLineBorder(g, bounds.width - size - 1, 1.0f, size, size, size);
        } else {
            g.setColor(this.getSliderColor(c));
            DarkUIUtil.fillRoundRect(g, 1.0f, 1.0f, size, size, size);
            g.setColor(this.getSliderBorderColor(c));
            DarkUIUtil.paintLineBorder(g, 1.0f, 1.0f, size, size, size);
        }
        g.translate(-bounds.x, -bounds.y);
        config.restore();
    }

    private Rectangle getSliderBounds(JComponent c) {
        int x = this.borderSize;
        int y = (c.getHeight() - this.sliderSize.height) / 2;
        DarkToggleButtonUI.rect.x = x;
        DarkToggleButtonUI.rect.y = y;
        DarkToggleButtonUI.rect.width = this.sliderSize.width;
        DarkToggleButtonUI.rect.height = this.sliderSize.height;
        if (!c.getComponentOrientation().isLeftToRight()) {
            DarkToggleButtonUI.rect.x = c.getWidth() - DarkToggleButtonUI.rect.x - DarkToggleButtonUI.rect.width;
        }
        return rect;
    }

    protected Color getToggleBorderColor(AbstractButton b) {
        if (b.hasFocus()) {
            return this.focusBorderColor;
        }
        return b.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    protected Color getSliderColor(AbstractButton b) {
        return b.isEnabled() ? this.sliderColor : this.inactiveSliderColor;
    }

    protected Color getSliderBorderColor(AbstractButton b) {
        return b.isEnabled() ? this.sliderBorderColor : this.inactiveSliderBorderColor;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.button.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        this.button.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (DarkToggleButtonUI.isSlider(c)) {
            d.width += this.sliderSize.width + this.borderSize;
        }
        return d;
    }
}

