/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.ui.button.AbstractButtonLayoutDelegate;
import com.github.weisj.darklaf.ui.button.DarkButtonBorder;
import com.github.weisj.darklaf.ui.button.DarkButtonListener;
import com.github.weisj.darklaf.util.AlignmentExt;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import com.github.weisj.darklaf.util.GraphicsUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarkButtonUI
extends BasicButtonUI
implements PropertyChangeListener,
FocusListener {
    protected static final String KEY_PREFIX = "JButton.";
    public static final String KEY_VARIANT = "JButton.variant";
    public static final String KEY_HOVER_COLOR = "JButton.shadow.hover";
    public static final String KEY_CLICK_COLOR = "JButton.shadow.click";
    public static final String KEY_ALT_ARC = "JButton.alternativeArc";
    public static final String KEY_NO_ARC = "JButton.noArc";
    public static final String KEY_SQUARE = "JButton.square";
    public static final String KEY_THIN = "JButton.thin";
    public static final String KEY_NO_SHADOW_OVERWRITE = "JButton.noShadowOverwrite";
    public static final String KEY_CORNER = "JButton.cornerFlag";
    public static final String KEY_LEFT_NEIGHBOUR = "JButton.leftNeighbour";
    public static final String KEY_RIGHT_NEIGHBOUR = "JButton.rightNeighbour";
    public static final String KEY_TOP_NEIGHBOUR = "JButton.topNeighbour";
    public static final String KEY_BOTTOM_NEIGHBOUR = "JButton.bottomNeighbour";
    public static final String VARIANT_ONLY_LABEL = "onlyLabel";
    public static final String VARIANT_FULL_SHADOW = "fullShadow";
    public static final String VARIANT_SHADOW = "shadow";
    public static final String VARIANT_NONE = "none";
    protected static final Rectangle viewRect = new Rectangle();
    protected static final Rectangle textRect = new Rectangle();
    protected static final Rectangle iconRect = new Rectangle();
    protected int borderSize;
    protected int shadowHeight;
    protected Color inactiveForeground;
    protected Color defaultForeground;
    protected Color defaultBackground;
    protected Color defaultHoverBackground;
    protected Color defaultClickBackground;
    protected Color background;
    protected Color hoverBackground;
    protected Color clickBackground;
    protected Color inactiveBackground;
    protected Color shadowHover;
    protected Color shadowClick;
    protected AbstractButton button;
    protected int arc;
    protected int squareArc;
    protected final AbstractButtonLayoutDelegate layoutDelegate = new AbstractButtonLayoutDelegate(){

        @Override
        public Font getFont() {
            return this.delegate != null ? this.delegate.getFont().deriveFont(1) : null;
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarkButtonUI();
    }

    public static JComponent getNeighbour(String key, Component comp) {
        if (!(comp instanceof JComponent)) {
            return null;
        }
        Object obj = ((JComponent)comp).getClientProperty(key);
        if (obj instanceof JComponent) {
            return (JComponent)obj;
        }
        return null;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener(this);
        b.addFocusListener(this);
    }

    public static boolean isShadowVariant(Component c) {
        if (DarkButtonUI.isFullShadow(c)) {
            return true;
        }
        if (c instanceof JButton) {
            JButton b = (JButton)c;
            return DarkButtonUI.doConvertToShadow((AbstractButton)c) || VARIANT_SHADOW.equals(b.getClientProperty(KEY_VARIANT));
        }
        return false;
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        GraphicsContext config = GraphicsUtil.setupAntialiasing(g);
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        g.setColor(this.getForeground(button));
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g);
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            mnemonicIndex = -1;
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        config.restore();
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(this);
        b.removeFocusListener(this);
    }

    public static boolean isFullShadow(Component c) {
        return c instanceof AbstractButton && VARIANT_FULL_SHADOW.equals(((AbstractButton)c).getClientProperty(KEY_VARIANT));
    }

    protected static boolean isIconOnly(AbstractButton b) {
        return b.getIcon() != null && (b.getText() == null || b.getText().isEmpty());
    }

    protected boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    protected Color getForeground(AbstractButton button) {
        Color fg = button.getForeground();
        if (fg instanceof UIResource && this.isDefaultButton(button) && !DarkButtonUI.isShadowVariant(button)) {
            fg = this.defaultForeground;
        }
        if (fg instanceof UIResource && !button.getModel().isEnabled()) {
            fg = this.inactiveForeground;
        }
        return fg;
    }

    public static boolean chooseAlternativeArc(Component c) {
        return c instanceof AbstractButton && Boolean.TRUE.equals(((AbstractButton)c).getClientProperty(KEY_ALT_ARC));
    }

    public static boolean isLabelButton(Component c) {
        return c instanceof AbstractButton && VARIANT_ONLY_LABEL.equals(((AbstractButton)c).getClientProperty(KEY_VARIANT));
    }

    public static boolean isNoArc(Component c) {
        return c instanceof AbstractButton && Boolean.TRUE.equals(((AbstractButton)c).getClientProperty(KEY_NO_ARC));
    }

    private boolean shouldDrawBackground(JComponent c) {
        if (DarkButtonUI.isLabelButton(c)) {
            return false;
        }
        AbstractButton button = (AbstractButton)c;
        Border border = c.getBorder();
        return c.isEnabled() && border != null && button.isContentAreaFilled();
    }

    public static boolean isSquare(Component c) {
        return c instanceof AbstractButton && Boolean.TRUE.equals(((AbstractButton)c).getClientProperty(KEY_SQUARE));
    }

    public static boolean isThin(Component c) {
        if (c instanceof AbstractButton) {
            boolean isThin = Boolean.TRUE.equals(((AbstractButton)c).getClientProperty(KEY_THIN));
            return isThin || DarkButtonUI.doConvertToShadow((AbstractButton)c);
        }
        return false;
    }

    protected int getArc(Component c) {
        if (DarkButtonUI.isNoArc(c)) {
            return 0;
        }
        boolean square = DarkButtonUI.isSquare(c);
        boolean alt = DarkButtonUI.chooseAlternativeArc(c);
        return square ? (alt ? this.arc : this.squareArc) : (alt ? this.squareArc : this.arc);
    }

    protected String layout(AbstractButton b, JComponent c, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        if (!DarkButtonUI.isShadowVariant(b)) {
            i = new Insets(i.top, this.borderSize, i.bottom, this.borderSize);
        }
        AlignmentExt corner = DarkButtonBorder.getCornerFlag(c);
        Insets insetMask = new Insets(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
        if (corner != null) {
            insetMask = corner.maskInsetsInverted(insetMask, 0);
        }
        i.left -= insetMask.left;
        i.right -= insetMask.right;
        i.top -= insetMask.top;
        i.bottom -= insetMask.bottom;
        DarkButtonUI.viewRect.x = i.left;
        DarkButtonUI.viewRect.y = i.top;
        DarkButtonUI.viewRect.width = width - (i.right + i.left);
        DarkButtonUI.viewRect.height = height - (i.bottom + i.top);
        DarkButtonUI.textRect.height = 0;
        DarkButtonUI.textRect.width = 0;
        DarkButtonUI.textRect.y = 0;
        DarkButtonUI.textRect.x = 0;
        DarkButtonUI.iconRect.height = 0;
        DarkButtonUI.iconRect.width = 0;
        DarkButtonUI.iconRect.y = 0;
        DarkButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null || DarkButtonUI.isIconOnly(b) ? 0 : b.getIconTextGap());
    }

    protected void paintText(Graphics g, AbstractButton b, JComponent c, String text) {
        GraphicsContext context = GraphicsUtil.setupAntialiasing(g);
        g.setClip(textRect);
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        context.restore();
    }

    protected void paintIcon(Graphics g, AbstractButton b, JComponent c) {
        if (b.getIcon() != null) {
            g.setClip(iconRect);
            this.paintIcon(g, c, iconRect);
        }
    }

    protected static boolean doConvertToShadow(AbstractButton b) {
        return DarkButtonUI.isIconOnly(b) && !b.isFocusable() && DarkButtonUI.convertIconButtonToShadow(b) && b instanceof JButton;
    }

    protected Color getBackgroundColor(JComponent c) {
        boolean defaultButton = this.isDefaultButton(c);
        AbstractButton b = (AbstractButton)c;
        boolean rollOver = (b.isRolloverEnabled() || DarkButtonUI.doConvertToShadow(b)) && ((JButton)c).getModel().isRollover();
        boolean clicked = b.getModel().isArmed();
        if (c.isEnabled()) {
            if (defaultButton) {
                if (clicked) {
                    return this.defaultClickBackground;
                }
                if (rollOver) {
                    return this.defaultHoverBackground;
                }
                return this.defaultBackground;
            }
            if (clicked) {
                return this.clickBackground;
            }
            if (rollOver) {
                return this.hoverBackground;
            }
            return this.background;
        }
        return this.inactiveBackground;
    }

    protected static boolean convertIconButtonToShadow(AbstractButton b) {
        return !(b instanceof UIResource) && UIManager.getBoolean("Button.convertIconOnlyToShadow") && !Boolean.TRUE.equals(b.getClientProperty(KEY_NO_SHADOW_OVERWRITE));
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "opaque", false);
        this.borderSize = UIManager.getInt("Button.borderThickness");
        this.shadowHeight = UIManager.getInt("Button.shadowHeight");
        this.inactiveForeground = UIManager.getColor("Button.disabledText");
        this.defaultForeground = UIManager.getColor("Button.selectedButtonForeground");
        this.defaultBackground = UIManager.getColor("Button.defaultFillColor");
        this.defaultHoverBackground = UIManager.getColor("Button.defaultFillColorRollOver");
        this.defaultClickBackground = UIManager.getColor("Button.defaultFillColorClick");
        this.background = UIManager.getColor("Button.activeFillColor");
        this.hoverBackground = UIManager.getColor("Button.activeFillColorRollOver");
        this.clickBackground = UIManager.getColor("Button.activeFillColorClick");
        this.inactiveBackground = UIManager.getColor("Button.inactiveFillColor");
        this.shadowHover = UIManager.getColor("Button.shadow.hover");
        this.shadowClick = UIManager.getColor("Button.shadow.click");
        this.arc = UIManager.getInt("Button.arc");
        this.squareArc = UIManager.getInt("Button.squareArc");
    }

    protected Color getShadowColor(AbstractButton c) {
        Object colorHover = c.getClientProperty(KEY_HOVER_COLOR);
        Object colorClick = c.getClientProperty(KEY_CLICK_COLOR);
        return c.getModel().isArmed() ? (colorClick instanceof Color ? (Color)colorClick : this.shadowClick) : (colorHover instanceof Color ? (Color)colorHover : this.shadowHover);
    }

    @Override
    public void installUI(JComponent c) {
        this.button = (AbstractButton)c;
        super.installUI(c);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new DarkButtonListener(b);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        this.layoutDelegate.setDelegate(b);
        return BasicGraphicsUtils.getPreferredButtonSize(this.layoutDelegate, b.getIconTextGap());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsContext config = new GraphicsContext(g);
        AbstractButton b = (AbstractButton)c;
        this.paintButtonBackground(g, c);
        if (this.isDefaultButton(b)) {
            g.setFont(g.getFont().deriveFont(1));
        } else if (g.getFont().isBold()) {
            g.setFont(g.getFont().deriveFont(0));
        }
        String text = this.layout(b, c, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
        this.paintIcon(g, b, c);
        this.paintText(g, b, c, text);
        config.restore();
    }

    protected void paintButtonBackground(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.shouldDrawBackground(c)) {
            AbstractButton b = (AbstractButton)c;
            int arc = this.getArc(c);
            int width = c.getWidth();
            int height = c.getHeight();
            Insets margin = b.getMargin();
            if (margin instanceof UIResource) {
                margin = new Insets(0, 0, 0, 0);
            }
            if (DarkButtonUI.isShadowVariant(c)) {
                this.paintShadowBackground(g, c, g2, b, arc, width, height, margin);
            } else {
                this.paintDefaultBackground((Graphics2D)g, b, g2, arc, width, height);
            }
        }
    }

    protected void paintDefaultBackground(Graphics2D g, AbstractButton c, Graphics2D g2, int arc, int width, int height) {
        int shadow = DarkButtonBorder.showDropShadow(c) ? this.shadowHeight : 0;
        int effectiveArc = DarkButtonUI.isSquare(c) && !DarkButtonUI.chooseAlternativeArc(c) ? 0 : arc;
        AlignmentExt corner = DarkButtonBorder.getCornerFlag(c);
        boolean focus = c.hasFocus() && c.isFocusPainted();
        Rectangle bgRect = this.getEffectiveRect(width, height, c, -(effectiveArc + 1), corner, focus);
        g2.setColor(this.getBackgroundColor(c));
        this.paintBackgroundRect(g, g2, shadow, effectiveArc, bgRect);
    }

    private void paintBackgroundRect(Graphics2D g, Graphics2D g2, int shadow, int effectiveArc, Rectangle bgRect) {
        if (effectiveArc == 0) {
            g2.fillRect(bgRect.x, bgRect.y, bgRect.width, bgRect.height - shadow);
        } else {
            DarkUIUtil.fillRoundRect(g, bgRect.x, bgRect.y, bgRect.width, bgRect.height - shadow, effectiveArc);
        }
    }

    protected Rectangle getEffectiveRect(int width, int height, AbstractButton c, int adjustment, AlignmentExt corner, boolean focus) {
        Insets insetMask = new Insets(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
        if (corner != null) {
            insetMask = corner.maskInsets(insetMask, adjustment);
        }
        int bx = insetMask.left;
        int by = insetMask.top;
        int bw = width - insetMask.left - insetMask.right;
        int bh = height - insetMask.top - insetMask.bottom;
        return new Rectangle(bx, by, bw, bh);
    }

    protected void paintShadowBackground(Graphics g, JComponent c, Graphics2D g2, AbstractButton b, int arc, int width, int height, Insets margin) {
        if (b.isEnabled() && b.getModel().isRollover()) {
            GraphicsUtil.setupAAPainting(g2);
            g.setColor(this.getShadowColor(b));
            if (DarkButtonUI.isFullShadow(c)) {
                g.fillRect(margin.left, margin.top, width - margin.left - margin.right, height - margin.top - margin.bottom);
            } else if (DarkButtonUI.doConvertToShadow(b)) {
                int size = Math.min(width - margin.left - margin.right, height - margin.left - margin.right);
                g.fillRoundRect((width - size) / 2, (height - size) / 2, size, size, arc, arc);
            } else {
                g.fillRoundRect(margin.left, margin.top, width - margin.left - margin.right, height - margin.top - margin.bottom, arc, arc);
            }
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        boolean isDefaultButton;
        super.update(g, c);
        boolean bl = isDefaultButton = this.isDefaultButton(c) && !SystemInfo.isMac;
        if (isDefaultButton && !c.getFont().isBold()) {
            c.setFont(c.getFont().deriveFont(1));
        } else if (!isDefaultButton && c.getFont().isBold()) {
            c.setFont(c.getFont().deriveFont(0));
        }
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (DarkButtonUI.isLabelButton(c)) {
            return super.contains(c, x, y);
        }
        if (x < 0 || x > c.getWidth() || y < 0 || y > c.getHeight()) {
            return false;
        }
        int bs = this.borderSize;
        int arc = this.getArc(c);
        return new RoundRectangle2D.Float(bs, bs, c.getWidth() - 2 * bs, c.getWidth() - 2 * bs, arc, arc).contains(x, y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if (key.startsWith(KEY_PREFIX)) {
            this.button.revalidate();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaintNeighbours();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaintNeighbours();
    }

    protected void repaintNeighbours() {
        DarkUIUtil.repaint(DarkButtonUI.getNeighbour(KEY_LEFT_NEIGHBOUR, this.button));
        DarkUIUtil.repaint(DarkButtonUI.getNeighbour(KEY_TOP_NEIGHBOUR, this.button));
        DarkUIUtil.repaint(DarkButtonUI.getNeighbour(KEY_RIGHT_NEIGHBOUR, this.button));
        DarkUIUtil.repaint(DarkButtonUI.getNeighbour(KEY_BOTTOM_NEIGHBOUR, this.button));
    }
}

