/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.ui.button.DarkButtonUI;
import com.github.weisj.darklaf.util.AlignmentExt;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.GraphicsContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarkButtonBorder
implements Border,
UIResource {
    private Color shadowColor = UIManager.getColor("Button.shadow");
    private Color focusBorderColor = UIManager.getColor("Button.focusBorderColor");
    private Color defaultBorderColor = UIManager.getColor("Button.defaultBorderColor");
    private Color borderColor = UIManager.getColor("Button.activeBorderColor");
    private Color inactiveBorderColor = UIManager.getColor("Button.inactiveBorderColor");
    private int arc = UIManager.getInt("Button.arc");
    private int focusArc = UIManager.getInt("Button.focusArc");
    private int squareFocusArc = UIManager.getInt("Button.squareFocusArc");
    private int squareArc = UIManager.getInt("Button.squareArc");
    private int minimumArc = UIManager.getInt("Button.minimumArc");
    private int borderSize = UIManager.getInt("Button.borderThickness");
    private int shadowSize = UIManager.getInt("Button.shadowHeight");
    private Insets insets = UIManager.getInsets("Button.borderInsets");
    private Insets thinInsets = UIManager.getInsets("Button.thinBorderInsets");
    private Insets squareInsets = UIManager.getInsets("Button.squareBorderInsets");
    private Insets squareThinInsets = UIManager.getInsets("Button.squareThinBorderInsets");
    private Insets labelInsets = UIManager.getInsets("Button.onlyLabelInsets");
    private Insets shadowInsets = UIManager.getInsets("Button.fullShadowInsets");

    public DarkButtonBorder() {
        if (this.insets == null) {
            this.insets = new Insets(0, 0, 0, 0);
        }
        if (this.thinInsets == null) {
            this.thinInsets = new Insets(0, 0, 0, 0);
        }
        if (this.squareThinInsets == null) {
            this.squareThinInsets = new Insets(0, 0, 0, 0);
        }
        if (this.squareInsets == null) {
            this.squareInsets = new Insets(0, 0, 0, 0);
        }
        if (this.shadowInsets == null) {
            this.shadowInsets = new Insets(0, 0, 0, 0);
        }
        if (this.labelInsets == null) {
            this.labelInsets = new Insets(0, 0, 0, 0);
        }
    }

    public static boolean showDropShadow(JComponent c) {
        return DarkButtonBorder.showDropShadow(DarkButtonBorder.getCornerFlag(c));
    }

    public static boolean showDropShadow(AlignmentExt a) {
        return a == null || a == AlignmentExt.SOUTH || a == AlignmentExt.SOUTH_EAST || a == AlignmentExt.SOUTH_WEST || a == AlignmentExt.LEFT || a == AlignmentExt.RIGHT || a == AlignmentExt.BOTTOM || a == AlignmentExt.MIDDLE_HORIZONTAL;
    }

    protected int getArc(Component c) {
        if (DarkButtonUI.isNoArc(c)) {
            return 0;
        }
        boolean square = DarkButtonUI.isSquare(c);
        boolean alt = DarkButtonUI.chooseAlternativeArc(c);
        return square ? (alt ? this.arc : this.squareArc) : (alt ? this.squareArc : this.arc);
    }

    protected int getFocusArc(Component c) {
        if (DarkButtonUI.isNoArc(c)) {
            return this.minimumArc;
        }
        boolean square = DarkButtonUI.isSquare(c);
        boolean alt = DarkButtonUI.chooseAlternativeArc(c);
        return square ? (alt ? this.focusArc : this.squareFocusArc) : (alt ? this.squareFocusArc : this.focusArc);
    }

    public static AlignmentExt getCornerFlag(Component component) {
        if (component instanceof JComponent) {
            Object align = ((JComponent)component).getClientProperty("JButton.cornerFlag");
            return align instanceof AlignmentExt ? (AlignmentExt)((Object)align) : null;
        }
        return null;
    }

    protected int getShadowSize(JComponent c) {
        return DarkButtonBorder.showDropShadow(c) ? this.getShadowSize() : 0;
    }

    protected int getShadowSize() {
        return this.shadowSize;
    }

    protected int getBorderSize() {
        return this.borderSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (DarkButtonUI.isShadowVariant(c) || DarkButtonUI.isLabelButton(c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(x, y);
        int arc = this.getArc(c);
        int focusArc = this.getFocusArc(c);
        GraphicsContext config = new GraphicsContext(g);
        AlignmentExt corner = DarkButtonBorder.getCornerFlag(c);
        boolean paintShadow = DarkButtonBorder.showDropShadow(corner);
        boolean focus = this.paintFocus(c);
        int shadowHeight = paintShadow ? this.getShadowSize() : 0;
        int borderSize = this.getBorderSize();
        Insets insetMask = new Insets(borderSize, borderSize, borderSize, borderSize);
        Insets focusIns = new Insets(0, 0, 0, 0);
        if (corner != null) {
            focusIns = corner.maskInsets(focusIns, -borderSize - focusArc);
            insetMask = corner.maskInsets(insetMask, -arc);
        }
        int bx = insetMask.left;
        int by = insetMask.top;
        int bw = width - insetMask.left - insetMask.right;
        int bh = height - insetMask.top - insetMask.bottom;
        int fx = focusIns.left;
        int fy = focusIns.top;
        int fw = width - focusIns.left - focusIns.right;
        int fh = height - focusIns.top - focusIns.bottom;
        if (c.isEnabled() && paintShadow) {
            this.paintShadow((Graphics2D)g, bx, by, bw, bh, arc);
        }
        if (this.paintFocus(c)) {
            g.translate(fx, fy);
            DarkUIUtil.paintFocusBorder(g2, fw, fh - shadowHeight, focusArc, borderSize);
            g.translate(-fx, -fy);
        }
        g2.setColor(this.getBorderColor(c, focus));
        DarkUIUtil.paintLineBorder(g2, bx, by, bw, bh - shadowHeight, arc);
        if (corner != null) {
            this.paintNeighbourFocus(g2, c, width, height);
        }
        config.restore();
    }

    protected void paintNeighbourFocus(Graphics2D g2, Component c, int width, int height) {
        JComponent bottom;
        boolean paintBottom;
        JComponent top;
        boolean paintTop;
        JComponent right;
        boolean paintRight;
        JComponent left = DarkButtonUI.getNeighbour("JButton.leftNeighbour", c);
        boolean paintLeft = DarkUIUtil.hasFocus(left);
        if (paintLeft) {
            g2.translate(-2 * this.borderSize, 0);
            DarkUIUtil.paintFocusBorder(g2, 3 * this.borderSize, height - this.getShadowSize(left), this.getFocusArc(left), this.borderSize);
            g2.translate(2 * this.borderSize, 0);
        }
        if (paintRight = DarkUIUtil.hasFocus(right = DarkButtonUI.getNeighbour("JButton.rightNeighbour", c))) {
            g2.translate(width - this.borderSize, 0);
            DarkUIUtil.paintFocusBorder(g2, 3 * this.borderSize, height - this.getShadowSize(right), this.getFocusArc(right), this.borderSize);
            g2.translate(this.borderSize - width, 0);
        }
        if (paintTop = DarkUIUtil.hasFocus(top = DarkButtonUI.getNeighbour("JButton.topNeighbour", c))) {
            g2.translate(0, -2 * this.borderSize);
            DarkUIUtil.paintFocusBorder(g2, width, 3 * this.borderSize, this.getFocusArc(top), this.borderSize);
            g2.translate(0, 2 * this.borderSize);
        }
        if (paintBottom = DarkUIUtil.hasFocus(bottom = DarkButtonUI.getNeighbour("JButton.topNeighbour", c))) {
            g2.translate(0, height - this.borderSize);
            DarkUIUtil.paintFocusBorder(g2, width, 3 * this.borderSize, this.getFocusArc(bottom), this.borderSize);
            g2.translate(0, this.borderSize - height);
        }
    }

    protected boolean paintFocus(Component c) {
        if (c instanceof AbstractButton) {
            return ((AbstractButton)c).isFocusPainted() && c.hasFocus();
        }
        return c.hasFocus();
    }

    private void paintShadow(Graphics2D g2, int x, int y, int width, int height, int arc) {
        GraphicsContext context = new GraphicsContext(g2);
        int shadowSize = this.getShadowSize();
        Area shadowShape = new Area(new RoundRectangle2D.Double(x, y, width, height, arc, arc));
        Area innerArea = new Area(new RoundRectangle2D.Double(x, y, width, height - shadowSize, arc, arc));
        shadowShape.subtract(innerArea);
        g2.setComposite(DarkUIUtil.SHADOW_COMPOSITE);
        g2.setColor(this.shadowColor);
        g2.fill(shadowShape);
        context.restore();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    protected Color getBorderColor(Component c, boolean focus) {
        if (focus) {
            return this.focusBorderColor;
        }
        if (c instanceof JButton && ((JButton)c).isDefaultButton() && c.isEnabled()) {
            return this.defaultBorderColor;
        }
        if (c.isEnabled()) {
            return this.borderColor;
        }
        return this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarkButtonUI.isFullShadow(c)) {
            return new InsetsUIResource(this.shadowInsets.top, this.shadowInsets.left, this.shadowInsets.bottom, this.shadowInsets.right);
        }
        if (DarkButtonUI.isLabelButton(c)) {
            return new InsetsUIResource(this.labelInsets.top, this.labelInsets.left, this.labelInsets.bottom, this.labelInsets.right);
        }
        boolean shadowVariant = DarkButtonUI.isShadowVariant(c);
        int shadow = shadowVariant ? 0 : this.getShadowSize();
        boolean square = DarkButtonUI.isSquare(c);
        Insets pad = DarkButtonUI.isThin(c) ? (square ? this.squareThinInsets : this.thinInsets) : (square ? this.squareInsets : this.insets);
        return this.maskInsets(new InsetsUIResource(pad.top, pad.left, pad.bottom, pad.right), c, shadow);
    }

    protected Insets maskInsets(Insets ins, Component c, int shadow) {
        ins.bottom += shadow;
        AlignmentExt alignment = DarkButtonBorder.getCornerFlag(c);
        if (alignment == null) {
            return ins;
        }
        Insets insetMask = new Insets(this.borderSize, this.borderSize, this.borderSize + shadow, this.borderSize);
        insetMask = alignment.maskInsetsInverted(insetMask);
        ins.top -= insetMask.top;
        ins.bottom -= insetMask.bottom;
        ins.left -= insetMask.left;
        ins.right -= insetMask.right;
        return ins;
    }
}

