/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.decorations.CustomTitlePane;
import com.github.weisj.darklaf.decorations.DecorationsProvider;
import com.github.weisj.darklaf.platform.DefaultDecorationsProvider;
import com.github.weisj.darklaf.platform.macos.MacOSDecorationsProvider;
import com.github.weisj.darklaf.platform.windows.WindowsDecorationsProvider;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Window;
import java.util.Properties;
import javax.swing.JRootPane;
import javax.swing.UIDefaults;

public final class Decorations {
    private static DecorationsProvider decorationsProvider;

    public static CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        return decorationsProvider.createTitlePane(rootPane, decorationStyle, window);
    }

    public static void installPopupWindow(Window window) {
        decorationsProvider.installPopupMenu(window);
    }

    public static void uninstallPopupWindow(Window window) {
        decorationsProvider.uninstallPopupWindow(window);
    }

    public static boolean isCustomDecorationSupported() {
        return decorationsProvider.isCustomDecorationSupported() && LafManager.isDecorationsEnabled() && LafManager.getTheme().useCustomDecorations();
    }

    public static void initialize() {
        decorationsProvider.initialize();
    }

    public static void loadDecorationProperties(Properties uiProps, UIDefaults defaults) {
        decorationsProvider.loadDecorationProperties(uiProps, defaults);
    }

    static {
        try {
            boolean enableDecorations;
            boolean bl = enableDecorations = !"false".equals(System.getProperty("darklaf.decorations"));
            decorationsProvider = SystemInfo.isWindows10 && enableDecorations ? new WindowsDecorationsProvider() : (SystemInfo.isMacOSYosemite && enableDecorations ? new MacOSDecorationsProvider() : new DefaultDecorationsProvider());
        }
        catch (Throwable e) {
            decorationsProvider = new DefaultDecorationsProvider();
        }
    }
}

