/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.Icon;

public class DarkSVGIcon
implements Icon,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(DarkSVGIcon.class.getName());
    private final Dimension size;
    private final SVGIcon icon;
    private final URI uri;
    private final AtomicBoolean loaded;

    public DarkSVGIcon(URI uri, int displayWidth, int displayHeight) {
        this.uri = uri;
        this.size = new Dimension(displayWidth, displayHeight);
        this.icon = new SVGIcon();
        this.icon.setAutosize(4);
        this.icon.setAntiAlias(true);
        this.loaded = new AtomicBoolean(false);
    }

    private DarkSVGIcon(int width, int height, DarkSVGIcon icon) {
        this.size = new Dimension(width, height);
        this.icon = icon.icon;
        this.uri = icon.uri;
        this.loaded = icon.loaded;
    }

    public DarkSVGIcon derive(int width, int height) {
        return new DarkSVGIcon(width, height, this);
    }

    public void setDisplaySize(int width, int height) {
        this.size.setSize(width, height);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.ensureLoaded();
        this.paintIcon(c, g, x, y, 0.0);
    }

    private void ensureLoaded() {
        if (!this.loaded.get()) {
            LOGGER.fine(() -> "Loading icon '" + this.uri.toASCIIString() + "'.");
            this.icon.setSvgURI(this.uri);
            this.loaded.set(true);
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y, double rotation) {
        this.ensureLoaded();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x, y);
        if (rotation != 0.0) {
            g2.rotate(rotation, (double)this.size.width / 2.0, (double)this.size.height / 2.0);
        }
        this.icon.setPreferredSize(this.size);
        this.icon.paintIcon(c, (Graphics)g2, 0, 0);
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.size.width;
    }

    @Override
    public int getIconHeight() {
        return this.size.height;
    }

    public SVGIcon getSVGIcon() {
        this.ensureLoaded();
        return this.icon;
    }
}

