/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tristate;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.components.tristate.TristateButtonModel;
import com.github.weisj.darklaf.components.tristate.TristateState;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.UIManager;

public class TristateCheckBoxMenuItem
extends JCheckBoxMenuItem {
    public TristateCheckBoxMenuItem() {
        this(null, null, TristateState.DESELECTED);
    }

    public TristateCheckBoxMenuItem(Icon icon) {
        this(null, icon, TristateState.DESELECTED);
    }

    public TristateCheckBoxMenuItem(String text) {
        this(text, null, TristateState.DESELECTED);
    }

    public TristateCheckBoxMenuItem(Action a) {
        this();
        this.setAction(a);
    }

    public TristateCheckBoxMenuItem(String text, Icon icon) {
        this(text, icon, TristateState.DESELECTED);
    }

    public TristateCheckBoxMenuItem(String text, TristateState state) {
        this(text, null, state);
    }

    public TristateCheckBoxMenuItem(String text, Icon icon, TristateState state) {
        super(text, icon);
        this.setModel(new TristateButtonModel(state));
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TristateCheckBoxMenuItem.this.iterateState();
            }
        });
        this.setFocusable(false);
    }

    @Override
    public String getUIClassID() {
        if (UIManager.getLookAndFeel() instanceof DarkLaf) {
            return "TristateCheckBoxMenuItemUI";
        }
        return super.getUIClassID();
    }

    private void iterateState() {
        if (!this.getModel().isEnabled()) {
            return;
        }
        this.grabFocus();
        this.getTristateModel().iterateState();
        this.repaint();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiersEx();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getText(), System.currentTimeMillis(), modifiers));
    }

    public TristateButtonModel getTristateModel() {
        return (TristateButtonModel)super.getModel();
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? TristateState.SELECTED : TristateState.DESELECTED);
    }

    public void setIndeterminate() {
        this.getTristateModel().setIndeterminate();
    }

    public boolean isIndeterminate() {
        return this.getTristateModel().isIndeterminate();
    }

    @Override
    public boolean getState() {
        return this.getTristateModel().getState() == TristateState.SELECTED;
    }

    public void setState(TristateState state) {
        this.getTristateModel().setState(state);
    }

    public TristateState getTristateState() {
        return this.getTristateModel().getState();
    }
}

