/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tabframe;

import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.TabFrameTab;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.tabframe.DarkTabFrameTabLabelUI;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;

public class TabFrameTabLabel
extends JLabel
implements TabFrameTab {
    private JTabFrame parent;
    private Alignment orientation;
    private String title;
    private boolean selected;
    private int accelerator;
    private int index;

    public TabFrameTabLabel(String title, Icon icon, Alignment orientation, int index, JTabFrame parent) {
        this.index = index;
        this.accelerator = -1;
        this.parent = parent;
        this.setOrientation(orientation);
        this.setIcon(icon == null ? EmptyIcon.create(0) : icon);
        this.setTitle(title);
        this.setText(title);
    }

    @Override
    public String getUIClassID() {
        return "TabFrameTabLabelUI";
    }

    public void setUI(DarkTabFrameTabLabelUI ui) {
        super.setUI(ui);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Alignment getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Alignment a) {
        if (this.orientation == a) {
            return;
        }
        Alignment oldOrientation = this.orientation;
        this.orientation = a;
        this.firePropertyChange("orientation", (Object)oldOrientation, (Object)this.orientation);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.firePropertyChange("selected", oldSelected, selected);
    }

    @Override
    public int getAccelerator() {
        return this.accelerator;
    }

    @Override
    public void setAccelerator(int accelerator) {
        if (this.accelerator == accelerator) {
            return;
        }
        int oldAccelerator = this.accelerator;
        this.accelerator = accelerator;
        this.firePropertyChange("accelerator", oldAccelerator, accelerator);
    }

    @Override
    public JTabFrame getTabFrame() {
        return this.parent;
    }

    @Override
    public void setTabFrame(JTabFrame parent) {
        JTabFrame old = this.parent;
        this.parent = parent;
        this.firePropertyChange("tabFrame", old, parent);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (Objects.equals(title, this.title)) {
            return;
        }
        String oldTitle = this.title;
        this.title = title;
        this.firePropertyChange("title", oldTitle, (Object)this.selected);
    }
}

