/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;

public class ScrollPopupMenu
extends JPopupMenu {
    private final JPanel contentPane;
    private final JScrollPane scrollPane;
    private int maxHeight;
    private JWindow popWin;
    private int posX;
    private int posY;
    private JPanel view;

    public ScrollPopupMenu(int maxHeight) {
        this.maxHeight = maxHeight;
        this.contentPane = new JPanel(new BorderLayout());
        OverlayScrollPane overlayScrollPane = this.createScrollPane();
        this.scrollPane = overlayScrollPane.getScrollPane();
        this.contentPane.add((Component)overlayScrollPane, "Center");
        this.contentPane.setBorder(this.getBorder());
        this.setDoubleBuffered(true);
        MenuKeyListener menuKeyListener = new MenuKeyListener(){

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
                SwingUtilities.invokeLater(() -> {
                    MenuElement[] path = e.getMenuSelectionManager().getSelectedPath();
                    if (path.length == 0) {
                        return;
                    }
                    Rectangle bounds = path[path.length - 1].getComponent().getBounds();
                    Rectangle r = SwingUtilities.convertRectangle(ScrollPopupMenu.this, bounds, ScrollPopupMenu.this.scrollPane);
                    ScrollPopupMenu.this.scrollPane.getViewport().scrollRectToVisible(r);
                });
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
            }
        };
        this.addMenuKeyListener(menuKeyListener);
    }

    private OverlayScrollPane createScrollPane() {
        this.view = new JPanel(new BorderLayout());
        this.view.add((Component)this, "Center");
        OverlayScrollPane overlayScrollPane = new OverlayScrollPane(this.view, 20, 31);
        JScrollBar bar = overlayScrollPane.getVerticalScrollBar();
        bar.putClientProperty("JScrollBar.thin", Boolean.TRUE);
        DarkUIUtil.doNotCancelPopupSetup(bar);
        DarkUIUtil.doNotCancelPopupSetup(overlayScrollPane.getScrollPane());
        return overlayScrollPane;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        menuItem.getModel().addChangeListener(e -> this.contentPane.repaint(menuItem.getBounds()));
        return super.add(menuItem);
    }

    protected void showPopup() {
        Component comp = this.getInvoker();
        if (comp == null) {
            return;
        }
        while (comp.getParent() != null) {
            comp = comp.getParent();
        }
        if (this.popWin == null || this.popWin.getOwner() != comp) {
            this.popWin = comp instanceof Window ? new JWindow((Window)comp) : new JWindow(new JFrame());
        }
        this.pack();
        this.popWin.setLocation(this.posX, this.posY);
        this.popWin.setVisible(true);
        this.requestFocus();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public boolean isVisible() {
        return this.popWin != null && this.popWin.isShowing();
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.popWin != null && this.popWin.isShowing()) {
            this.popWin.setLocation(x, y);
        } else {
            this.posX = x;
            this.posY = y;
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b == this.isVisible()) {
            return;
        }
        if (b) {
            if (this.isPopupMenu()) {
                MenuElement[] menuElements = new MenuElement[1];
                if (this.getSubElements().length > 0) {
                    menuElements = new MenuElement[2];
                    menuElements[1] = this.getSubElements()[0];
                }
                menuElements[0] = this;
                MenuSelectionManager.defaultManager().setSelectedPath(menuElements);
            }
            this.firePopupMenuWillBecomeVisible();
            this.showPopup();
            this.firePropertyChange("visible", Boolean.FALSE, Boolean.TRUE);
        } else {
            this.hidePopup();
        }
    }

    protected void hidePopup() {
        if (this.popWin != null) {
            this.firePopupMenuWillBecomeInvisible();
            this.popWin.setVisible(false);
            this.popWin = null;
            this.firePropertyChange("visible", Boolean.TRUE, Boolean.FALSE);
            if (this.isPopupMenu()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    @Override
    public void pack() {
        if (this.popWin == null) {
            return;
        }
        Dimension prefSize = this.getPreferredSize();
        if (this.maxHeight <= 0 || prefSize.height <= this.maxHeight) {
            this.setBounds(0, 0, prefSize.width, prefSize.height);
            this.popWin.setContentPane(this);
            this.setBorderPainted(true);
            this.popWin.setSize(prefSize.width, prefSize.height);
        } else {
            int increment = this.getComponentCount() > 0 ? Math.max(1, this.getComponent((int)0).getPreferredSize().height / 2) : 1;
            JScrollBar bar = this.scrollPane.getVerticalScrollBar();
            bar.setValue(bar.getMinimum());
            bar.setUnitIncrement(increment);
            this.setBorderPainted(false);
            this.view.add(this);
            this.popWin.setContentPane(this.contentPane);
            this.popWin.pack();
            this.popWin.setSize(prefSize.width + bar.getPreferredSize().width, this.maxHeight);
        }
    }

    private boolean isPopupMenu() {
        Component invoker = this.getInvoker();
        return invoker != null && !(invoker instanceof JMenu);
    }
}

