/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.ui.scrollpane.ScrollLayoutManagerDelegate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollPaneUI;

public class OverlayScrollPane
extends JLayeredPane {
    protected final OScrollPane scrollPane;
    private final ControlPanel controlPanel;

    public OverlayScrollPane() {
        this(null);
    }

    public OverlayScrollPane(JComponent view) {
        this(view, 20, 30);
    }

    public OverlayScrollPane(JComponent view, int vsbPolicy, int hsbPolicy) {
        this.scrollPane = this.createScrollPane(view, vsbPolicy, hsbPolicy);
        this.add((Component)this.scrollPane, JLayeredPane.DEFAULT_LAYER);
        this.controlPanel = new ControlPanel(this.scrollPane);
        this.add((Component)this.controlPanel, JLayeredPane.PALETTE_LAYER);
    }

    protected OScrollPane createScrollPane(JComponent view, int vsbPolicy, int hsbPolicy) {
        return new OScrollPane(view, vsbPolicy, hsbPolicy);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void doLayout() {
        this.scrollPane.setSize(this.getSize());
        this.controlPanel.setSize(this.getSize());
        this.scrollPane.doLayout();
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.scrollPane.setVerticalScrollBarPolicy(policy);
        this.controlPanel.showVerticalScrollBar(policy != 21);
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.scrollPane.setHorizontalScrollBarPolicy(policy);
        this.controlPanel.showHorizontalScrollBar(policy != 31);
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane.verticalScrollBar;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.scrollPane.getPreferredSize();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.scrollPane.horizontalScrollBar;
    }

    public void setViewportView(Component c) {
        this.scrollPane.setViewportView(c);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.scrollPane.setPreferredSize(preferredSize);
    }

    protected static class OScrollPane
    extends JScrollPane {
        private JScrollBar verticalScrollBar;
        private JScrollBar horizontalScrollBar;

        protected OScrollPane(JComponent view, int vsbPolicy, int hsbPolicy) {
            super(view, vsbPolicy, hsbPolicy);
            super.setLayout(new ScrollLayoutManagerDelegate((ScrollPaneLayout)this.getLayout()){

                @Override
                public void removeLayoutComponent(Component comp) {
                    if (comp == verticalScrollBar || comp == horizontalScrollBar) {
                        return;
                    }
                    super.removeLayoutComponent(comp);
                }

                @Override
                public void layoutContainer(Container parent) {
                    super.layoutContainer(parent);
                    this.viewport = this.getViewport();
                    if (this.viewport != null) {
                        Rectangle bounds = this.viewport.getBounds();
                        Rectangle vertBounds = verticalScrollBar.getBounds();
                        Rectangle horBounds = horizontalScrollBar.getBounds();
                        JViewport columnHeader = this.getColumnHeader();
                        JViewport rowHeader = this.getRowHeader();
                        if (this.getComponentOrientation().isLeftToRight()) {
                            if (verticalScrollBar.isVisible()) {
                                bounds.width += vertBounds.width;
                            }
                            if (columnHeader != null && verticalScrollBar.isVisible()) {
                                Rectangle chb = columnHeader.getBounds();
                                chb.width += vertBounds.width;
                                columnHeader.setBounds(chb);
                            }
                            if (rowHeader != null && horizontalScrollBar.isVisible()) {
                                Rectangle rhb = rowHeader.getBounds();
                                rhb.height += horBounds.height;
                                rowHeader.setBounds(rhb);
                            }
                        } else {
                            if (verticalScrollBar.isVisible()) {
                                bounds.x -= vertBounds.width;
                                bounds.width += vertBounds.width;
                            }
                            if (columnHeader != null && verticalScrollBar.isVisible()) {
                                Rectangle chb = columnHeader.getBounds();
                                chb.x -= vertBounds.width;
                                chb.width += vertBounds.width;
                                columnHeader.setBounds(chb);
                            }
                            if (rowHeader != null && horizontalScrollBar.isVisible()) {
                                Rectangle rhb = rowHeader.getBounds();
                                rhb.height += horBounds.height;
                                rowHeader.setBounds(rhb);
                            }
                        }
                        if (horizontalScrollBar.isVisible()) {
                            bounds.height += horBounds.height;
                        }
                        this.viewport.setBounds(bounds);
                    }
                }
            });
        }

        @Override
        public void setUI(ScrollPaneUI ui) {
            if (this.verticalScrollBar == null) {
                this.verticalScrollBar = new PopupScrollBar(1);
                this.verticalScrollBar.putClientProperty("JScrollBar.scrollPaneParent", this);
            }
            if (this.horizontalScrollBar == null) {
                this.horizontalScrollBar = new PopupScrollBar(0);
                this.horizontalScrollBar.putClientProperty("JScrollBar.scrollPaneParent", this);
            }
            super.setUI(ui);
            SwingUtilities.invokeLater(() -> {
                Component component = this.getViewport().getView();
                if (component != null) {
                    this.getViewport().setBackground(component.getBackground());
                }
            });
        }

        @Override
        public JScrollBar getHorizontalScrollBar() {
            return this.horizontalScrollBar;
        }

        @Override
        public JScrollBar getVerticalScrollBar() {
            return this.verticalScrollBar;
        }
    }

    private final class ControlPanel
    extends JPanel {
        private boolean showVertical;
        private boolean showHorizontal;

        private ControlPanel(OScrollPane scrollPane) {
            this.setLayout(null);
            scrollPane.setVerticalScrollBar(scrollPane.verticalScrollBar);
            if (scrollPane.getVerticalScrollBarPolicy() != 21) {
                this.showVertical = true;
                this.add(scrollPane.verticalScrollBar);
            }
            scrollPane.setHorizontalScrollBar(scrollPane.horizontalScrollBar);
            if (scrollPane.getHorizontalScrollBarPolicy() != 31) {
                this.showHorizontal = true;
                this.add(scrollPane.horizontalScrollBar);
            }
        }

        private void showVerticalScrollBar(boolean show) {
            if (show == this.showVertical) {
                return;
            }
            this.showVertical = show;
            OverlayScrollPane.this.scrollPane.verticalScrollBar.setVisible(show);
        }

        private void showHorizontalScrollBar(boolean show) {
            if (show == this.showHorizontal) {
                return;
            }
            this.showHorizontal = show;
            OverlayScrollPane.this.scrollPane.horizontalScrollBar.setVisible(show);
        }

        @Override
        public boolean contains(int x, int y) {
            if (OverlayScrollPane.this.scrollPane.horizontalScrollBar.isVisible() && OverlayScrollPane.this.scrollPane.horizontalScrollBar.getBounds().contains(x, y)) {
                return true;
            }
            return OverlayScrollPane.this.scrollPane.verticalScrollBar.isVisible() && OverlayScrollPane.this.scrollPane.verticalScrollBar.getBounds().contains(x, y);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }

    private static final class PopupScrollBar
    extends JScrollBar {
        private PopupScrollBar(int direction) {
            super(direction);
            this.putClientProperty("JScrollBar.fastWheelScrolling", true);
            this.setOpaque(false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }
}

