/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.ui.colorchooser.ColorPipette;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicRootPaneUI;

public abstract class ColorPipetteBase
implements ColorPipette,
AWTEventListener {
    protected final JComponent parent;
    protected final Robot robot;
    private final ColorListener colorListener;
    private Runnable closeAction;
    private JWindow pickerWindow;
    private boolean keyDown;
    private int downKeyCode;
    private Color currentColor;
    private Color initialColor;

    public ColorPipetteBase(JComponent parent, ColorListener colorListener) {
        this.parent = parent;
        this.colorListener = colorListener;
        this.robot = ColorPipetteBase.createRobot();
    }

    private static Robot createRobot() {
        try {
            return new Robot();
        }
        catch (AWTException e) {
            return null;
        }
    }

    public boolean isKeyDown() {
        return this.keyDown;
    }

    public int getPressedKeyCode() {
        return this.downKeyCode;
    }

    public void setCloseAction(Runnable closeAction) {
        this.closeAction = closeAction;
    }

    protected Color getPixelColor(Point location) {
        return this.robot.getPixelColor(location.x, location.y);
    }

    protected Color getInitialColor() {
        return this.initialColor;
    }

    @Override
    public void setInitialColor(Color initialColor) {
        this.initialColor = initialColor;
        this.setColor(initialColor);
    }

    @Override
    public Color getColor() {
        return this.currentColor;
    }

    protected void setColor(Color color) {
        this.currentColor = color;
    }

    @Override
    public Window show() {
        Window picker = this.getOrCreatePickerWindow();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        this.updateLocation();
        picker.setVisible(true);
        return picker;
    }

    @Override
    public void pickAndClose() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Color pixelColor = this.getPixelColor(pointerInfo.getLocation());
        this.cancelPipette();
        this.notifyListener(pixelColor);
        this.setInitialColor(pixelColor);
    }

    @Override
    public void cancelPipette() {
        Color initialColor;
        Window pickerWindow = this.getPickerWindow();
        if (pickerWindow != null) {
            pickerWindow.setVisible(false);
        }
        if ((initialColor = this.getInitialColor()) != null) {
            this.notifyListener(initialColor);
        }
        if (this.closeAction != null) {
            this.closeAction.run();
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    protected Window getOrCreatePickerWindow() {
        if (this.pickerWindow == null) {
            Window owner = SwingUtilities.getWindowAncestor(this.parent);
            this.pickerWindow = this.createPickerWindow(owner);
            this.pickerWindow.setName("DarkLafPickerDialog");
            JRootPane rootPane = this.pickerWindow.getRootPane();
            rootPane.putClientProperty("Window.shadow", Boolean.FALSE);
        }
        return this.pickerWindow;
    }

    protected Point updateLocation() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return null;
        }
        Point mouseLocation = pointerInfo.getLocation();
        Window pickerWindow = this.getPickerWindow();
        if (pickerWindow != null && mouseLocation != null) {
            pickerWindow.setLocation(this.adjustPickerLocation(mouseLocation, pickerWindow));
        }
        return mouseLocation;
    }

    protected JWindow createPickerWindow(Window parent) {
        return new PickerWindow(parent);
    }

    protected Window getPickerWindow() {
        return this.pickerWindow;
    }

    protected Point adjustPickerLocation(Point mouseLocation, Window pickerWindow) {
        return new Point(mouseLocation.x - pickerWindow.getWidth() / 2, mouseLocation.y - pickerWindow.getHeight() / 2);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (this.pickerWindow == null || !this.pickerWindow.isVisible()) {
            return;
        }
        switch (event.getID()) {
            case 501: {
                ((MouseEvent)event).consume();
                this.pickAndClose();
                break;
            }
            case 500: {
                ((MouseEvent)event).consume();
                break;
            }
            case 401: {
                this.downKeyCode = ((KeyEvent)event).getKeyCode();
                switch (this.downKeyCode) {
                    case 27: {
                        this.cancelPipette();
                        break;
                    }
                    case 10: {
                        this.pickAndClose();
                        break;
                    }
                }
                if (this.keyDown) break;
                this.keyDown = true;
                this.updatePipette(true);
                break;
            }
            case 402: {
                this.keyDown = false;
                Window picker = this.getPickerWindow();
                if (picker == null) break;
                picker.repaint();
                break;
            }
        }
    }

    protected abstract void updatePipette(boolean var1);

    protected void notifyListener(Color c) {
        this.colorListener.colorChanged(c, this);
    }

    @Override
    public boolean imageUpdate(Image image, int i, int i1, int i2, int i3, int i4) {
        return false;
    }

    @Override
    public void dispose() {
        this.pickerWindow.dispose();
        this.pickerWindow = null;
        this.setInitialColor(null);
        this.setColor(null);
    }

    protected static class PickerWindow
    extends JWindow {
        protected PickerWindow(Window parent) {
            super(parent);
            this.setBackground(DarkUIUtil.TRANSPARENT_COLOR);
            BufferedImage cursorImg = new BufferedImage(16, 16, 2);
            Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(), "BlankCursor");
            this.setCursor(blankCursor);
        }

        @Override
        protected JRootPane createRootPane() {
            return new JRootPane(){

                @Override
                public int getWindowDecorationStyle() {
                    return 0;
                }

                @Override
                public void updateUI() {
                    this.setUI(new BasicRootPaneUI());
                }
            };
        }
    }
}

