/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.color;

import com.github.weisj.darklaf.color.DarkColorModel;
import java.awt.Color;

public class DarkColorModelHSB
extends DarkColorModel {
    private static final int[] hsb = new int[3];
    private static final int[] rgb = new int[3];

    public DarkColorModelHSB() {
        super("hsv", "Hue", "Saturation", "Brightness");
    }

    @Override
    public int getMaximum(int index) {
        return index == 0 ? 359 : 100;
    }

    @Override
    public String toString() {
        return "HSB";
    }

    @Override
    public char[] getLabelDescriptorsBefore() {
        return new char[]{'H', 'S', 'B'};
    }

    @Override
    public char[] getLabelDescriptorsAfter() {
        return new char[]{'\u00b0', '%', '%'};
    }

    @Override
    public int[] getValuesFromColor(Color color) {
        return DarkColorModelHSB.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int[] RGBtoHSB(int r, int g, int b) {
        double hue;
        int cmin;
        int cmax = Math.max(r, g);
        if (b > cmax) {
            cmax = b;
        }
        if (b < (cmin = Math.min(r, g))) {
            cmin = b;
        }
        double brightness = (double)cmax / 255.0;
        double saturation = cmax != 0 ? (double)(cmax - cmin) / (double)cmax : 0.0;
        if (saturation == 0.0) {
            hue = 0.0;
        } else {
            double redc = (double)(cmax - r) / (double)(cmax - cmin);
            double greenc = (double)(cmax - g) / (double)(cmax - cmin);
            double bluec = (double)(cmax - b) / (double)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0 + redc - bluec : 4.0 + greenc - redc);
            if ((hue /= 6.0) < 0.0) {
                hue += 1.0;
            }
        }
        DarkColorModelHSB.hsb[0] = (int)Math.round(hue * 360.0);
        DarkColorModelHSB.hsb[1] = (int)Math.round(saturation * 100.0);
        DarkColorModelHSB.hsb[1] = (int)Math.round(brightness * 100.0);
        return hsb;
    }

    @Override
    public Color getColorFromValues(int[] values) {
        int[] rgb = DarkColorModelHSB.HSBtoRGB((double)values[0] / 360.0, (double)values[1] / 100.0, (double)values[2] / 100.0);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static int[] HSBtoRGB(double hue, double saturation, double brightness) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (saturation == 0.0) {
            g = b = brightness * 255.0 + 0.5;
            r = b;
        } else {
            double h = (hue - Math.floor(hue)) * 6.0;
            double f = h - Math.floor(h);
            double p = brightness * (1.0 - saturation);
            double q = brightness * (1.0 - saturation * f);
            double t = brightness * (1.0 - saturation * (1.0 - f));
            switch ((int)Math.round(h)) {
                case 0: {
                    r = brightness * 255.0 + 0.5;
                    g = t * 255.0 + 0.5;
                    b = p * 255.0 + 0.5;
                    break;
                }
                case 1: {
                    r = q * 255.0 + 0.5;
                    g = brightness * 255.0 + 0.5;
                    b = p * 255.0 + 0.5;
                    break;
                }
                case 2: {
                    r = p * 255.0 + 0.5;
                    g = brightness * 255.0 + 0.5;
                    b = t * 255.0 + 0.5;
                    break;
                }
                case 3: {
                    r = p * 255.0 + 0.5;
                    g = q * 255.0 + 0.5;
                    b = brightness * 255.0 + 0.5;
                    break;
                }
                case 4: {
                    r = t * 255.0 + 0.5;
                    g = p * 255.0 + 0.5;
                    b = brightness * 255.0 + 0.5;
                    break;
                }
                case 5: {
                    r = brightness * 255.0 + 0.5;
                    g = p * 255.0 + 0.5;
                    b = q * 255.0 + 0.5;
                }
            }
        }
        DarkColorModelHSB.rgb[0] = (int)Math.round(r);
        DarkColorModelHSB.rgb[1] = (int)Math.round(g);
        DarkColorModelHSB.rgb[2] = (int)Math.round(b);
        return rgb;
    }
}

