/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.components.border.DarkBorders;
import com.github.weisj.darklaf.platform.Decorations;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.ui.DarkPopupFactory;
import com.github.weisj.darklaf.ui.popupmenu.DarkPopupMenuUI;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class DarkLaf
extends BasicLookAndFeel {
    public static final String SYSTEM_PROPERTY_PREFIX = "darklaf.";
    private static final Logger LOGGER = Logger.getLogger(DarkLaf.class.getName());
    private static final String NAME = "Darklaf";
    private final BasicLookAndFeel base;

    public DarkLaf() {
        LafManager.getTheme().beforeInstall();
        this.base = this.getBase();
    }

    private BasicLookAndFeel getBase() {
        BasicLookAndFeel baseLaf;
        if (SystemInfo.isWindows || SystemInfo.isLinux) {
            baseLaf = new MetalLookAndFeel();
        } else {
            String systemLafClassName = UIManager.getSystemLookAndFeelClassName();
            LookAndFeel currentLaf = UIManager.getLookAndFeel();
            if (currentLaf != null && systemLafClassName.equals(currentLaf.getClass().getName())) {
                baseLaf = this.currentOrFallback(currentLaf);
            } else {
                try {
                    UIManager.setLookAndFeel(systemLafClassName);
                    baseLaf = this.currentOrFallback(UIManager.getLookAndFeel());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e.getStackTrace());
                    throw new IllegalStateException("Could not load base LaF class." + e.getMessage());
                }
            }
        }
        return baseLaf;
    }

    private BasicLookAndFeel currentOrFallback(LookAndFeel currentLaf) {
        if (currentLaf instanceof BasicLookAndFeel) {
            return (BasicLookAndFeel)currentLaf;
        }
        return new MetalLookAndFeel();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
        UIDefaults defaults = this.base.getDefaults();
        try {
            DarkLaf.initInputMapDefaults(defaults);
            this.loadThemeDefaults(defaults);
            this.initIdeaDefaults(defaults);
            DarkLaf.patchComboBox(metalDefaults, defaults);
            if (SystemInfo.isMac) {
                this.patchMacOSFonts(defaults);
            }
            this.setupDecorations();
            String key = "PopupMenu.defaultLightWeightPopups";
            if (SystemInfo.isWindows10 && Decorations.isCustomDecorationSupported()) {
                JPopupMenu.setDefaultLightWeightPopupEnabled(defaults.getBoolean(key + ".windows"));
            } else {
                JPopupMenu.setDefaultLightWeightPopupEnabled(defaults.getBoolean(key));
            }
            DarkBorders.update(defaults);
            return defaults;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.toString(), e.getStackTrace());
            return defaults;
        }
    }

    private void patchMacOSFonts(UIDefaults defaults) {
        for (Map.Entry entry : defaults.entrySet()) {
            if (!(entry.getValue() instanceof Font)) continue;
            Font font = (Font)entry.getValue();
            entry.setValue(this.macOSFontFromFont(font));
        }
    }

    private Font macOSFontFromFont(Font font) {
        Map<TextAttribute, Integer> attributes = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        String fontName = SystemInfo.isMacOSCatalina ? ".AppleSystemUIFont" : ".SF NS Text";
        Font macFont = new Font(fontName, font.getStyle(), font.getSize()).deriveFont(attributes);
        if (font instanceof UIResource) {
            macFont = new FontUIResource(macFont);
        }
        return macFont == null ? font : macFont;
    }

    private void setupDecorations() {
        Decorations.initialize();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    protected void adjustPlatformSpecifics(Properties uiProps) {
        boolean useScreenMenuBar = Boolean.getBoolean("apple.laf.useScreenMenuBar");
        if (SystemInfo.isMac && useScreenMenuBar) {
            uiProps.remove("MenuBarUI");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            DarkLaf.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            DarkLaf.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            DarkLaf.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            DarkLaf.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    private void loadThemeDefaults(UIDefaults defaults) {
        Properties uiProps = new Properties();
        Theme currentTheme = LafManager.getTheme();
        currentTheme.loadDefaults(uiProps, defaults);
        PropertyLoader.putProperties(LafManager.getUserProperties(), uiProps, defaults);
        currentTheme.loadGlobals(uiProps, defaults);
        this.installGlobals(uiProps, defaults);
        this.loadFontProperties(uiProps, defaults);
        currentTheme.loadUIProperties(uiProps, defaults);
        currentTheme.loadIconProperties(uiProps, defaults);
        currentTheme.loadPlatformProperties(uiProps, defaults);
        Decorations.loadDecorationProperties(uiProps, defaults);
        this.adjustPlatformSpecifics(uiProps);
        this.loadSystemOverwrites(uiProps, defaults);
        defaults.putAll(uiProps);
        StyleSheet styleSheet = currentTheme.loadStyleSheet();
        new HTMLEditorKit().setStyleSheet(styleSheet);
    }

    private void loadFontProperties(Properties uiProps, UIDefaults defaults) {
        Properties fontProps = PropertyLoader.loadProperties(DarkLaf.class, "font", "properties/");
        PropertyLoader.putProperties(fontProps, uiProps, defaults);
    }

    private void loadSystemOverwrites(Properties uiProps, UIDefaults defaults) {
        Properties overwrites = PropertyLoader.loadProperties(DarkLaf.class, "overwrites", "properties/");
        overwrites.values().removeIf(v -> System.getProperty(SYSTEM_PROPERTY_PREFIX + v.toString()) == null);
        overwrites.entrySet().forEach(e -> e.setValue(System.getProperty(SYSTEM_PROPERTY_PREFIX + e.getValue().toString())));
        PropertyLoader.putProperties(overwrites, uiProps, defaults);
    }

    private void initIdeaDefaults(UIDefaults defaults) {
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "meta C", "copy", "ctrl V", "paste", "meta V", "paste", "ctrl X", "cut", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "meta A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}));
    }

    @Override
    public String getID() {
        return this.getName();
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        int mask = SystemInfo.isMac ? 256 : 128;
        inputMap.put(KeyStroke.getKeyStroke(155, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 64), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 64), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, mask), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, mask), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, mask), "cut-to-clipboard");
    }

    private void installGlobals(Properties uiProps, UIDefaults defaults) {
        HashMap<String, Object> globalSettings = new HashMap<String, Object>();
        String prefix = "global.";
        for (Object key : uiProps.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith("global.")) continue;
            globalSettings.put(((String)key).substring("global.".length()), uiProps.get(key));
        }
        for (Object key : defaults.keySet()) {
            String s;
            String globalKey;
            if (!(key instanceof String) || !((String)key).contains(".") || !globalSettings.containsKey(globalKey = (s = (String)key).substring(s.lastIndexOf(46) + 1))) continue;
            defaults.put(key, globalSettings.get(globalKey));
        }
    }

    @Override
    public String getDescription() {
        return "Dark Look and feel based on Darcula-LAF";
    }

    @Override
    public void initialize() {
        this.base.initialize();
        PopupFactory.setSharedInstance(new DarkPopupFactory());
    }

    @Override
    public void uninitialize() {
        this.base.uninitialize();
        DarkPopupMenuUI.MouseGrabber mouseGrabber = DarkPopupMenuUI.getMouseGrabber();
        if (mouseGrabber != null) {
            mouseGrabber.uninstall();
        }
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return Decorations.isCustomDecorationSupported();
    }
}

