/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;

public class GrayS64
extends ImageGray<GrayS64> {
    public long[] data;

    public GrayS64(int width, int height) {
        super(width, height);
    }

    public GrayS64() {
    }

    public long get(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        return this.unsafe_get(x, y);
    }

    public long unsafe_get(int x, int y) {
        return this.data[this.getIndex(x, y)];
    }

    public void set(int x, int y, long value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        this.unsafe_set(x, y, value);
    }

    public void unsafe_set(int x, int y, long value) {
        this.data[this.getIndex((int)x, (int)y)] = value;
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.S64;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    public void _setData(Object data) {
        this.data = (long[])data;
    }

    @Override
    public GrayS64 createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new GrayS64();
        }
        return new GrayS64(imgWidth, imgHeight);
    }

    @Override
    public void copyCol(int col, int row0, int row1, int offset, Object array) {
        int idxSrc;
        long[] dst = (long[])array;
        int idxDst = offset;
        int end = idxSrc + (row1 - row0) * this.stride;
        for (idxSrc = this.startIndex + this.stride * row0 + col; idxSrc < end; idxSrc += this.stride) {
            dst[idxDst++] = this.data[idxSrc];
        }
    }

    public long[] getData() {
        return this.data;
    }

    public void setData(long[] data) {
        this.data = data;
    }

    @Override
    public void print() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                System.out.printf("%3d ", this.get(x, y));
            }
            System.out.println();
        }
    }
}

