/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;

public abstract class GrayI8<T extends GrayI8<T>>
extends GrayI<T> {
    public byte[] data;

    protected GrayI8(int width, int height) {
        super(width, height);
    }

    protected GrayI8() {
    }

    protected GrayI8(byte[][] input) {
        this.height = input.length;
        this.width = this.height == 0 ? 0 : input[0].length;
        this.initialize(this.width, this.height);
        for (int y = 0; y < this.height; ++y) {
            if (input[y].length != this.width) {
                throw new IllegalArgumentException("rows must have constant length");
            }
            System.arraycopy(input[y], 0, this.data, y * this.width, this.width);
        }
    }

    @Override
    public void set(int x, int y, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds: " + x + " " + y);
        }
        this.data[this.getIndex((int)x, (int)y)] = (byte)value;
    }

    @Override
    public void copyCol(int col, int row0, int row1, int offset, Object array) {
        int idxSrc;
        byte[] dst = (byte[])array;
        int idxDst = offset;
        int end = idxSrc + (row1 - row0) * this.stride;
        for (idxSrc = this.startIndex + this.stride * row0 + col; idxSrc < end; idxSrc += this.stride) {
            dst[idxDst++] = this.data[idxSrc];
        }
    }

    @Override
    public void unsafe_set(int x, int y, int value) {
        this.data[this.getIndex((int)x, (int)y)] = (byte)value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    public void _setData(Object data) {
        this.data = (byte[])data;
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.I8;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

