/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.border;

import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageGray;

public abstract class ImageBorderWrapped {
    public static <T extends ImageGray<T>> ImageBorder<T> wrap(T border, T image) {
        ImageBorder ret;
        int offsetX = (border.width - image.width) / 2;
        int offsetY = (border.height - image.height) / 2;
        if (border instanceof GrayI) {
            ret = new S32<GrayI>(offsetX, offsetY, (GrayI)border);
        } else if (border instanceof GrayF32) {
            ret = new F32(offsetX, offsetY, (GrayF32)border);
        } else {
            throw new RuntimeException("Not supported yet");
        }
        ret.setImage((GrayI)image);
        return ret;
    }

    public static class S32<T extends GrayI<T>>
    extends ImageBorder_S32<T> {
        public int offsetX;
        public int offsetY;
        public T borderImage;

        public S32(int offsetX, int offsetY, T borderImage) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.borderImage = borderImage;
        }

        public S32() {
        }

        @Override
        public int getOutside(int x, int y) {
            return ((GrayI)this.borderImage).get(x + this.offsetX, y + this.offsetY);
        }

        @Override
        public void setOutside(int x, int y, int value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public ImageBorder<T> copy() {
            S32<T> copy = new S32<T>();
            copy.offsetX = this.offsetX;
            copy.offsetY = this.offsetY;
            copy.borderImage = this.borderImage;
            copy.image = this.image;
            return copy;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetX(int offsetX) {
            this.offsetX = offsetX;
        }

        public void setOffsetY(int offsetY) {
            this.offsetY = offsetY;
        }

        public T getBorderImage() {
            return this.borderImage;
        }

        public void setBorderImage(T borderImage) {
            this.borderImage = borderImage;
        }
    }

    public static class F32
    extends ImageBorder_F32 {
        public int offsetX;
        public int offsetY;
        public GrayF32 borderImage;

        public F32(int offsetX, int offsetY, GrayF32 borderImage) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.borderImage = borderImage;
        }

        public F32() {
        }

        @Override
        public float getOutside(int x, int y) {
            return this.borderImage.get(x + this.offsetX, y + this.offsetY);
        }

        @Override
        public void setOutside(int x, int y, float value) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public ImageBorder<GrayF32> copy() {
            F32 copy = new F32();
            copy.offsetX = this.offsetX;
            copy.offsetY = this.offsetY;
            copy.borderImage = this.borderImage;
            copy.image = this.image;
            return copy;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetX(int offsetX) {
            this.offsetX = offsetX;
        }

        public void setOffsetY(int offsetY) {
            this.offsetY = offsetY;
        }

        public GrayF32 getBorderImage() {
            return this.borderImage;
        }

        public void setBorderImage(GrayF32 borderImage) {
            this.borderImage = borderImage;
        }
    }
}

