/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.border;

import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_IL_F32;
import boofcv.struct.border.ImageBorder_IL_F64;
import boofcv.struct.border.ImageBorder_IL_S32;
import boofcv.struct.border.ImageBorder_IL_S64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.border.ImageBorder_S64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedInteger;
import boofcv.struct.image.InterleavedS64;
import java.util.Arrays;

public class ImageBorderValue {
    public static ImageBorder wrap(ImageGray image, double value) {
        if (image.getDataType().isInteger()) {
            if (image.getDataType().getNumBits() <= 32) {
                return ImageBorderValue.wrap((GrayI)image, (int)value);
            }
            return ImageBorderValue.wrap((GrayS64)image, (long)value);
        }
        if (image.getDataType().getDataType() == Float.TYPE) {
            return ImageBorderValue.wrap((GrayF32)image, (float)value);
        }
        return ImageBorderValue.wrap((GrayF64)image, value);
    }

    public static ImageBorder wrap(ImageInterleaved image, double value) {
        if (image instanceof InterleavedF32) {
            return new Value_IL_F32((InterleavedF32)image, (float)value);
        }
        if (image instanceof InterleavedF64) {
            return new Value_IL_F64((InterleavedF64)image, value);
        }
        if (InterleavedInteger.class.isAssignableFrom(image.getClass())) {
            return new Value_IL_S32((InterleavedInteger)image, (int)value);
        }
        if (image instanceof InterleavedS64) {
            return new Value_IL_S64((InterleavedS64)image, (long)value);
        }
        throw new RuntimeException("Add support for more types");
    }

    public static ImageBorder_S64 wrap(GrayS64 image, long value) {
        return new Value_I64(image, value);
    }

    public static ImageBorder_F64 wrap(GrayF64 image, double value) {
        return new Value_F64(image, value);
    }

    public static ImageBorder_F32 wrap(GrayF32 image, float value) {
        return new Value_F32(image, value);
    }

    public static ImageBorder_S32 wrap(GrayI image, int value) {
        return new Value_I(image, value);
    }

    public static class Value_IL_F32
    extends ImageBorder_IL_F32 {
        public float value;

        public Value_IL_F32(InterleavedF32 image, float value) {
            super(image);
            this.value = value;
        }

        public Value_IL_F32(float value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, float[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, float[] pixel) {
        }

        public Value_IL_F32 copy() {
            return new Value_IL_F32(this.value);
        }
    }

    public static class Value_IL_F64
    extends ImageBorder_IL_F64 {
        public double value;

        public Value_IL_F64(InterleavedF64 image, double value) {
            super(image);
            this.value = value;
        }

        public Value_IL_F64(double value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, double[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, double[] pixel) {
        }

        public Value_IL_F64 copy() {
            return new Value_IL_F64(this.value);
        }
    }

    public static class Value_IL_S32
    extends ImageBorder_IL_S32 {
        public int value;

        public Value_IL_S32(InterleavedInteger image, int value) {
            super(image);
            this.value = value;
        }

        public Value_IL_S32(int value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, int[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, int[] pixel) {
        }

        public Value_IL_S32 copy() {
            return new Value_IL_S32(this.value);
        }
    }

    public static class Value_IL_S64
    extends ImageBorder_IL_S64 {
        public long value;

        public Value_IL_S64(InterleavedS64 image, long value) {
            super(image);
            this.value = value;
        }

        public Value_IL_S64(long value) {
            this.value = value;
        }

        @Override
        public void getOutside(int x, int y, long[] pixel) {
            Arrays.fill(pixel, this.value);
        }

        @Override
        public void setOutside(int x, int y, long[] pixel) {
        }

        public Value_IL_S64 copy() {
            return new Value_IL_S64(this.value);
        }
    }

    public static class Value_I64
    extends ImageBorder_S64 {
        public long value;

        public Value_I64(GrayS64 image, long value) {
            super(image);
            this.value = value;
        }

        public Value_I64(long value) {
            this.value = value;
        }

        @Override
        public long getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, long val2) {
        }

        public Value_I64 copy() {
            return new Value_I64(this.value);
        }
    }

    public static class Value_F64
    extends ImageBorder_F64 {
        public double value;

        public Value_F64(GrayF64 image, double value) {
            super(image);
            this.value = value;
        }

        public Value_F64(double value) {
            this.value = value;
        }

        @Override
        public double getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, double val2) {
        }

        public Value_F64 copy() {
            return new Value_F64(this.value);
        }
    }

    public static class Value_F32
    extends ImageBorder_F32 {
        public float value;

        public Value_F32(GrayF32 image, float value) {
            super(image);
            this.value = value;
        }

        public Value_F32(float value) {
            this.value = value;
        }

        @Override
        public float getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, float val2) {
        }

        public Value_F32 copy() {
            return new Value_F32(this.value);
        }
    }

    public static class Value_I
    extends ImageBorder_S32 {
        public int value;

        public Value_I(GrayI image, int value) {
            super(image);
            this.value = value;
        }

        public Value_I(int value) {
            this.value = value;
        }

        @Override
        public int getOutside(int x, int y) {
            return this.value;
        }

        @Override
        public void setOutside(int x, int y, int value) {
        }

        public Value_I copy() {
            return new Value_I(this.value);
        }
    }
}

