/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.Configuration;

public class ConfigLength
implements Configuration {
    public double length = -1.0;
    public double fraction = -1.0;

    public ConfigLength(double length, double fraction) {
        this.length = length;
        this.fraction = fraction;
    }

    public ConfigLength() {
    }

    public static ConfigLength fixed(double length) {
        return new ConfigLength(length, -1.0);
    }

    public static ConfigLength relative(double fraction, double minimum) {
        return new ConfigLength(minimum, fraction);
    }

    public void setFixed(double length) {
        this.fraction = -1.0;
        this.length = length;
    }

    public void setRelative(double fraction, double minimum) {
        this.fraction = fraction;
        this.length = minimum;
    }

    public double compute(double totalLength) {
        double size;
        if (this.fraction >= 0.0) {
            size = this.fraction * totalLength;
            size = Math.max(size, this.length);
        } else {
            size = this.length;
        }
        return size;
    }

    public boolean isRelative() {
        return this.fraction >= 0.0;
    }

    public boolean isFixed() {
        return this.fraction < 0.0;
    }

    public int computeI(double totalLength) {
        double size = this.compute(totalLength);
        if (size >= 0.0) {
            return (int)Math.round(size);
        }
        return -1;
    }

    public int getLengthI() {
        return (int)Math.round(this.length);
    }

    @Override
    public void checkValidity() {
        if (this.length < 0.0 && this.fraction < 0.0) {
            throw new IllegalArgumentException("length and/or fraction must be >= 0");
        }
        if (this.isRelative() && (this.fraction < 0.0 || this.fraction > 1.0)) {
            throw new IllegalArgumentException("Fractional value must be from 0.0maxFeatures to 1.0, inclusive");
        }
    }

    public void setTo(ConfigLength src) {
        this.length = src.length;
        this.fraction = src.fraction;
    }

    public ConfigLength copy() {
        ConfigLength out = new ConfigLength();
        out.setTo(this);
        return out;
    }

    public String toString() {
        String out = "ConfigLength{";
        out = this.fraction >= 0.0 ? out + "fraction=" + this.fraction + ", minimum=" + this.length : out + ", length=" + this.length;
        out = out + '}';
        return out;
    }

    public double getLength() {
        return this.length;
    }

    public double getFraction() {
        return this.fraction;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setFraction(double fraction) {
        this.fraction = fraction;
    }
}

