/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.DogArray;

public class DiscretizedCircle {
    public static int[] imageOffsets(double radius, int imgWidth) {
        double PI2 = Math.PI * 2;
        double circumference = PI2 * radius;
        int num = (int)Math.ceil(circumference);
        num -= num % 4;
        double angleStep = PI2 / (double)num;
        int[] temp = new int[(int)Math.ceil(circumference)];
        int i = 0;
        int prev = 0;
        for (double ang = 0.0; ang < PI2; ang += angleStep) {
            int x = (int)Math.round(Math.cos(ang) * radius);
            int y = (int)Math.round(Math.sin(ang) * radius);
            int pixel = y * imgWidth + x;
            if (pixel != prev) {
                temp[i++] = pixel;
            }
            prev = pixel;
        }
        if (i == temp.length) {
            return temp;
        }
        int[] ret = new int[i];
        System.arraycopy(temp, 0, ret, 0, i);
        return ret;
    }

    public static void coordinates(double radius, DogArray<Point2D_I32> coordinates) {
        coordinates.reset();
        double PI2 = Math.PI * 2;
        double circumference = PI2 * radius;
        int num = (int)Math.ceil(circumference);
        num -= num % 4;
        double angleStep = PI2 / (double)num;
        int width = (int)Math.ceil(radius) * 2 + 1;
        int prev = 0;
        for (double ang = 0.0; ang < PI2; ang += angleStep) {
            int x = (int)Math.round(Math.cos(ang) * radius);
            int y = (int)Math.round(Math.sin(ang) * radius);
            int pixel = y * width + x;
            if (pixel != prev) {
                coordinates.grow().setTo(x, y);
            }
            prev = pixel;
        }
    }

    public static int[][] imageOffsets2(double radius) {
        double PI2 = Math.PI * 2;
        double circumference = PI2 * radius;
        int num = (int)Math.ceil(circumference);
        num -= num % 4;
        double angleStep = PI2 / (double)num;
        int[][] temp = new int[num][2];
        for (int i = 0; i < num; ++i) {
            double ang = angleStep * (double)i;
            int x = (int)Math.round(Math.cos(ang) * radius);
            int y = (int)Math.round(Math.sin(ang) * radius);
            temp[i][0] = x;
            temp[i][1] = y;
        }
        return temp;
    }
}

