/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper;

import boofcv.io.MediaManager;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.io.video.DynamicVideoInterface;
import boofcv.io.video.VideoInterface;
import boofcv.io.wrapper.DynamicWebcamInterface;
import boofcv.io.wrapper.WebcamInterface;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class DefaultMediaManager
implements MediaManager {
    public static final DefaultMediaManager INSTANCE = new DefaultMediaManager();
    Map<String, BufferedImage> cachedImage = new HashMap<String, BufferedImage>();
    VideoInterface videoInterface = new DynamicVideoInterface();
    WebcamInterface webcamInterface = new DynamicWebcamInterface();

    @Override
    public Reader openFile(String fileName) {
        InputStream stream = UtilIO.openStream(fileName);
        if (stream == null) {
            return null;
        }
        return new InputStreamReader(stream, Charset.forName("UTF-8"));
    }

    @Override
    public BufferedImage openImage(String fileName) {
        BufferedImage b = this.cachedImage.get(fileName);
        if (b == null) {
            b = UtilImageIO.loadImage(fileName);
            if (b == null) {
                return null;
            }
            this.cachedImage.put(fileName, b);
        }
        BufferedImage c = new BufferedImage(b.getWidth(), b.getHeight(), b.getType());
        Graphics2D g2 = c.createGraphics();
        g2.drawImage((Image)b, 0, 0, null);
        return c;
    }

    @Override
    public <T extends ImageBase<T>> SimpleImageSequence<T> openVideo(String fileName, ImageType<T> type) {
        return this.videoInterface.load(fileName, type);
    }

    @Override
    public <T extends ImageBase<T>> SimpleImageSequence<T> openCamera(String device, int width, int height, ImageType<T> imageType) {
        return this.webcamInterface.open(device, width, height, imageType);
    }
}

