/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.video;

import boofcv.io.UtilIO;
import boofcv.misc.BoofMiscOps;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.ddogleg.struct.DogArray_I8;

public class CombineFilesTogether {
    public static void combine(List<String> fileNames, String outputName) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputName);
        DogArray_I8 buffer = new DogArray_I8();
        for (String s : fileNames) {
            File f = new File(s);
            FileInputStream fis = new FileInputStream(f);
            long length = f.length();
            buffer.resize((int)length);
            fos.write(255);
            fos.write(255);
            fos.write(255);
            fos.write((byte)(length >> 24));
            fos.write((byte)(length >> 16));
            fos.write((byte)(length >> 8));
            fos.write((byte)length);
            int readLength = fis.read(buffer.data, 0, (int)length);
            BoofMiscOps.checkEq(readLength, (int)length);
            fos.write(buffer.data, 0, (int)length);
        }
    }

    public static boolean readNext(DataInputStream fis, DogArray_I8 output) throws IOException {
        int r = fis.read();
        if (r != 255 || (r = fis.read()) != 255 || (r = fis.read()) != 255) {
            if (r == -1) {
                return false;
            }
            throw new IllegalArgumentException("Bad header byte: " + r);
        }
        int length = (fis.read() & 0xFF) << 24 | (fis.read() & 0xFF) << 16 | (fis.read() & 0xFF) << 8 | fis.read() & 0xFF;
        output.resize(length);
        int readLength = fis.read(output.data, 0, length);
        BoofMiscOps.checkEq(readLength, length);
        return true;
    }

    public static void main(String[] args) throws IOException {
        List<String> fileNames = UtilIO.listByPrefix("log", "depth", null);
        Collections.sort(fileNames);
        CombineFilesTogether.combine(fileNames, "combined.mpng");
    }
}

