/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.calibration;

import boofcv.io.UtilIO;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.calib.MonoPlaneParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.calib.VisualDepthParameters;
import georegression.struct.se.Se3_F64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class CalibrationIO {
    public static String MODEL_PINHOLE = "pinhole";
    public static String MODEL_PINHOLE_RADIAL_TAN = "pinhole_radial_tangential";
    public static String MODEL_OMNIDIRECTIONAL_UNIVERSAL = "omnidirectional_universal";
    public static String MODEL_STEREO = "stereo_camera";
    public static String MODEL_RIGID_BODY = "rigid_body";
    public static String MODEL_VISUAL_DEPTH = "visual_depth";
    public static String MODEL_MONO_PLANE = "monocular_plane";
    public static String VERSION = "version";

    public static <T extends CameraPinhole> void save(T parameters, Writer outputWriter) {
        PrintWriter out = new PrintWriter(outputWriter);
        Yaml yaml = CalibrationIO.createYmlObject();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (parameters instanceof CameraPinholeBrown) {
            out.println("# Pinhole camera model with radial and tangential distortion");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println("# radial = radial distortion, (t1,t2) = tangential distortion");
            out.println();
            CalibrationIO.putModelRadial((CameraPinholeBrown)parameters, data);
        } else if (parameters instanceof CameraUniversalOmni) {
            out.println("# Omnidirectional camera model with radial and tangential distortion");
            out.println("# C. Mei, and P. Rives. \"Single view point omnidirectional camera calibration from planar grids.\"  ICRA 2007");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println("# mirror_offset = offset mirror along z-axis in unit circle");
            out.println("# radial = radial distortion, (t1,t2) = tangential distortion");
            out.println();
            CalibrationIO.putModelUniversalOmni((CameraUniversalOmni)parameters, data);
        } else {
            out.println("# Pinhole camera model");
            out.println("# (fx,fy) = focal length, (cx,cy) = principle point, (width,height) = image shape");
            out.println();
            CalibrationIO.putModelPinhole(parameters, data);
        }
        yaml.dump(data, out);
        out.close();
    }

    public static <T extends CameraPinhole> void save(T parameters, String filePath) {
        try {
            CalibrationIO.save(parameters, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T extends CameraPinhole> void save(T parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static Yaml createYmlObject() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(options);
    }

    public static void save(StereoParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_STEREO);
        map.put(VERSION, 0);
        map.put("left", CalibrationIO.putModelRadial(parameters.left, null));
        map.put("right", CalibrationIO.putModelRadial(parameters.right, null));
        map.put("rightToLeft", CalibrationIO.putSe3(parameters.right_to_left));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Intrinsic and extrinsic parameters for a stereo camera pair");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, out);
        out.close();
    }

    public static void save(StereoParameters parameters, String outputPath) {
        try {
            CalibrationIO.save(parameters, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(StereoParameters parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static void save(Se3_F64 rigidBody, File filePath) {
        CalibrationIO.save(rigidBody, filePath.getPath());
    }

    public static void save(Se3_F64 rigidBody, String outputPath) {
        try {
            CalibrationIO.save(rigidBody, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(Se3_F64 rigidBody, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_RIGID_BODY);
        map.put(VERSION, 0);
        map.put("parameters", CalibrationIO.putSe3(rigidBody));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Rigid Body transformation");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, out);
        out.close();
    }

    public static void save(VisualDepthParameters parameters, File filePath) {
        CalibrationIO.save(parameters, filePath.getPath());
    }

    public static void save(VisualDepthParameters parameters, String outputPath) {
        try {
            CalibrationIO.save(parameters, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void save(VisualDepthParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_VISUAL_DEPTH);
        map.put(VERSION, 0);
        map.put("max_depth", parameters.getMaxDepth());
        map.put("no_depth", parameters.getPixelNoDepth());
        map.put("intrinsic", CalibrationIO.putModelRadial(parameters.getVisualParam(), null));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# RGB Depth Camera Calibration");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, out);
        out.close();
    }

    public static void save(MonoPlaneParameters parameters, Writer outputWriter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", MODEL_MONO_PLANE);
        map.put(VERSION, 0);
        map.put("intrinsic", CalibrationIO.putModelRadial(parameters.getIntrinsic(), null));
        map.put("plane_to_camera", CalibrationIO.putSe3(parameters.getPlaneToCamera()));
        PrintWriter out = new PrintWriter(outputWriter);
        out.println("# Monocular Camera with Known Plane Distance");
        Yaml yaml = CalibrationIO.createYmlObject();
        yaml.dump(map, out);
        out.close();
    }

    public static <T> T load(@Nullable URL path) {
        if (path == null) {
            throw new RuntimeException("Null path");
        }
        try {
            return CalibrationIO.load(new InputStreamReader(path.openStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T load(File path) {
        URL url = UtilIO.ensureURL(path.getPath());
        if (url == null) {
            throw new RuntimeException("Can't find " + path.getPath());
        }
        return CalibrationIO.load(url);
    }

    public static <T> T load(String path) {
        URL url = UtilIO.ensureURL(path);
        if (url == null) {
            throw new RuntimeException("Can't find " + path);
        }
        return CalibrationIO.load(url);
    }

    public static <T> T load(Reader reader) {
        Yaml yaml = CalibrationIO.createYmlObject();
        Map data = (Map)yaml.load(reader);
        try {
            reader.close();
            return CalibrationIO.load(data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T> T load(Map<String, Object> data) throws IOException {
        String model = (String)data.get("model");
        if (model == null) {
            throw new RuntimeException("Missing model parameter");
        }
        if (model.equals(MODEL_PINHOLE)) {
            CameraPinhole parameters = new CameraPinhole();
            CalibrationIO.loadPinhole((Map)BoofMiscOps.getOrThrow(data, "pinhole"), parameters);
            return (T)parameters;
        }
        if (model.equals(MODEL_PINHOLE_RADIAL_TAN)) {
            List list;
            CameraPinholeBrown parameters = new CameraPinholeBrown();
            CalibrationIO.loadPinhole((Map)data.get("pinhole"), parameters);
            Map distortion = (Map)BoofMiscOps.getOrThrow(data, "radial_tangential");
            if (distortion.containsKey("radial") && (list = (List)distortion.get("radial")) != null) {
                parameters.radial = new double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    parameters.radial[i] = (Double)list.get(i);
                }
            }
            if (distortion.containsKey("t1")) {
                parameters.t1 = (Double)distortion.get("t1");
            }
            if (distortion.containsKey("t2")) {
                parameters.t2 = (Double)distortion.get("t2");
            }
            return (T)parameters;
        }
        if (model.equals(MODEL_OMNIDIRECTIONAL_UNIVERSAL)) {
            List list;
            CameraUniversalOmni parameters = new CameraUniversalOmni(0);
            CalibrationIO.loadPinhole((Map)BoofMiscOps.getOrThrow(data, "pinhole"), parameters);
            parameters.mirrorOffset = (Double)data.get("mirror_offset");
            Map distortion = (Map)BoofMiscOps.getOrThrow(data, "radial_tangential");
            if (distortion.containsKey("radial") && (list = (List)distortion.get("radial")) != null) {
                parameters.radial = new double[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    parameters.radial[i] = (Double)list.get(i);
                }
            }
            if (distortion.containsKey("t1")) {
                parameters.t1 = (Double)distortion.get("t1");
            }
            if (distortion.containsKey("t2")) {
                parameters.t2 = (Double)distortion.get("t2");
            }
            return (T)parameters;
        }
        if (model.equals(MODEL_STEREO)) {
            StereoParameters parameters = new StereoParameters();
            parameters.left = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, "left"));
            parameters.right = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, "right"));
            parameters.right_to_left = CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow(data, "rightToLeft"), null);
            return (T)parameters;
        }
        if (model.equals(MODEL_VISUAL_DEPTH)) {
            VisualDepthParameters parameters = new VisualDepthParameters();
            parameters.maxDepth = (Number)BoofMiscOps.getOrThrow(data, "max_depth");
            parameters.pixelNoDepth = (Number)BoofMiscOps.getOrThrow(data, "no_depth");
            parameters.visualParam = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, "intrinsic"));
            return (T)parameters;
        }
        if (model.equals(MODEL_MONO_PLANE)) {
            MonoPlaneParameters parameters = new MonoPlaneParameters();
            parameters.intrinsic = (CameraPinholeBrown)CalibrationIO.load((Map)BoofMiscOps.getOrThrow(data, "intrinsic"));
            parameters.planeToCamera = CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow(data, "plane_to_camera"), null);
            return (T)parameters;
        }
        if (model.equals(MODEL_RIGID_BODY)) {
            return (T)CalibrationIO.loadSe3((Map)BoofMiscOps.getOrThrow(data, "parameters"), null);
        }
        throw new RuntimeException("Unknown camera model: " + model);
    }

    private static Map<String, Object> putModelPinhole(CameraPinhole parameters, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_PINHOLE);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole(parameters));
        return map;
    }

    private static Map<String, Object> putModelRadial(CameraPinholeBrown parameters, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_PINHOLE_RADIAL_TAN);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole(parameters));
        map.put("radial_tangential", CalibrationIO.putParamsRadialTangent(parameters));
        return map;
    }

    private static Map<String, Object> putModelUniversalOmni(CameraUniversalOmni parameters, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("model", MODEL_OMNIDIRECTIONAL_UNIVERSAL);
        map.put(VERSION, 0);
        map.put("pinhole", CalibrationIO.putParamsPinhole(parameters));
        map.put("mirror_offset", parameters.mirrorOffset);
        HashMap<String, Object> mapDistort = new HashMap<String, Object>();
        if (parameters.radial != null) {
            mapDistort.put("radial", parameters.radial);
        }
        mapDistort.put("t1", parameters.t1);
        mapDistort.put("t2", parameters.t2);
        map.put("radial_tangential", mapDistort);
        return map;
    }

    public static Map<String, Object> putParamsPinhole(CameraPinhole parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("width", parameters.width);
        map.put("height", parameters.height);
        map.put("fx", parameters.fx);
        map.put("fy", parameters.fy);
        map.put("skew", parameters.skew);
        map.put("cx", parameters.cx);
        map.put("cy", parameters.cy);
        return map;
    }

    public static Map<String, Object> putParamsRadialTangent(CameraPinholeBrown parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (parameters.radial != null) {
            map.put("radial", parameters.radial);
        }
        map.put("t1", parameters.t1);
        map.put("t2", parameters.t2);
        return map;
    }

    public static Map<String, Object> putSe3(Se3_F64 transform) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rotation", transform.R.data);
        map.put("x", transform.T.x);
        map.put("y", transform.T.y);
        map.put("z", transform.T.z);
        return map;
    }

    public static void loadPinhole(Map<String, Object> map, CameraPinhole parameters) {
        try {
            parameters.width = (Integer)BoofMiscOps.getOrThrow(map, "width");
            parameters.height = (Integer)BoofMiscOps.getOrThrow(map, "height");
            parameters.fx = (Double)BoofMiscOps.getOrThrow(map, "fx");
            parameters.fy = (Double)BoofMiscOps.getOrThrow(map, "fy");
            parameters.skew = (Double)BoofMiscOps.getOrThrow(map, "skew");
            parameters.cx = (Double)BoofMiscOps.getOrThrow(map, "cx");
            parameters.cy = (Double)BoofMiscOps.getOrThrow(map, "cy");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Se3_F64 loadSe3(Map<String, Object> map, Se3_F64 transform) {
        if (transform == null) {
            transform = new Se3_F64();
        }
        try {
            List rotation = (List)BoofMiscOps.getOrThrow(map, "rotation");
            transform.T.x = (Double)BoofMiscOps.getOrThrow(map, "x");
            transform.T.y = (Double)BoofMiscOps.getOrThrow(map, "y");
            transform.T.z = (Double)BoofMiscOps.getOrThrow(map, "z");
            for (int i = 0; i < 9; ++i) {
                transform.R.data[i] = (Double)rotation.get(i);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return transform;
    }
}

