/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.settings;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.SolarizedLightTheme;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mdlaf.MaterialLookAndFeel;
import mdlaf.themes.JMarsDarkTheme;
import mdlaf.themes.MaterialLiteTheme;
import mdlaf.themes.MaterialOceanicTheme;

public class GlobalDemoSettings
implements Cloneable {
    public static GlobalDemoSettings SETTINGS = new GlobalDemoSettings();
    private static String KEY_THEME = "theme";
    private static String KEY_CONTROLS3D = "controls3D";
    private static String KEY_VERBOSE_RUNTIME = "verboseRuntime";
    private static String KEY_VERBOSE_TRACKING = "verboseTracking";
    public ThemesUI theme = ThemesUI.DEFAULT;
    public Controls3D controls3D = Controls3D.WASD;
    public boolean verboseRuntime = false;
    public boolean verboseTracking = false;

    public void load() {
        Preferences prefs = Preferences.userRoot().node(GlobalDemoSettings.class.getCanonicalName());
        try {
            this.theme = ThemesUI.valueOf(prefs.get(KEY_THEME, this.theme.name()));
            this.controls3D = Controls3D.valueOf(prefs.get(KEY_CONTROLS3D, this.controls3D.name()));
            this.verboseRuntime = prefs.getBoolean(KEY_VERBOSE_RUNTIME, this.verboseRuntime);
            this.verboseTracking = prefs.getBoolean(KEY_VERBOSE_TRACKING, this.verboseTracking);
        }
        catch (RuntimeException e) {
            this.save();
            e.printStackTrace();
        }
    }

    public void save() {
        Preferences prefs = Preferences.userRoot().node(GlobalDemoSettings.class.getCanonicalName());
        prefs.put(KEY_THEME, this.theme.name());
        prefs.put(KEY_CONTROLS3D, this.controls3D.name());
        prefs.putBoolean(KEY_VERBOSE_RUNTIME, this.verboseRuntime);
        prefs.putBoolean(KEY_VERBOSE_TRACKING, this.verboseTracking);
        try {
            prefs.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void changeTheme() {
        MaterialLookAndFeel selectedInstance = null;
        String selectedName = null;
        LafManager.enableLogging(false);
        switch (this.theme) {
            case DEFAULT: {
                if (System.getProperty("os.name").contains("Mac OS X")) {
                    selectedName = UIManager.getSystemLookAndFeelClassName();
                    break;
                }
                selectedName = UIManager.getCrossPlatformLookAndFeelClassName();
                break;
            }
            case DARKULA: {
                LafManager.setTheme(new DarculaTheme());
                selectedName = DarkLaf.class.getCanonicalName();
                break;
            }
            case INTELLIJ: {
                LafManager.setTheme(new IntelliJTheme());
                selectedName = DarkLaf.class.getCanonicalName();
                break;
            }
            case SOLARIZED: {
                LafManager.setTheme(new SolarizedLightTheme());
                selectedName = DarkLaf.class.getCanonicalName();
                break;
            }
            case MARS_DARK: {
                selectedInstance = new MaterialLookAndFeel(new JMarsDarkTheme());
                break;
            }
            case MATERIAL_LITE: {
                selectedInstance = new MaterialLookAndFeel(new MaterialLiteTheme());
                break;
            }
            case MATERIAL_OCEANIC: {
                selectedInstance = new MaterialLookAndFeel(new MaterialOceanicTheme());
                break;
            }
            default: {
                System.err.println("BUG! Unknown Look and Feel " + (Object)((Object)this.theme));
                return;
            }
        }
        try {
            if (selectedInstance == null) {
                UIManager.setLookAndFeel(selectedName);
            } else {
                UIManager.setLookAndFeel(selectedInstance);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public GlobalDemoSettings copy() {
        GlobalDemoSettings ret = new GlobalDemoSettings();
        ret.theme = this.theme;
        ret.verboseRuntime = this.verboseRuntime;
        ret.verboseTracking = this.verboseTracking;
        return ret;
    }

    public ThemesUI getTheme() {
        return this.theme;
    }

    public Controls3D getControls3D() {
        return this.controls3D;
    }

    public boolean isVerboseRuntime() {
        return this.verboseRuntime;
    }

    public boolean isVerboseTracking() {
        return this.verboseTracking;
    }

    public void setTheme(ThemesUI theme) {
        this.theme = theme;
    }

    public void setControls3D(Controls3D controls3D) {
        this.controls3D = controls3D;
    }

    public void setVerboseRuntime(boolean verboseRuntime) {
        this.verboseRuntime = verboseRuntime;
    }

    public void setVerboseTracking(boolean verboseTracking) {
        this.verboseTracking = verboseTracking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalDemoSettings)) {
            return false;
        }
        GlobalDemoSettings other = (GlobalDemoSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ThemesUI this$theme = this.getTheme();
        ThemesUI other$theme = other.getTheme();
        if (this$theme == null ? other$theme != null : !((Object)((Object)this$theme)).equals((Object)other$theme)) {
            return false;
        }
        Controls3D this$controls3D = this.getControls3D();
        Controls3D other$controls3D = other.getControls3D();
        if (this$controls3D == null ? other$controls3D != null : !((Object)((Object)this$controls3D)).equals((Object)other$controls3D)) {
            return false;
        }
        if (this.isVerboseRuntime() != other.isVerboseRuntime()) {
            return false;
        }
        return this.isVerboseTracking() == other.isVerboseTracking();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalDemoSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ThemesUI $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : ((Object)((Object)$theme)).hashCode());
        Controls3D $controls3D = this.getControls3D();
        result = result * 59 + ($controls3D == null ? 43 : ((Object)((Object)$controls3D)).hashCode());
        result = result * 59 + (this.isVerboseRuntime() ? 79 : 97);
        result = result * 59 + (this.isVerboseTracking() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GlobalDemoSettings(theme=" + (Object)((Object)this.getTheme()) + ", controls3D=" + (Object)((Object)this.getControls3D()) + ", verboseRuntime=" + this.isVerboseRuntime() + ", verboseTracking=" + this.isVerboseTracking() + ")";
    }

    static {
        SETTINGS.load();
    }

    public static enum ThemesUI {
        DEFAULT("Default"),
        DARKULA("Darkula"),
        INTELLIJ("IntelliJ"),
        SOLARIZED("Solarized"),
        MARS_DARK("Mars Dark"),
        MATERIAL_LITE("Material Lite"),
        MATERIAL_OCEANIC("Material Oceanic");

        final String name;

        private ThemesUI(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Controls3D {
        WASD,
        MOUSE;

    }
}

