/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.alg.feature.detect.line.LineImageOps;
import boofcv.gui.image.ImageZoomPanel;
import georegression.metric.Distance2D_F32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public class ImageLinePanelZoom
extends ImageZoomPanel {
    public List<LineSegment2D_F32> lines = new ArrayList<LineSegment2D_F32>();
    protected Line2D.Double line = new Line2D.Double();
    protected int selectedLine = -1;

    public synchronized void setLines(List<LineParametric2D_F32> lines, int width, int height) {
        this.lines.clear();
        for (LineParametric2D_F32 p : lines) {
            LineSegment2D_F32 l = LineImageOps.convert(p, width, height);
            if (l == null) continue;
            this.lines.add(l);
        }
        this.selectedLine = -1;
    }

    public synchronized void setLineSegments(List<LineSegment2D_F32> lines) {
        this.lines.clear();
        this.lines.addAll(lines);
        this.selectedLine = -1;
    }

    public synchronized int findLine(double x, double y, float tolerance) {
        int bestLine = -1;
        float bestDistance = tolerance;
        for (int i = 0; i < this.lines.size(); ++i) {
            float d = Distance2D_F32.distance(this.lines.get(i), (float)x, (float)y);
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            bestLine = i;
        }
        return bestLine;
    }

    public void setSelected(int selected) {
        this.selectedLine = selected;
    }

    public int getSelected() {
        return this.selectedLine;
    }

    @Override
    protected synchronized void paintInPanel(AffineTransform tran, Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f));
        for (int i = 0; i < this.lines.size(); ++i) {
            LineSegment2D_F32 s = this.lines.get(i);
            this.line.x1 = this.scale * (double)s.a.x;
            this.line.y1 = this.scale * (double)s.a.y;
            this.line.x2 = this.scale * (double)s.b.x;
            this.line.y2 = this.scale * (double)s.b.y;
            if (i == this.selectedLine) {
                g2.setColor(Color.GREEN);
            } else {
                g2.setColor(Color.RED);
            }
            g2.draw(this.line);
            g2.setColor(Color.BLUE);
            g2.fillOval((int)this.line.x1 - 1, (int)this.line.y1 - 1, 3, 3);
            g2.fillOval((int)this.line.x2 - 1, (int)this.line.y2 - 1, 3, 3);
        }
    }
}

