/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.factory.feature.detect.selector.SelectLimitTypes;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.feature.ControlPanelExtractor;
import boofcv.gui.feature.ControlPanelSiftScaleSpace;
import boofcv.gui.image.ShowImages;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import org.jetbrains.annotations.Nullable;

public class ControlPanelSiftDetector
extends StandardAlgConfigPanel {
    public final ConfigSiftScaleSpace configSS;
    public final ConfigSiftDetector configDetector;
    private final ControlPanelExtractor controlExtractor;
    private final JSpinner spinnerMaxPerScale;
    private final JSpinner spinnerMaxAll;
    private final JComboBox<String> comboSelector;
    private final JSpinner spinnerEdgeResponse;
    private final ControlPanelSiftScaleSpace controlSS;
    private Listener listener;

    public ControlPanelSiftDetector(Listener listener) {
        this(new ConfigSiftScaleSpace(), new ConfigSiftDetector(), listener);
    }

    public ControlPanelSiftDetector(@Nullable ConfigSiftScaleSpace configSS_, @Nullable ConfigSiftDetector configDetector_, Listener listener) {
        this.configSS = configSS_ == null ? new ConfigSiftScaleSpace() : configSS_;
        this.configDetector = configDetector_ == null ? new ConfigSiftDetector() : configDetector_;
        this.listener = listener;
        this.controlExtractor = new ControlPanelExtractor(this.configDetector.extract, listener::handleChangeSiftDetector);
        this.controlSS = new ControlPanelSiftScaleSpace(this.configSS, listener::handleChangeSiftDetector);
        this.spinnerMaxPerScale = this.spinner(this.configDetector.maxFeaturesPerScale, 0, 9999, 100);
        this.spinnerMaxAll = this.spinner(this.configDetector.maxFeaturesAll, -1, 9999, 100);
        this.comboSelector = this.combo(this.configDetector.selector.type.ordinal(), (Object[])SelectLimitTypes.values());
        this.spinnerEdgeResponse = this.spinner(this.configDetector.edgeR, 1.0, 1000.0, 1.0);
        StandardAlgConfigPanel controlDetection = new StandardAlgConfigPanel();
        controlDetection.add(this.controlExtractor);
        controlDetection.addLabeled(this.spinnerMaxPerScale, "Max-Per-Scale", "Maximum number of features detected per scale");
        controlDetection.addLabeled(this.spinnerMaxAll, "Max-All", "Maximum number of features allowed");
        controlDetection.addLabeled(this.comboSelector, "Type", "Method used to select points when more have been detected than the maximum allowed");
        controlDetection.addLabeled(this.spinnerEdgeResponse, "Max Edge", "Maximum edge response. Larger values are more tolerant");
        this.controlExtractor.setBorder(BorderFactory.createEmptyBorder());
        this.controlSS.setBorder(BorderFactory.createTitledBorder("Scale-Space"));
        controlDetection.setBorder(BorderFactory.createTitledBorder("Detection"));
        this.add(controlDetection);
        this.add(this.controlSS);
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerMaxPerScale) {
            this.configDetector.maxFeaturesPerScale = ((Number)this.spinnerMaxPerScale.getValue()).intValue();
        } else if (source == this.spinnerMaxAll) {
            this.configDetector.maxFeaturesAll = ((Number)this.spinnerMaxAll.getValue()).intValue();
        } else if (source == this.comboSelector) {
            this.configDetector.selector.type = SelectLimitTypes.values()[this.comboSelector.getSelectedIndex()];
        } else if (source == this.spinnerEdgeResponse) {
            this.configDetector.edgeR = ((Number)this.spinnerEdgeResponse.getValue()).doubleValue();
        }
        this.listener.handleChangeSiftDetector();
    }

    public static void main(String[] args) {
        ControlPanelSiftDetector control = new ControlPanelSiftDetector(() -> {});
        ShowImages.showWindow(control, "Sift Detector", true);
    }

    public static interface Listener {
        public void handleChangeSiftDetector();
    }
}

