/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.detect.interest.ConfigPointDetector;
import boofcv.abst.feature.detect.interest.PointDetectorTypes;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.feature.ControlPanelFastCorner;
import boofcv.gui.feature.ControlPanelGeneralCorner;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;

public class ControlPanelPointDetector
extends StandardAlgConfigPanel {
    public ConfigPointDetector config;
    private final JComboBox<String> comboType;
    private final JSpinner spinnerScaleRadius;
    private final ControlPanelGeneralCorner controlGeneralCorner;
    private final JPanel panelSpecific = new JPanel(new BorderLayout());
    private final DefaultControls controlsDefault;
    private final ControlPanelFastCorner controlsFastCorner;
    Listener listener;

    public ControlPanelPointDetector(ConfigPointDetector config, Listener listener) {
        this.config = config;
        this.listener = listener;
        this.spinnerScaleRadius = this.spinner(config.scaleRadius, 1.0, 500.0, 1.0);
        this.comboType = this.combo(config.type.ordinal(), (Object[])PointDetectorTypes.FIRST_ONLY);
        this.controlGeneralCorner = new ControlPanelGeneralCorner(config.general, listener::handleChangePointDetector);
        this.controlsDefault = new DefaultControls();
        this.controlsFastCorner = new ControlPanelFastCorner(config.fast, listener::handleChangePointDetector);
        this.controlsFastCorner.setBorder(BorderFactory.createEmptyBorder());
        this.controlGeneralCorner.setBorder(BorderFactory.createEmptyBorder());
        this.handleTypeChange();
        this.addLabeled(this.comboType, "Type", "Type of corner or blob detector");
        this.addLabeled(this.spinnerScaleRadius, "Scale-Radius", "How large it tells a scale invariant descriptor to be. Radius in pixels");
        this.add(this.controlGeneralCorner);
        this.add(this.panelSpecific);
    }

    public <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> create(Class<T> imageType) {
        return FactoryDetectPoint.create(this.config, imageType, null);
    }

    void handleTypeChange() {
        this.panelSpecific.removeAll();
        if (this.config.type == PointDetectorTypes.FAST) {
            this.panelSpecific.add(this.controlsFastCorner);
        } else {
            this.panelSpecific.add(this.controlsDefault);
            this.controlsDefault.setWeighted();
            this.controlsDefault.setKernelSize();
        }
        this.panelSpecific.validate();
        this.panelSpecific.repaint();
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.comboType) {
            this.config.type = PointDetectorTypes.FIRST_ONLY[this.comboType.getSelectedIndex()];
            this.handleTypeChange();
        } else if (source == this.spinnerScaleRadius) {
            this.config.scaleRadius = ((Number)this.spinnerScaleRadius.getValue()).doubleValue();
        } else {
            throw new RuntimeException("Unknown source: " + BoofMiscOps.toString(source, o -> o.getClass().getSimpleName()));
        }
        this.listener.handleChangePointDetector();
    }

    public JComboBox<String> getComboType() {
        return this.comboType;
    }

    public JSpinner getSpinnerScaleRadius() {
        return this.spinnerScaleRadius;
    }

    public ControlPanelGeneralCorner getControlGeneralCorner() {
        return this.controlGeneralCorner;
    }

    public JPanel getPanelSpecific() {
        return this.panelSpecific;
    }

    public DefaultControls getControlsDefault() {
        return this.controlsDefault;
    }

    public ControlPanelFastCorner getControlsFastCorner() {
        return this.controlsFastCorner;
    }

    public static interface Listener {
        public void handleChangePointDetector();
    }

    private class DefaultControls
    extends StandardAlgConfigPanel {
        private final JSpinner spinnerKernel;
        private final JCheckBox checkWeighted;

        public DefaultControls() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.spinnerKernel = this.spinner(1, 1, 1000, 1);
            this.checkWeighted = this.checkbox("Weighted", false, "Gaussian weighted or block");
            this.setKernelSize();
            this.setWeighted();
            this.addLabeled(this.spinnerKernel, "Kernel", "Radius of convolutional kernel when computing feature intensity");
            this.addAlignCenter(this.checkWeighted);
        }

        private void setKernelSize() {
            int n;
            switch (ControlPanelPointDetector.this.config.type) {
                case SHI_TOMASI: {
                    n = ControlPanelPointDetector.this.config.shiTomasi.radius;
                    break;
                }
                case HARRIS: {
                    n = ControlPanelPointDetector.this.config.harris.radius;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            int radius = n;
            this.spinnerKernel.removeChangeListener(this);
            if (radius == -1) {
                this.spinnerKernel.setEnabled(false);
            } else {
                this.spinnerKernel.setEnabled(true);
                this.spinnerKernel.setValue(radius);
            }
            this.spinnerKernel.addChangeListener(this);
        }

        private void setWeighted() {
            this.checkWeighted.removeActionListener(this);
            switch (ControlPanelPointDetector.this.config.type) {
                case SHI_TOMASI: {
                    this.checkWeighted.setEnabled(true);
                    this.checkWeighted.setSelected(ControlPanelPointDetector.this.config.shiTomasi.weighted);
                    break;
                }
                case HARRIS: {
                    this.checkWeighted.setEnabled(true);
                    this.checkWeighted.setSelected(ControlPanelPointDetector.this.config.harris.weighted);
                    break;
                }
                default: {
                    this.checkWeighted.setEnabled(false);
                }
            }
            this.checkWeighted.addActionListener(this);
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerKernel) {
                switch (ControlPanelPointDetector.this.config.type) {
                    case SHI_TOMASI: {
                        ControlPanelPointDetector.this.config.shiTomasi.radius = ((Number)this.spinnerKernel.getValue()).intValue();
                        break;
                    }
                    case HARRIS: {
                        ControlPanelPointDetector.this.config.harris.radius = ((Number)this.spinnerKernel.getValue()).intValue();
                        break;
                    }
                }
            } else if (source == this.checkWeighted) {
                switch (ControlPanelPointDetector.this.config.type) {
                    case SHI_TOMASI: {
                        ControlPanelPointDetector.this.config.shiTomasi.weighted = this.checkWeighted.isSelected();
                        break;
                    }
                    case HARRIS: {
                        ControlPanelPointDetector.this.config.harris.weighted = this.checkWeighted.isSelected();
                        break;
                    }
                }
            } else {
                throw new RuntimeException("Unknown source: " + BoofMiscOps.toString(source, o -> o.getClass().getSimpleName()));
            }
            ControlPanelPointDetector.this.listener.handleChangePointDetector();
        }
    }
}

