/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.gui.StandardAlgConfigPanel;
import javax.swing.JSpinner;

public class ControlPanelExtractor
extends StandardAlgConfigPanel {
    public final ConfigExtract config;
    private final JSpinner spinnerRadius;
    private final JSpinner spinnerThreshold;
    private Listener listener;

    public ControlPanelExtractor(ConfigExtract config, Listener listener) {
        this.config = config;
        this.listener = listener;
        this.spinnerRadius = this.spinner(config.radius, 0, 999, 1);
        this.spinnerThreshold = this.spinner((double)config.threshold, 0.0, 100000.0, 1.0, "0.0E0", 8);
        this.addLabeled(this.spinnerRadius, "Radius", "Non-Maximum suppression radius");
        this.addLabeled(this.spinnerThreshold, "Threshold", "Minimum detection threshold. Set to 0 to disable");
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerRadius) {
            this.config.radius = ((Number)this.spinnerRadius.getValue()).intValue();
        } else if (source == this.spinnerThreshold) {
            this.config.threshold = ((Number)this.spinnerThreshold.getValue()).floatValue();
        }
        this.listener.handleExtractorChange();
    }

    public static interface Listener {
        public void handleExtractorChange();
    }
}

