/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.gui.StandardAlgConfigPanel;
import javax.swing.JSpinner;
import org.jetbrains.annotations.Nullable;

public class ControlPanelDescribeSift
extends StandardAlgConfigPanel {
    public final ConfigSiftDescribe config;
    private final JSpinner spinnerWidthSubregion;
    private final JSpinner spinnerWidthGrid;
    private final JSpinner spinnerHistogram;
    private final JSpinner spinnerSigmaToPixels;
    private final JSpinner spinnerWeightFraction;
    private final JSpinner spinnerMaxElementFraction;
    Listener listener;

    public ControlPanelDescribeSift(@Nullable ConfigSiftDescribe config_, Listener listener) {
        this.config = config_ == null ? new ConfigSiftDescribe() : config_;
        this.listener = listener;
        this.spinnerWidthSubregion = this.spinner(this.config.widthSubregion, 1, 50, 1);
        this.spinnerWidthGrid = this.spinner(this.config.widthGrid, 1, 50, 1);
        this.spinnerHistogram = this.spinner(this.config.numHistogramBins, 1, 50, 1);
        this.spinnerSigmaToPixels = this.spinner(this.config.sigmaToPixels, 0.1, 100.0, 0.5);
        this.spinnerWeightFraction = this.spinner(this.config.weightingSigmaFraction, 1.0E-4, 1.0, 0.05, "0.0E0", 10);
        this.spinnerMaxElementFraction = this.spinner(this.config.maxDescriptorElementValue, 1.0E-5, 1.0, 0.01, "0.0E0", 10);
        this.addLabeled(this.spinnerWidthSubregion, "Subregion", "Width of sub-region in samples");
        this.addLabeled(this.spinnerWidthGrid, "Grid", "Width of grid in subregions");
        this.addLabeled(this.spinnerHistogram, "Histogram", "Number of histogram bins");
        this.addLabeled(this.spinnerSigmaToPixels, "Sigma Pixels", "Conversion of sigma to pixels.  Used to scale the descriptor region");
        this.addLabeled(this.spinnerWeightFraction, "Sigma Frac.", "Sigma for Gaussian weighting function is set to this value * region width");
        this.addLabeled(this.spinnerMaxElementFraction, "Max Frac.", "Maximum fraction a single element can have in descriptor. Helps with non-affine changes in lighting. See paper");
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.spinnerWidthSubregion) {
            this.config.widthSubregion = ((Number)this.spinnerWidthSubregion.getValue()).intValue();
        } else if (source == this.spinnerWidthGrid) {
            this.config.widthGrid = ((Number)this.spinnerWidthGrid.getValue()).intValue();
        } else if (source == this.spinnerHistogram) {
            this.config.numHistogramBins = ((Number)this.spinnerHistogram.getValue()).intValue();
        } else if (source == this.spinnerSigmaToPixels) {
            this.config.sigmaToPixels = ((Number)this.spinnerSigmaToPixels.getValue()).doubleValue();
        } else if (source == this.spinnerWeightFraction) {
            this.config.weightingSigmaFraction = ((Number)this.spinnerWeightFraction.getValue()).doubleValue();
        } else if (source == this.spinnerMaxElementFraction) {
            this.config.maxDescriptorElementValue = ((Number)this.spinnerMaxElementFraction.getValue()).doubleValue();
        }
        this.listener.handleChangeDescribeSift();
    }

    public static interface Listener {
        public void handleChangeDescribeSift();
    }
}

