/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.gui.BoofSwingUtil;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import javax.swing.JPanel;
import org.ejml.data.DGrowArray;

public class AssociatedTriplePanel
extends JPanel {
    final Object lock = new Object();
    BufferedImage image1;
    BufferedImage image2;
    BufferedImage image3;
    DGrowArray points = new DGrowArray();
    Color[] colors;
    int sep = 10;
    double offX;
    double offY;
    Affine2D_F64 affine1 = new Affine2D_F64();
    Affine2D_F64 affine2 = new Affine2D_F64();
    Affine2D_F64 affine3 = new Affine2D_F64();
    Point2D_F64 p1 = new Point2D_F64();
    Point2D_F64 p2 = new Point2D_F64();
    Point2D_F64 p3 = new Point2D_F64();
    Mode mode = Mode.POINTS;
    int singlePoint = -1;

    public AssociatedTriplePanel() {
        this.addMouseListener(new MouseHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImages(BufferedImage image1, BufferedImage image2, BufferedImage image3) {
        Object object = this.lock;
        synchronized (object) {
            this.image1 = image1;
            this.image2 = image2;
            this.image3 = image3;
            int w = image2.getWidth() + this.sep + image3.getWidth();
            int h = Math.max(image2.getHeight(), image3.getHeight()) + this.sep + image1.getHeight();
            double scale = BoofSwingUtil.selectZoomToFitInDisplay(w, h);
            this.setPreferredSize(new Dimension((int)((double)w * scale), (int)((double)h * scale)));
            this.setMaximumSize(new Dimension(w, h));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAssociation(List<AssociatedTriple> triples) {
        Random rand = new Random(234L);
        Object object = this.lock;
        synchronized (object) {
            this.points.reshape(triples.size() * 6);
            this.colors = new Color[triples.size()];
            int idx = 0;
            for (int i = 0; i < triples.size(); ++i) {
                AssociatedTriple a = triples.get(i);
                this.points.data[idx++] = a.p1.x;
                this.points.data[idx++] = a.p1.y;
                this.points.data[idx++] = a.p2.x;
                this.points.data[idx++] = a.p2.y;
                this.points.data[idx++] = a.p3.x;
                this.points.data[idx++] = a.p3.y;
                this.colors[i] = new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paintComponent(Graphics g) {
        BufferedImage image3;
        BufferedImage image2;
        BufferedImage image1;
        super.paintComponent(g);
        Object object = this.lock;
        synchronized (object) {
            if (this.image1 == null || this.image2 == null || this.image3 == null) {
                return;
            }
            image1 = this.image1;
            image2 = this.image2;
            image3 = this.image3;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int sep = 10;
        int w = image2.getWidth() + sep + image3.getWidth();
        int h = Math.max(image2.getHeight(), image3.getHeight()) + sep + image1.getHeight();
        double scale = Math.min(Math.min((double)this.getWidth() / (double)w, (double)this.getHeight() / (double)h), 1.0);
        int x0 = (int)((double)(this.getWidth() / 2) - (double)image1.getWidth() * scale * 0.5);
        int x1 = (int)((double)x0 + (double)image1.getWidth() * scale);
        int y1 = (int)((double)image1.getHeight() * scale);
        g2.drawImage(image1, x0, 0, x1, y1, 0, 0, image1.getWidth(), image1.getHeight(), null);
        int x2 = (int)((double)(this.getWidth() / 2) - (double)w * scale * 0.5);
        int x3 = x2 + (int)((double)image2.getWidth() * scale);
        int y2 = y1 + sep;
        int y3 = y2 + (int)((double)image2.getHeight() * scale);
        g2.drawImage(image2, x2, y2, x3, y3, 0, 0, image2.getWidth(), image2.getHeight(), null);
        int x4 = x3 + sep;
        int x5 = x4 + (int)((double)image3.getWidth() * scale);
        int y4 = y2 + (int)((double)image3.getHeight() * scale);
        g2.drawImage(image3, x4, y2, x5, y4, 0, 0, image3.getWidth(), image3.getHeight(), null);
        this.affine1.setTo(scale, 0.0, 0.0, scale, x0, 0.0);
        this.affine2.setTo(scale, 0.0, 0.0, scale, x2, y2);
        this.affine3.setTo(scale, 0.0, 0.0, scale, x4, y2);
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.singlePoint >= 0 && this.singlePoint < this.colors.length) {
                this.drawSingleLine(g2);
            } else {
                switch (this.mode) {
                    case NONE: {
                        break;
                    }
                    case LINES: {
                        this.drawLines(g2);
                        break;
                    }
                    case POINTS: {
                        this.drawPoints(g2);
                    }
                }
            }
        }
    }

    private void drawSingleLine(Graphics2D g2) {
        g2.setStroke(new BasicStroke(4.0f));
        Line2D.Double line = new Line2D.Double();
        int i = this.singlePoint * 6;
        this.p1.setTo(this.offX + this.points.data[i], this.offY + this.points.data[i + 1]);
        this.p2.setTo(this.offX + this.points.data[i + 2], this.offY + this.points.data[i + 3]);
        this.p3.setTo(this.offX + this.points.data[i + 4], this.offY + this.points.data[i + 5]);
        AssociatedTriplePanel.transform(this.affine1, this.p1);
        AssociatedTriplePanel.transform(this.affine2, this.p2);
        AssociatedTriplePanel.transform(this.affine3, this.p3);
        g2.setColor(this.colors[i / 6]);
        line.x1 = this.p1.x;
        line.y1 = this.p1.y;
        line.x2 = this.p2.x;
        line.y2 = this.p2.y;
        g2.draw(line);
        line.x2 = this.p3.x;
        line.y2 = this.p3.y;
        g2.draw(line);
        line.x1 = this.p2.x;
        line.y1 = this.p2.y;
        g2.draw(line);
    }

    private void drawLines(Graphics2D g2) {
        g2.setStroke(new BasicStroke(1.0f));
        Line2D.Double line = new Line2D.Double();
        for (int i = 0; i < this.points.length; i += 6) {
            this.p1.setTo(this.offX + this.points.data[i], this.offY + this.points.data[i + 1]);
            this.p2.setTo(this.offX + this.points.data[i + 2], this.offY + this.points.data[i + 3]);
            this.p3.setTo(this.offX + this.points.data[i + 4], this.offY + this.points.data[i + 5]);
            AssociatedTriplePanel.transform(this.affine1, this.p1);
            AssociatedTriplePanel.transform(this.affine2, this.p2);
            AssociatedTriplePanel.transform(this.affine3, this.p3);
            g2.setColor(this.colors[i / 6]);
            line.x1 = this.p1.x;
            line.y1 = this.p1.y;
            line.x2 = this.p2.x;
            line.y2 = this.p2.y;
            g2.draw(line);
            line.x2 = this.p3.x;
            line.y2 = this.p3.y;
            g2.draw(line);
            line.x1 = this.p2.x;
            line.y1 = this.p2.y;
            g2.draw(line);
        }
    }

    private void drawPoints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f));
        Ellipse2D.Double circle = new Ellipse2D.Double();
        double r = 4.0;
        double w = r * 2.0 + 1.0;
        for (int i = 0; i < this.points.length; i += 6) {
            this.p1.setTo(this.offX + this.points.data[i], this.offY + this.points.data[i + 1]);
            this.p2.setTo(this.offX + this.points.data[i + 2], this.offY + this.points.data[i + 3]);
            this.p3.setTo(this.offX + this.points.data[i + 4], this.offY + this.points.data[i + 5]);
            AssociatedTriplePanel.transform(this.affine1, this.p1);
            AssociatedTriplePanel.transform(this.affine2, this.p2);
            AssociatedTriplePanel.transform(this.affine3, this.p3);
            g2.setColor(this.colors[i / 6]);
            circle.setFrame(this.p1.x - r, this.p1.y - r, w, w);
            g2.draw(circle);
            circle.setFrame(this.p2.x - r, this.p2.y - r, w, w);
            g2.draw(circle);
            circle.setFrame(this.p3.x - r, this.p3.y - r, w, w);
            g2.draw(circle);
        }
    }

    private static void transform(Affine2D_F64 t, Point2D_F64 p) {
        double x = p.x * t.a11 + p.y * t.a12 + t.tx;
        double y = p.x * t.a21 + p.y * t.a22 + t.ty;
        p.setTo(x, y);
    }

    public void setPixelOffset(double x, double y) {
        this.offX = x;
        this.offY = y;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    static enum Mode {
        NONE,
        LINES,
        POINTS;

    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (BoofSwingUtil.isRightClick(e)) {
                AssociatedTriplePanel.this.mode = Mode.values()[(AssociatedTriplePanel.this.mode.ordinal() + 1) % Mode.values().length];
                AssociatedTriplePanel.this.repaint();
            } else {
                double x = e.getX();
                double y = e.getY();
                int bestIndex = -1;
                double bestDistance = Double.MAX_VALUE;
                for (int i = 0; i < AssociatedTriplePanel.this.points.length; i += 6) {
                    AssociatedTriplePanel.this.p1.setTo(AssociatedTriplePanel.this.offX + AssociatedTriplePanel.this.points.data[i], AssociatedTriplePanel.this.offY + AssociatedTriplePanel.this.points.data[i + 1]);
                    AssociatedTriplePanel.this.p2.setTo(AssociatedTriplePanel.this.offX + AssociatedTriplePanel.this.points.data[i + 2], AssociatedTriplePanel.this.offY + AssociatedTriplePanel.this.points.data[i + 3]);
                    AssociatedTriplePanel.this.p3.setTo(AssociatedTriplePanel.this.offX + AssociatedTriplePanel.this.points.data[i + 4], AssociatedTriplePanel.this.offY + AssociatedTriplePanel.this.points.data[i + 5]);
                    AssociatedTriplePanel.transform(AssociatedTriplePanel.this.affine1, AssociatedTriplePanel.this.p1);
                    AssociatedTriplePanel.transform(AssociatedTriplePanel.this.affine2, AssociatedTriplePanel.this.p2);
                    AssociatedTriplePanel.transform(AssociatedTriplePanel.this.affine3, AssociatedTriplePanel.this.p3);
                    double d = AssociatedTriplePanel.this.p1.distance2(x, y);
                    d = Math.min(d, AssociatedTriplePanel.this.p2.distance2(x, y));
                    d = Math.min(d, AssociatedTriplePanel.this.p3.distance2(x, y));
                    if (!(d < bestDistance)) continue;
                    bestDistance = d;
                    bestIndex = i / 6;
                }
                if (bestIndex >= 0 && bestDistance < 100.0) {
                    AssociatedTriplePanel.this.singlePoint = bestIndex;
                    AssociatedTriplePanel.this.repaint();
                } else if (AssociatedTriplePanel.this.singlePoint != -1) {
                    AssociatedTriplePanel.this.singlePoint = -1;
                    AssociatedTriplePanel.this.repaint();
                }
            }
        }
    }
}

