/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.dialogs;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.dialogs.FileBrowser;
import boofcv.gui.dialogs.JSpringPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedU8;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FilePreviewChooser
extends JPanel {
    private static final int PREVIEW_PIXELS = 300;
    protected Listener listener;
    FileBrowser browser;
    ImagePanel preview = new ImagePanel();
    JTextArea metadataText = new JTextArea();
    File selected;
    boolean openFile;
    JButton bSelect;
    private final Object lockPreview = new Object();
    PreviewThread previewThread;
    String pendingPreview;

    public FilePreviewChooser(boolean openFile) {
        this.setLayout(new BorderLayout());
        this.openFile = openFile;
        String buttonText = openFile ? "Select" : "Save";
        this.bSelect = BoofSwingUtil.button(buttonText, e -> this.handlePressedSelect());
        this.bSelect.setEnabled(false);
        this.bSelect.setDefaultCapable(true);
        JButton bCancel = BoofSwingUtil.button("Cancel", e -> this.handlePressedCancel());
        JPanel bottomPanel = JSpringPanel.createLockedSides(bCancel, this.bSelect, 35);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.metadataText.setEditable(false);
        this.metadataText.setWrapStyleWord(true);
        this.metadataText.setLineWrap(true);
        this.preview.setCentering(true);
        this.preview.setPreferredSize(new Dimension(330, 330));
        JSplitPane splitPreview = new JSplitPane(0, this.preview, this.metadataText);
        splitPreview.setDividerLocation(0.9);
        splitPreview.setContinuousLayout(true);
        this.browser = new FileBrowser(new File("."), null, new BrowserListener());
        this.browser.setSelectionMode(0);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add("Center", this.browser);
        leftPanel.add("South", bottomPanel);
        JSplitPane splitBrowserPreview = new JSplitPane(1, leftPanel, splitPreview);
        splitBrowserPreview.setDividerLocation(300);
        splitBrowserPreview.setResizeWeight(0.0);
        splitBrowserPreview.setContinuousLayout(true);
        this.add((Component)splitBrowserPreview, "Center");
        this.setPreferredSize(new Dimension(600, 400));
        this.bSelect.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                FilePreviewChooser.this.setSelectEnabled(FilePreviewChooser.this.bSelect.isEnabled());
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    void handlePressedSelect() {
        if (this.listener == null) {
            System.err.println("You didn't set a listener!");
        } else {
            this.listener.selectedFile(this.selected);
        }
    }

    protected void handlePressedCancel() {
        if (this.listener == null) {
            System.err.println("You didn't set a listener!");
        } else {
            this.listener.userCanceled();
        }
    }

    public void setDirectory(File directory) {
        BoofSwingUtil.checkGuiThread();
        if (directory.isFile()) {
            directory = directory.getParentFile();
        }
        this.browser.setDirectory(directory);
    }

    private void setSelectEnabled(boolean enabled) {
        if (enabled) {
            this.bSelect.setEnabled(true);
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            if (rootPane != null) {
                rootPane.setDefaultButton(this.bSelect);
            }
        } else {
            this.bSelect.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showPreview(String path) {
        Object object = this.lockPreview;
        synchronized (object) {
            if (path == null) {
                this.pendingPreview = null;
            } else if (this.previewThread == null) {
                this.pendingPreview = path;
                this.previewThread = new PreviewThread();
                this.previewThread.start();
            } else {
                this.pendingPreview = path;
            }
        }
    }

    private BufferedImage loadVideoPreview(String path) {
        BufferedImage full = null;
        try {
            SimpleImageSequence<InterleavedU8> sequence = DefaultMediaManager.INSTANCE.openVideo(path, ImageType.IL_U8);
            if (sequence.hasNext()) {
                InterleavedU8 frame = sequence.next();
                full = ConvertBufferedImage.convertTo(frame, null, true);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return full;
    }

    public File showDialog(Component parent) {
        String title = this.openFile ? "Open File" : "Save File";
        JDialog dialog = new JDialog(null, title, Dialog.ModalityType.APPLICATION_MODAL);
        DefaultListener listener = new DefaultListener(dialog);
        this.listener = listener;
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FilePreviewChooser.this.handlePressedCancel();
            }
        });
        dialog.setDefaultCloseOperation(0);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        dialog.dispose();
        if (listener.canceled) {
            return null;
        }
        return listener.selectedFile;
    }

    public static void main(String[] args) {
        FilePreviewChooser chooser = new FilePreviewChooser(true);
        File selected = chooser.showDialog(null);
        if (selected == null) {
            System.out.println("Canceled");
        } else {
            System.out.println(selected.getPath());
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Listener getListener() {
        return this.listener;
    }

    public FileBrowser getBrowser() {
        return this.browser;
    }

    public boolean isOpenFile() {
        return this.openFile;
    }

    private class BrowserListener
    implements FileBrowser.Listener {
        private BrowserListener() {
        }

        @Override
        public void handleSelectedFile(File file) {
            if (FilePreviewChooser.this.selected == file) {
                return;
            }
            if (FilePreviewChooser.this.selected != null && file != null && file.getAbsolutePath().equals(FilePreviewChooser.this.selected.getAbsolutePath())) {
                return;
            }
            if (file == null) {
                FilePreviewChooser.this.selected = null;
                FilePreviewChooser.this.showPreview(null);
                FilePreviewChooser.this.setSelectEnabled(false);
            } else if (file.isFile()) {
                FilePreviewChooser.this.selected = file;
                FilePreviewChooser.this.showPreview(file.getPath());
                FilePreviewChooser.this.setSelectEnabled(true);
            } else if (FilePreviewChooser.this.selected != null) {
                FilePreviewChooser.this.selected = null;
                FilePreviewChooser.this.showPreview(null);
                FilePreviewChooser.this.setSelectEnabled(false);
            }
        }

        @Override
        public void handleDoubleClickedFile(File file) {
            FilePreviewChooser.this.selected = file;
            FilePreviewChooser.this.handlePressedSelect();
        }
    }

    public static interface Listener {
        public void selectedFile(File var1);

        public void userCanceled();
    }

    private class PreviewThread
    extends Thread {
        public PreviewThread() {
            super("Image Preview");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                double scale;
                int h;
                String path;
                Object object = FilePreviewChooser.this.lockPreview;
                synchronized (object) {
                    if (FilePreviewChooser.this.pendingPreview == null) {
                        FilePreviewChooser.this.previewThread = null;
                        return;
                    }
                    path = FilePreviewChooser.this.pendingPreview;
                    FilePreviewChooser.this.pendingPreview = null;
                }
                File file = new File(path);
                if (!file.exists() || file.isDirectory()) continue;
                BufferedImage full = null;
                if (UtilImageIO.isImage(file)) {
                    full = UtilImageIO.loadImage(path);
                }
                if (full == null) {
                    full = FilePreviewChooser.this.loadVideoPreview(path);
                }
                String date = BoofMiscOps.timeStr(file.lastModified());
                if (full == null) {
                    FilePreviewChooser.this.preview.setImageRepaint(null);
                    FilePreviewChooser.this.metadataText.setText("File Size: " + file.length() + " B\nModified: " + date);
                    continue;
                }
                int w = full.getWidth();
                if (w > (h = full.getHeight())) {
                    scale = 300.0 / (double)w;
                    h = h * 300 / w;
                    w = 300;
                } else {
                    scale = 300.0 / (double)h;
                    w = w * 300 / h;
                    h = 300;
                }
                BufferedImage small = new BufferedImage(w, h, full.getType());
                Graphics2D g2 = small.createGraphics();
                g2.setTransform(new AffineTransform(scale, 0.0, 0.0, scale, 0.0, 0.0));
                g2.drawImage((Image)full, 0, 0, null);
                FilePreviewChooser.this.preview.setImageRepaint(small);
                FilePreviewChooser.this.metadataText.setText(String.format("Shape: %d x %d\nModified: %s", full.getWidth(), full.getHeight(), date));
            }
        }
    }

    public static class DefaultListener
    implements Listener {
        JDialog dialog;
        public File selectedFile;
        public boolean canceled = false;

        public DefaultListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void selectedFile(File file) {
            this.selectedFile = file;
            this.dialog.setVisible(false);
        }

        @Override
        public void userCanceled() {
            this.canceled = true;
            this.dialog.setVisible(false);
        }
    }
}

